/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.dao.jpa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.task.dao.OrderBy;
import org.exoplatform.task.dao.TaskHandler;
import org.exoplatform.task.dao.TaskQuery;
import org.exoplatform.task.domain.Task;

public class TaskDAOImpl
extends GenericDAOJPAImpl<Task, Long>
implements TaskHandler {
    private EntityManagerService entityService;

    public TaskDAOImpl(EntityManagerService entityService) {
        this.entityService = entityService;
    }

    public EntityManager getEntityManager() {
        return this.entityService.getEntityManager();
    }

    @Override
    public List<Task> findByProject(Long projectId) {
        EntityManager em = this.getEntityManager();
        TypedQuery query = em.createNamedQuery("Task.findTaskByProject", Task.class);
        query.setParameter("projectId", (Object)projectId);
        return query.getResultList();
    }

    @Override
    public List<Task> findByUser(String user) {
        ArrayList<String> memberships = new ArrayList<String>();
        memberships.add(user);
        return this.findAllByMembership(user, memberships);
    }

    @Override
    public List<Task> findAllByMembership(String user, List<String> memberships) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Task.findByMemberships", Task.class);
        query.setParameter("userName", (Object)user);
        query.setParameter("memberships", memberships);
        return query.getResultList();
    }

    @Override
    public List<Task> findByTag(String tag) {
        return null;
    }

    @Override
    public List<Task> findByTags(List<String> tags) {
        return null;
    }

    @Override
    public List<Task> findTaskByQuery(TaskQuery query) {
        EntityManager em = this.getEntityManager();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery q = cb.createQuery(Task.class);
        Root task = q.from(Task.class);
        q.select((Selection)task);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (query.getTaskId() > 0L) {
            predicates.add(cb.equal((Expression)task.get("id"), (Object)query.getTaskId()));
        }
        if (query.getTitle() != null && !query.getTitle().isEmpty()) {
            predicates.add(cb.like((Expression)task.get("title"), "%" + query.getTitle() + "%"));
        }
        if (query.getDescription() != null && !query.getDescription().isEmpty()) {
            predicates.add(cb.like((Expression)task.get("description"), '%' + query.getDescription() + '%'));
        }
        if (query.getAssignee() != null && !query.getAssignee().isEmpty()) {
            predicates.add(cb.like((Expression)task.get("assignee"), '%' + query.getAssignee() + '%'));
        }
        if (query.getProjectIds() != null) {
            if (query.getProjectIds().size() == 1 && query.getProjectIds().get(0) == 0L) {
                predicates.add(cb.isNotNull((Expression)task.get("status")));
            } else {
                if (query.getProjectIds().isEmpty()) {
                    return Collections.emptyList();
                }
                predicates.add(task.get("status").get("project").get("id").in(query.getProjectIds()));
            }
        }
        if (query.getKeyword() != null && !query.getKeyword().isEmpty()) {
            String keyword = "%" + query.getKeyword() + "%";
            predicates.add(cb.or(new Predicate[]{cb.like((Expression)task.get("title"), keyword), cb.like((Expression)task.get("description"), keyword), cb.like((Expression)task.get("assignee"), keyword)}));
        }
        if (query.getCompleted() != null) {
            if (query.getCompleted().booleanValue()) {
                predicates.add(cb.equal((Expression)task.get("completed"), (Object)query.getCompleted()));
            } else {
                predicates.add(cb.notEqual((Expression)task.get("completed"), (Object)(query.getCompleted() == false ? 1 : 0)));
            }
        }
        if (predicates.size() > 0) {
            Iterator it = predicates.iterator();
            Predicate p = (Predicate)it.next();
            while (it.hasNext()) {
                p = cb.and((Expression)p, (Expression)it.next());
            }
            q.where((Expression)p);
        }
        if (query.getOrderBy() != null && !query.getOrderBy().isEmpty()) {
            List<OrderBy> orderBies = query.getOrderBy();
            Order[] orders = new Order[orderBies.size()];
            for (int i = 0; i < orders.length; ++i) {
                OrderBy orderBy = orderBies.get(i);
                Path p = task.get(orderBy.getFieldName());
                orders[i] = orderBy.isAscending() ? cb.asc((Expression)p) : cb.desc((Expression)p);
            }
            q.orderBy(orders);
        }
        return em.createQuery(q).getResultList();
    }

    @Override
    public List<Task> getIncomingTask(String username, OrderBy orderBy) {
        StringBuilder jql = new StringBuilder();
        jql.append("SELECT ta FROM Task ta LEFT JOIN ta.coworker cowoker ").append("WHERE ta.status.id is null ").append("AND (ta.assignee = :userName OR ta.createdBy = :userName OR cowoker = :userName)").append(" AND ta.completed = FALSE");
        if (orderBy != null && !orderBy.getFieldName().isEmpty()) {
            jql.append(" ORDER BY ta.").append(orderBy.getFieldName()).append(" ").append(orderBy.isAscending() ? "ASC" : " DESC");
        }
        return this.getEntityManager().createQuery(jql.toString(), Task.class).setParameter("userName", (Object)username).getResultList();
    }

    @Override
    public List<Task> getToDoTask(String username, List<Long> projectIds, OrderBy orderBy, Date fromDueDate, Date toDueDate) {
        StringBuilder jql = new StringBuilder();
        jql.append("SELECT ta FROM Task ta ").append("WHERE ta.assignee = :userName ").append("AND ta.completed = FALSE ").append("AND ta.dueDate IS NOT NULL ");
        if (projectIds != null && !projectIds.isEmpty()) {
            jql.append("AND ta.status.project.id IN (:projectIds) ");
        }
        if (fromDueDate != null) {
            jql.append("AND ta.dueDate >= :fromDueDate ");
        }
        if (toDueDate != null) {
            jql.append("AND ta.dueDate <= :toDueDate ");
        }
        if (orderBy != null && !orderBy.getFieldName().isEmpty()) {
            jql.append(" ORDER BY ta.").append(orderBy.getFieldName()).append(" ").append(orderBy.isAscending() ? "ASC" : " DESC");
        }
        TypedQuery query = this.getEntityManager().createQuery(jql.toString(), Task.class);
        query.setParameter("userName", (Object)username);
        if (projectIds != null && !projectIds.isEmpty()) {
            query.setParameter("projectIds", projectIds);
        }
        if (fromDueDate != null) {
            query.setParameter("fromDueDate", (Object)fromDueDate);
        }
        if (toDueDate != null) {
            query.setParameter("toDueDate", (Object)toDueDate);
        }
        return query.getResultList();
    }

    @Override
    public long getTaskNum(String userName, List<Long> projectIds) {
        if (userName == null && (projectIds == null || projectIds.isEmpty())) {
            return 0L;
        }
        StringBuilder jql = new StringBuilder();
        jql.append("SELECT count(*) FROM Task ta");
        if (userName != null) {
            jql.append(" LEFT JOIN ta.coworker cowoker ");
        }
        jql.append(" WHERE ");
        if (userName != null) {
            jql.append("(ta.assignee = :userName OR ta.createdBy = :userName OR cowoker = :userName)");
            if (projectIds != null && !projectIds.isEmpty() && projectIds.get(0) != -2L) {
                jql.append(" AND");
            }
        }
        boolean needParam = false;
        if (projectIds != null && !projectIds.isEmpty()) {
            if (projectIds.size() == 1 && projectIds.get(0) <= 0L) {
                if (projectIds.get(0) == 0L) {
                    jql.append(" NOT ta.status is null");
                } else if (projectIds.get(0) == -1L) {
                    jql.append(" ta.status is null");
                }
            } else {
                needParam = true;
                jql.append(" ta.status.project.id IN (:projectIds)");
            }
        }
        Query query = this.getEntityManager().createQuery(jql.toString());
        if (userName != null) {
            query.setParameter("userName", (Object)userName);
        }
        if (needParam) {
            query.setParameter("projectIds", projectIds);
        }
        return (Long)query.getSingleResult();
    }
}

