/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.domain;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.exoplatform.task.domain.Comment;
import org.exoplatform.task.domain.Priority;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.TaskLog;
import org.exoplatform.task.service.TaskBuilder;

@Entity
@Table(name="TASK_TASKS")
@NamedQueries(value={@NamedQuery(name="Task.findByMemberships", query="SELECT ta FROM Task ta LEFT JOIN ta.coworker coworkers WHERE ta.assignee = :userName OR ta.createdBy = :userName OR coworkers = :userName OR ta.status IN (SELECT st.id FROM Status st WHERE project IN (SELECT pr1.id FROM Project pr1 LEFT JOIN pr1.manager managers WHERE managers IN :memberships) OR project IN (SELECT pr2.id FROM Project pr2 LEFT JOIN pr2.participator participators WHERE participators IN :memberships) ) "), @NamedQuery(name="Task.findTaskByProject", query="SELECT t FROM Task t WHERE t.status.project.id = :projectId")})
public class Task {
    private static final String PREFIX_CLONE = "Copy of ";
    @Id
    @GeneratedValue
    @Column(name="TASK_ID")
    private long id;
    private String title;
    private String description;
    @Enumerated(value=EnumType.STRING)
    private Priority priority;
    private String context;
    private String assignee;
    @ManyToOne
    @JoinColumn(name="STATUS_ID")
    private Status status;
    private boolean completed = false;
    @ElementCollection
    @CollectionTable(name="TASK_TASK_COWORKERS", joinColumns={@JoinColumn(name="TASK_ID")})
    private Set<String> coworker = new HashSet<String>();
    @ElementCollection
    @CollectionTable(name="TASK_TAGS", joinColumns={@JoinColumn(name="TASK_ID")})
    private Set<String> tags = new HashSet<String>();
    @Column(name="CREATED_BY")
    private String createdBy;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="CREATED_TIME")
    private Date createdTime;
    private long duration;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="START_DATE")
    private Date startDate;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DUE_DATE")
    private Date dueDate;
    @OneToMany(mappedBy="task", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<Comment> comments = new HashSet<Comment>();
    @ElementCollection(fetch=FetchType.LAZY)
    @CollectionTable(name="TASK_LOGS", joinColumns={@JoinColumn(name="TASK_ID")})
    private Set<TaskLog> taskLogs = new HashSet<TaskLog>();

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void setCompleted(boolean completed) {
        this.completed = completed;
    }

    public Set<String> getTags() {
        return this.tags != null ? Collections.unmodifiableSet(this.tags) : Collections.emptySet();
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    public void addTag(String tag) {
        if (this.tags == null) {
            this.tags = new HashSet<String>();
        }
        this.tags.add(tag);
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public Set<String> getCoworker() {
        return this.coworker;
    }

    public void setCoworker(Set<String> coworker) {
        this.coworker = coworker;
    }

    public Set<Comment> getComments() {
        return this.comments;
    }

    public void setComments(Set<Comment> comments) {
        this.comments = comments;
    }

    public Set<TaskLog> getTaskLogs() {
        return this.taskLogs;
    }

    public void setTaskLogs(Set<TaskLog> taskLogs) {
        this.taskLogs = taskLogs;
    }

    public Task clone() {
        Task newTask = new TaskBuilder().withTitle(PREFIX_CLONE + this.getTitle()).withAssignee(this.getAssignee()).withContext(this.getContext()).withCreatedBy(this.getCreatedBy()).withDescription(this.getDescription()).withDueDate(this.getDueDate()).withPriority(this.getPriority()).withStartDate(this.getStartDate()).withDuration(this.getDuration()).withStatus(this.status).build();
        newTask.setCoworker(new HashSet<String>(this.getCoworker()));
        newTask.setTags(new HashSet<String>(this.getTags()));
        return newTask;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Task task = (Task)o;
        if (this.completed != task.completed) {
            return false;
        }
        if (this.duration != task.duration) {
            return false;
        }
        if (this.id != task.id) {
            return false;
        }
        if (this.assignee != null ? !this.assignee.equals(task.assignee) : task.assignee != null) {
            return false;
        }
        if (this.comments != null ? !this.comments.equals(task.comments) : task.comments != null) {
            return false;
        }
        if (this.context != null ? !this.context.equals(task.context) : task.context != null) {
            return false;
        }
        if (this.coworker != null ? !this.coworker.equals(task.coworker) : task.coworker != null) {
            return false;
        }
        if (this.createdBy != null ? !this.createdBy.equals(task.createdBy) : task.createdBy != null) {
            return false;
        }
        if (this.createdTime != null ? !this.createdTime.equals(task.createdTime) : task.createdTime != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(task.description) : task.description != null) {
            return false;
        }
        if (this.dueDate != null ? !this.dueDate.equals(task.dueDate) : task.dueDate != null) {
            return false;
        }
        if (this.priority != task.priority) {
            return false;
        }
        if (this.startDate != null ? !this.startDate.equals(task.startDate) : task.startDate != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(task.status) : task.status != null) {
            return false;
        }
        if (this.tags != null ? !this.tags.equals(task.tags) : task.tags != null) {
            return false;
        }
        return !(this.title != null ? !this.title.equals(task.title) : task.title != null);
    }
}

