/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.service.impl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.exoplatform.commons.api.persistence.Transactional;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.task.dao.OrderBy;
import org.exoplatform.task.dao.TaskQuery;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.exception.NotAllowedOperationOnEntityException;
import org.exoplatform.task.exception.ParameterEntityException;
import org.exoplatform.task.exception.ProjectNotFoundException;
import org.exoplatform.task.service.DAOHandler;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.StatusService;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.utils.ProjectUtil;
import org.exoplatform.task.utils.UserUtils;

@Singleton
public class ProjectServiceImpl
implements ProjectService {
    private static final Log LOG = ExoLogger.getExoLogger(ProjectServiceImpl.class);
    @Inject
    StatusService statusService;
    @Inject
    TaskService taskService;
    @Inject
    DAOHandler daoHandler;

    public ProjectServiceImpl() {
    }

    public ProjectServiceImpl(StatusService statusService, TaskService taskService, DAOHandler daoHandler) {
        this.daoHandler = daoHandler;
        this.statusService = statusService;
        this.taskService = taskService;
    }

    @Override
    @Transactional
    public Project createDefaultStatusProjectWithManager(String name, String description, Long parentId, String username) throws ProjectNotFoundException {
        HashSet<String> managers = new HashSet<String>();
        managers.add(username);
        return this.createDefaultStatusProjectWithAttributes(parentId, name, description, managers, Collections.<String>emptySet());
    }

    @Override
    @Transactional
    public Project createDefaultStatusProjectWithAttributes(Long parentId, String name, String description, Set<String> managers, Set<String> participators) throws ProjectNotFoundException {
        Project project = new Project(name, description, new HashSet<Status>(), managers, participators);
        if (parentId != null && parentId != 0L) {
            Project parentProject = (Project)this.daoHandler.getProjectHandler().find(parentId);
            if (parentProject != null) {
                project.setParent(parentProject);
                project.setParticipator(new HashSet<String>(parentProject.getParticipator()));
                project.setManager(new HashSet<String>(parentProject.getManager()));
                project = this.createProject(project);
                LinkedList<Status> prSt = new LinkedList<Status>(parentProject.getStatus());
                Collections.sort(prSt);
                for (Status st : prSt) {
                    this.statusService.createStatus(project, st.getName());
                }
                return project;
            }
            LOG.info((Object)("Can not find project for parent with ID: " + parentId));
            throw new ProjectNotFoundException(parentId);
        }
        return this.createDefaultStatusProject(project);
    }

    @Override
    @Transactional
    public Project createDefaultStatusProject(Project project) {
        Project newProject = (Project)this.daoHandler.getProjectHandler().create(project);
        for (String s : this.statusService.getDefaultStatus()) {
            this.statusService.createStatus(newProject, s);
        }
        return newProject;
    }

    @Override
    @Transactional
    public Project createProject(Project project) {
        Project obj = (Project)this.daoHandler.getProjectHandler().create(project);
        return obj;
    }

    @Override
    @Transactional
    public Project updateProjectInfo(long id, String param, String[] values) throws ProjectNotFoundException, ParameterEntityException {
        String val = values != null && values.length > 0 ? values[0] : null;
        Project project = this.getProjectById(id);
        if ("name".equalsIgnoreCase(param)) {
            if (val == null || val.isEmpty()) {
                LOG.info((Object)"Name of project must not empty");
                throw new ParameterEntityException(id, "Project", param, val, "must not be empty", null);
            }
            project.setName(val);
        } else if ("manager".equalsIgnoreCase(param)) {
            HashSet<String> manager = new HashSet<String>();
            if (values != null) {
                for (String v : values) {
                    manager.add(v);
                }
            }
            project.setManager(manager);
        } else if ("participator".equalsIgnoreCase(param)) {
            HashSet<String> participator = new HashSet<String>();
            if (values == null) {
                // empty if block
            }
            for (String v : values) {
                participator.add(v);
            }
            project.setParticipator(participator);
        } else if ("dueDate".equalsIgnoreCase(param)) {
            if (val == null || val.isEmpty()) {
                project.setDueDate(null);
            } else {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    Date date = df.parse(val);
                    project.setDueDate(date);
                }
                catch (ParseException e) {
                    LOG.info((Object)("can not parse date string: " + val));
                    throw new ParameterEntityException(id, "Project", param, val, "cannot be parse to date", e);
                }
            }
        } else if ("description".equalsIgnoreCase(param)) {
            project.setDescription(val);
        } else if ("color".equalsIgnoreCase(param)) {
            project.setColor(val);
        } else if ("parent".equalsIgnoreCase(param)) {
            try {
                long projectId = Long.parseLong(val);
                if (projectId == 0L) {
                    project.setParent(null);
                }
                if (projectId == project.getId()) {
                    throw new ParameterEntityException(id, "Project", param, val, "project can not be child of itself", null);
                }
                Project parent = this.getProjectById(projectId);
                project.setParent(parent);
            }
            catch (NumberFormatException ex) {
                LOG.info((Object)("can not parse date string: " + val));
                throw new ParameterEntityException(id, "Project", param, val, "cannot be parse to Long", ex);
            }
        } else {
            LOG.info((Object)("Field name: " + param + " is not supported for entity Project"));
            throw new ParameterEntityException(id, "Project", param, val, "is not supported for the entity Project", null);
        }
        Project obj = (Project)this.daoHandler.getProjectHandler().update(project);
        return obj;
    }

    @Override
    @Transactional
    public void deleteProjectById(long id, boolean deleteChild) throws ProjectNotFoundException {
        Project project = this.getProjectById(id);
        this.deleteProject(project, deleteChild);
    }

    @Override
    @Transactional
    public void deleteProject(Project project, boolean deleteChild) {
        if (!deleteChild && project.getChildren() != null) {
            Project parent = project.getParent();
            for (Project child : project.getChildren()) {
                child.setParent(parent);
            }
            project.getChildren().clear();
        }
        this.daoHandler.getProjectHandler().delete(project);
    }

    @Override
    @Transactional
    public Project cloneProjectById(long id, boolean cloneTask) throws ProjectNotFoundException {
        Project project = this.getProjectById(id);
        Project newProject = project.clone(cloneTask);
        this.createProject(newProject);
        return newProject;
    }

    @Override
    public Project getProjectById(Long id) throws ProjectNotFoundException {
        Project project = (Project)this.daoHandler.getProjectHandler().find(id);
        if (project == null) {
            throw new ProjectNotFoundException(id);
        }
        return project;
    }

    @Override
    @Transactional
    public Task createTaskToProjectId(long id, Task task) throws ProjectNotFoundException {
        Status status = this.daoHandler.getStatusHandler().findLowestRankStatusByProject(id);
        task.setStatus(status);
        return this.taskService.createTask(task);
    }

    @Override
    public List<Task> getTasksByProjectId(List<Long> ids, OrderBy orderBy) {
        return this.getTasksWithKeywordByProjectId(ids, orderBy, null);
    }

    @Override
    public List<Task> getTasksWithKeywordByProjectId(List<Long> ids, OrderBy orderBy, String keyword) {
        TaskQuery taskQuery = new TaskQuery();
        taskQuery.setProjectIds(ids);
        taskQuery.setKeyword(keyword);
        taskQuery.setOrderBy(orderBy == null ? null : Arrays.asList(orderBy));
        taskQuery.setCompleted(false);
        return this.daoHandler.getTaskHandler().findTaskByQuery(taskQuery);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @Transactional
    public Project removePermissionFromProjectId(Long id, String permission, String type) throws ProjectNotFoundException, NotAllowedOperationOnEntityException {
        Project project = (Project)this.daoHandler.getProjectHandler().find(id);
        if (project == null) {
            LOG.info((Object)("Can not find project with ID: " + id));
            throw new ProjectNotFoundException(id);
        }
        if ("manager".equals(type)) {
            if (project.getManager().size() <= 1) {
                LOG.info((Object)("Not allow to remove last manager for project with ID: " + id));
                throw new NotAllowedOperationOnEntityException((long)id, "Project", "Remove last manager");
            }
            project.getManager().remove(permission);
            return (Project)this.daoHandler.getProjectHandler().update(project);
        } else {
            project.getParticipator().remove(permission);
        }
        return (Project)this.daoHandler.getProjectHandler().update(project);
    }

    @Override
    @Transactional
    public Project addPermissionsFromProjectId(Long id, String permissions, String type) throws ProjectNotFoundException, NotAllowedOperationOnEntityException {
        Project project = this.getProjectById(id);
        if (permissions != null) {
            HashSet<String> per = new HashSet<String>();
            MembershipEntry entry = MembershipEntry.parse((String)permissions);
            if (entry != null) {
                per.add(entry.toString());
            } else {
                String[] users = permissions.split(",");
                for (int i = 0; i < users.length; ++i) {
                    per.add(users[i]);
                }
            }
            if ("manager".equals(type)) {
                project.getManager().addAll(per);
            } else {
                project.getParticipator().addAll(per);
            }
            Project obj = (Project)this.daoHandler.getProjectHandler().update(project);
            return obj;
        }
        LOG.info((Object)("Add permissions equal to null (not allow) to Project with ID: " + id));
        throw new NotAllowedOperationOnEntityException((long)id, "Project", "Add permission equal to null");
    }

    @Override
    public List<Project> getProjectTreeByMembership(List<String> memberships) {
        List<Project> projects = this.daoHandler.getProjectHandler().findAllByMemberships(memberships);
        return ProjectUtil.buildRootProjects(projects);
    }

    @Override
    public List<Project> findProjectByKeyWord(Identity identity, String keyword) {
        List<String> memberships = UserUtils.getMemberships(identity);
        return this.daoHandler.getProjectHandler().findAllByMembershipsAndKeyword(memberships, keyword);
    }
}

