/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.service.impl;

import java.util.TimeZone;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.UserSetting;
import org.exoplatform.task.exception.NotAllowedOperationOnEntityException;
import org.exoplatform.task.exception.ProjectNotFoundException;
import org.exoplatform.task.model.User;
import org.exoplatform.task.service.DAOHandler;
import org.exoplatform.task.service.UserService;

@Singleton
public class UserServiceImpl
implements UserService {
    private static final User GUEST = new User("guest", null, "", "", "Guest", "/eXoSkin/skin/images/system/UserAvtDefault.png", "#");
    private static final User NULL = new User(null, null, "", "", "Guest", "/eXoSkin/skin/images/system/UserAvtDefault.png", "#");
    private static final Log LOG = ExoLogger.getExoLogger(UserServiceImpl.class);
    @Inject
    private OrganizationService orgService;
    @Inject
    private IdentityManager identityManager;
    @Inject
    private DAOHandler daoHandler;

    public UserServiceImpl(OrganizationService orgService, IdentityManager idMgr, DAOHandler handler) {
        this.orgService = orgService;
        this.identityManager = idMgr;
        this.daoHandler = handler;
    }

    @Override
    public User loadUser(String username) {
        if (username == null) {
            return GUEST;
        }
        try {
            org.exoplatform.services.organization.User u = this.orgService.getUserHandler().findUserByName(username);
            if (u == null) {
                return GUEST;
            }
            Profile profile = this.identityManager.getOrCreateIdentity("organization", username, false).getProfile();
            String avatarURL = profile.getAvatarUrl();
            if (avatarURL == null) {
                avatarURL = "/eXoSkin/skin/images/system/UserAvtDefault.png";
            }
            return new User(username, u.getEmail(), u.getFirstName(), u.getLastName(), profile.getFullName(), avatarURL, profile.getUrl());
        }
        catch (Exception ex) {
            LOG.debug((Object)"User not find, return GUEST", (Throwable)ex);
            return GUEST;
        }
    }

    @Override
    public UserSetting getUserSetting(String username) {
        return this.daoHandler.getUserSettingHandler().getOrCreate(username);
    }

    @Override
    public void hideProject(Identity identity, Long projectId, boolean hide) throws ProjectNotFoundException, NotAllowedOperationOnEntityException {
        Project project = (Project)this.daoHandler.getProjectHandler().find(projectId);
        if (project == null) {
            throw new ProjectNotFoundException(projectId);
        }
        if (!project.canView(identity)) {
            throw new NotAllowedOperationOnEntityException((long)projectId, "Project", "hide");
        }
        UserSetting setting = this.daoHandler.getUserSettingHandler().getOrCreate(identity.getUserId());
        if (hide) {
            setting.getHiddenProjects().add(project);
        } else {
            setting.getHiddenProjects().remove(project);
        }
        this.daoHandler.getUserSettingHandler().update(setting);
    }

    @Override
    public void showHiddenProject(String username, boolean show) {
        UserSetting setting = this.daoHandler.getUserSettingHandler().getOrCreate(username);
        setting.setShowHiddenProject(show);
        this.daoHandler.getUserSettingHandler().update(setting);
    }

    @Override
    public TimeZone getUserTimezone(String username) {
        return TimeZone.getDefault();
    }
}

