/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.utils;

import java.util.Calendar;
import java.util.ResourceBundle;
import java.util.TimeZone;

public class DateUtil {
    public static boolean isOverdue(Calendar calendar) {
        TimeZone tz = calendar.getTimeZone();
        Calendar current = Calendar.getInstance(tz);
        current.set(11, 0);
        current.set(12, 0);
        current.set(13, 0);
        current.set(14, 0);
        return calendar.getTimeInMillis() < current.getTimeInMillis();
    }

    public static boolean isToday(Calendar calendar) {
        TimeZone tz = calendar.getTimeZone();
        Calendar current = Calendar.getInstance(tz);
        return calendar.get(5) == current.get(5) && calendar.get(2) == current.get(2) && calendar.get(1) == current.get(1);
    }

    public static boolean isTomorrow(Calendar calendar) {
        TimeZone tz = calendar.getTimeZone();
        Calendar current = Calendar.getInstance(tz);
        current.add(5, 1);
        return calendar.get(5) == current.get(5) && calendar.get(2) == current.get(2) && calendar.get(1) == current.get(1);
    }

    public static String getDueDateLabel(Calendar calendar, ResourceBundle bundle) {
        if (calendar == null) {
            return bundle.getString("label.noDueDate");
        }
        if (DateUtil.isOverdue(calendar)) {
            return bundle.getString("label.overdue");
        }
        if (DateUtil.isToday(calendar)) {
            return bundle.getString("label.today");
        }
        if (DateUtil.isTomorrow(calendar)) {
            return bundle.getString("label.tomorrow");
        }
        return bundle.getString("label.upcoming");
    }
}

