/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.service.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.task.dao.StatusHandler;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.exception.NotAllowedOperationOnEntityException;
import org.exoplatform.task.exception.StatusNotFoundException;
import org.exoplatform.task.service.DAOHandler;
import org.exoplatform.task.service.StatusService;
import org.exoplatform.task.service.impl.StatusServiceImpl$AjcClosure1;
import org.exoplatform.task.service.impl.StatusServiceImpl$AjcClosure3;
import org.exoplatform.task.service.impl.StatusServiceImpl$AjcClosure5;

@Singleton
public class StatusServiceImpl
implements StatusService {
    @Inject
    private DAOHandler daoHandler;
    private String[] DEFAULT_STATUS = new String[]{"To Do", "In Progress", "Waiting On", "Done"};
    private static Log LOG;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public StatusServiceImpl(DAOHandler daoHandler) {
        String status = PropertyManager.getProperty((String)"exo.tasks.default.status");
        if (status != null) {
            LinkedList<String> stList = new LinkedList<String>();
            for (String s : status.split(",")) {
                if ((s = s.trim()).isEmpty()) continue;
                stList.add(s);
            }
            if (!stList.isEmpty()) {
                this.DEFAULT_STATUS = stList.toArray(new String[stList.size()]);
            }
        }
        this.daoHandler = daoHandler;
    }

    @Override
    public List<String> getDefaultStatus() {
        return Arrays.asList(this.DEFAULT_STATUS);
    }

    @Override
    public Status getStatusById(long statusId) {
        return (Status)this.daoHandler.getStatusHandler().find(Long.valueOf(statusId));
    }

    @Override
    public Status findLowestRankStatusByProject(long projectId) {
        return this.daoHandler.getStatusHandler().findLowestRankStatusByProject(projectId);
    }

    @Override
    @ExoTransactional
    public Status createStatus(Project project, String name) {
        Project project2 = project;
        String string = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)project2, (Object)string);
        Object[] objectArray = new Object[]{this, project2, string, joinPoint};
        return (Status)ExoTransactionalAspect.aspectOf().around(new StatusServiceImpl$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public Status deleteStatus(long statusID) throws StatusNotFoundException, NotAllowedOperationOnEntityException {
        long l = statusID;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), joinPoint};
        return (Status)ExoTransactionalAspect.aspectOf().around(new StatusServiceImpl$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public Status updateStatus(long id, String name) throws StatusNotFoundException, NotAllowedOperationOnEntityException {
        long l = id;
        String string = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)Conversions.longObject((long)l), (Object)string);
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), string, joinPoint};
        return (Status)ExoTransactionalAspect.aspectOf().around(new StatusServiceImpl$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    public Status swapPosition(long statusID, long otherID) throws NotAllowedOperationOnEntityException {
        StatusHandler handler = this.daoHandler.getStatusHandler();
        Status status = (Status)handler.find(Long.valueOf(statusID));
        Status other = (Status)handler.find(Long.valueOf(otherID));
        if (status == null || other == null) {
            throw new NotAllowedOperationOnEntityException(statusID, "status", "swap with null status");
        }
        Integer rank = status.getRank();
        status.setRank(other.getRank());
        other.setRank(rank);
        return status;
    }

    private Status findAltStatus(Status st, Project project) {
        LinkedList<Status> allSt = new LinkedList<Status>(project.getStatus());
        Collections.sort(allSt);
        Status other = null;
        for (int i = 0; i < allSt.size(); ++i) {
            if (!((Status)allSt.get(i)).equals(st)) continue;
            if (i > 0) {
                other = (Status)allSt.get(i - 1);
                break;
            }
            if (i + 1 >= allSt.size()) break;
            other = (Status)allSt.get(i + 1);
            break;
        }
        return other;
    }

    static {
        StatusServiceImpl.ajc$preClinit();
        LOG = ExoLogger.getExoLogger(StatusServiceImpl.class);
    }

    static /* synthetic */ Status createStatus_aroundBody0(StatusServiceImpl ajc$this, Project project, String name, JoinPoint joinPoint) {
        if (name == null || (name = name.trim()).isEmpty() || project == null) {
            throw new IllegalArgumentException("project must be not null and status must not be null or empty");
        }
        if (project.getStatus() != null) {
            for (Status st : project.getStatus()) {
                if (!st.getName().equalsIgnoreCase(name)) continue;
                LOG.warn("Status {} has already exists", new Object[]{name});
                return st;
            }
        } else {
            project.setStatus(new HashSet<Status>());
        }
        Status max = ajc$this.daoHandler.getStatusHandler().findHighestRankStatusByProject(project.getId());
        int maxRank = max != null && max.getRank() != null ? max.getRank() : -1;
        StatusHandler handler = ajc$this.daoHandler.getStatusHandler();
        Status st = new Status(name, ++maxRank, new HashSet<Task>(), project);
        project.getStatus().add(st);
        handler.create(st);
        return st;
    }

    static /* synthetic */ Status deleteStatus_aroundBody2(StatusServiceImpl ajc$this, long statusID, JoinPoint joinPoint) {
        StatusHandler handler = ajc$this.daoHandler.getStatusHandler();
        Status st = (Status)handler.find(Long.valueOf(statusID));
        if (st == null) {
            throw new StatusNotFoundException(statusID);
        }
        Project project = st.getProject();
        Status altStatus = ajc$this.findAltStatus(st, project);
        if (altStatus == null) {
            throw new NotAllowedOperationOnEntityException(statusID, "status", "Delete last status");
        }
        Set<Task> tasks = st.getTasks();
        altStatus.getTasks().addAll(tasks);
        for (Task t : tasks) {
            t.setStatus(altStatus);
            ajc$this.daoHandler.getTaskHandler().update(t);
        }
        st.getTasks().clear();
        project.getStatus().remove(st);
        st.setProject(null);
        handler.delete(st);
        return st;
    }

    static /* synthetic */ Status updateStatus_aroundBody4(StatusServiceImpl ajc$this, long id, String name, JoinPoint joinPoint) {
        if (name == null || (name = name.trim()).isEmpty()) {
            throw new IllegalArgumentException("status name can't be null or empty");
        }
        StatusHandler handler = ajc$this.daoHandler.getStatusHandler();
        Status status = (Status)handler.find(Long.valueOf(id));
        if (status == null) {
            throw new StatusNotFoundException(id);
        }
        Status curr = handler.findByName(name, status.getProject().getId());
        if (curr != null && !status.equals(curr)) {
            throw new NotAllowedOperationOnEntityException(status.getId(), "status", "duplicate status name");
        }
        status.setName(name);
        return (Status)ajc$this.daoHandler.getStatusHandler().update(status);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("StatusServiceImpl.java", StatusServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createStatus", "org.exoplatform.task.service.impl.StatusServiceImpl", "org.exoplatform.task.domain.Project:java.lang.String", "project:name", "", "org.exoplatform.task.domain.Status"), 91);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteStatus", "org.exoplatform.task.service.impl.StatusServiceImpl", "long", "statusID", "org.exoplatform.task.exception.StatusNotFoundException:org.exoplatform.task.exception.NotAllowedOperationOnEntityException", "org.exoplatform.task.domain.Status"), 120);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateStatus", "org.exoplatform.task.service.impl.StatusServiceImpl", "long:java.lang.String", "id:name", "org.exoplatform.task.exception.StatusNotFoundException:org.exoplatform.task.exception.NotAllowedOperationOnEntityException", "org.exoplatform.task.domain.Status"), 151);
    }
}

