/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.utils;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import org.exoplatform.calendar.model.Calendar;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.exception.ProjectNotFoundException;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.utils.ResourceUtil;
import org.exoplatform.task.utils.UserUtils;
import org.exoplatform.web.controller.router.Router;

public final class ProjectUtil {
    private static final Log LOG = ExoLogger.getExoLogger(ProjectUtil.class);
    public static final String URL_PROJECT_DETAIL = "/projectDetail/";
    public static final int INCOMING_PROJECT_ID = -1;
    public static final int TODO_PROJECT_ID = -2;
    public static final String NAME = "name";
    public static final String DUE_DATE = "dueDate";
    private static final String NAME_SUFFIX = " Tasks";

    private ProjectUtil() {
    }

    public static Calendar buildCalendar(Calendar calendar, Project project) {
        if (project == null || calendar == null) {
            return null;
        }
        if (project.getColor() != null) {
            calendar.setCalendarColor(project.getColor());
        }
        calendar.setDescription(project.getDescription());
        calendar.setEditPermission(null);
        ProjectService service = (ProjectService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ProjectService.class);
        List<Task> tasks = service.getTasksByProjectId(Arrays.asList(project.getId()), null);
        calendar.setHasChildren(tasks.size() > 0);
        calendar.setId(String.valueOf(project.getId()));
        calendar.setName(project.getName() + NAME_SUFFIX);
        HashSet<String> permissions = new HashSet<String>();
        if (project.getManager() != null) {
            permissions.addAll(project.getManager());
        }
        if (project.getParticipator() != null) {
            permissions.addAll(project.getParticipator());
        }
        calendar.setViewPermission(permissions.toArray(new String[permissions.size()]));
        return calendar;
    }

    public static List<Project> getProjectTree(String space_group_id, ProjectService projectService) {
        LinkedList<String> memberships = new LinkedList<String>();
        if (space_group_id == null) {
            ConversationState state = ConversationState.getCurrent();
            Identity identity = state.getIdentity();
            memberships.addAll(UserUtils.getMemberships(identity));
        } else {
            memberships.addAll(UserUtils.getSpaceMemberships(space_group_id));
        }
        return projectService.getProjectTreeByMembership(memberships);
    }

    public static List<Project> buildRootProjects(List<Project> projects) {
        LinkedList<Project> tmpParents;
        if (projects == null) {
            return projects;
        }
        LinkedHashSet<Project> rootPRJs = new LinkedHashSet<Project>();
        LinkedHashSet<Project> childs = new LinkedHashSet<Project>();
        block0: for (Project p : projects) {
            while (true) {
                Project parent;
                if ((parent = p.getParent()) == null) {
                    rootPRJs.add(p);
                    continue block0;
                }
                childs.add(p);
                p = parent;
            }
        }
        LinkedList parents = new LinkedList(rootPRJs);
        do {
            tmpParents = new LinkedList<Project>();
            for (Project p : parents) {
                LinkedList<Project> tmp = new LinkedList<Project>();
                for (Project c : childs) {
                    if (!c.getParent().equals(p)) continue;
                    tmp.add(c);
                }
                p.setChildren(tmp);
                tmpParents.addAll(tmp);
                childs.removeAll(tmp);
            }
        } while (!(parents = tmpParents).isEmpty() && !childs.isEmpty());
        return new LinkedList<Project>(rootPRJs);
    }

    public static List<Project> flattenTree(List<Project> projectTree) {
        if (projectTree == null) {
            return null;
        }
        LinkedList<Project> projects = new LinkedList<Project>();
        for (Project p : projectTree) {
            projects.add(p);
            if (p.getChildren().isEmpty()) continue;
            projects.addAll(ProjectUtil.flattenTree(p.getChildren()));
        }
        return projects;
    }

    public static String buildBreadcumbs(Long id, ProjectService projectService, ResourceBundle bundle) {
        StringBuilder el;
        Project project = null;
        if (id > 0L) {
            try {
                project = projectService.getProjectById(id);
            }
            catch (ProjectNotFoundException e) {
                LOG.warn("project {} not found", new Object[]{id});
            }
        }
        StringBuilder builder = new StringBuilder();
        if (project != null) {
            for (Project tmp = project; tmp != null; tmp = tmp.getParent()) {
                el = new StringBuilder();
                if (builder.length() == 0) {
                    el.append("<li class=\"active\">").append(tmp.getName()).append("</li>");
                } else {
                    el.append("<li>").append("<a class=\"Selected\" title=\"\" data-placement=\"bottom\" rel=\"tooltip\" href=\"#\" data-original-title=\"").append(tmp.getName()).append("\">").append(tmp.getName()).append("</a>").append("<span class=\"uiIconMiniArrowRight\"></span>").append("</li>");
                }
                builder.insert(0, el.toString());
            }
        }
        String label = bundle.getString("label.projects");
        el = new StringBuilder();
        if (builder.length() == 0) {
            el.append("<li class=\"active\">").append(label).append("</li>");
        } else {
            el.append("<li>").append("<a class=\"Selected\" title=\"\" data-placement=\"bottom\" rel=\"tooltip\" href=\"#\" data-original-title=\"").append(label).append("\">").append(label).append("</a>").append("<span class=\"uiIconMiniArrowRight\"></span>").append("</li>");
        }
        builder.insert(0, el.toString());
        return builder.toString();
    }

    public static String buildProjectURL(Project project, SiteKey siteKey, ExoContainer container, Router router) {
        if (project == null) {
            return "#";
        }
        StringBuilder urlBuilder = new StringBuilder(ResourceUtil.buildBaseURL(siteKey, container, router));
        if (urlBuilder.length() <= 1) {
            return urlBuilder.toString();
        }
        return urlBuilder.append(URL_PROJECT_DETAIL).append(project.getId()).toString();
    }

    public static long getProjectIdFromURI(String requestPath) {
        long taskId = -1L;
        int index = requestPath.indexOf(URL_PROJECT_DETAIL);
        if (index >= 0) {
            int lastIndex = requestPath.indexOf(47, index += URL_PROJECT_DETAIL.length());
            String id = lastIndex > 0 ? requestPath.substring(index, lastIndex) : requestPath.substring(index);
            try {
                taskId = Long.parseLong(id);
            }
            catch (NumberFormatException ex) {
                taskId = -1L;
            }
        }
        return taskId;
    }
}

