/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.model;

import java.util.Date;
import org.exoplatform.services.security.Identity;
import org.exoplatform.task.domain.Comment;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.model.User;
import org.exoplatform.task.util.TaskUtil;

public class CommentModel {
    private final Comment comment;
    private final User author;
    private final String formattedComment;

    public CommentModel(Comment cmt, User author, String formattedComment) {
        this.comment = cmt;
        this.author = author;
        this.formattedComment = formattedComment;
    }

    public User getAuthor() {
        return this.author;
    }

    public Date getCreatedTime() {
        return this.comment.getCreatedTime();
    }

    public String getComment() {
        return this.comment.getComment();
    }

    public long getId() {
        return this.comment.getId();
    }

    public Task getTask() {
        return this.comment.getTask();
    }

    public String getFormattedComment() {
        return this.formattedComment;
    }

    public boolean canEdit(Identity identity) {
        return TaskUtil.canDeleteComment(identity, this.comment);
    }
}

