/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.domain;

import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.UserSetting;
import org.exoplatform.task.util.ProjectUtil;

@Entity(name="TaskProject")
@ExoEntity
@Table(name="TASK_PROJECTS")
public class Project {
    public static final String PREFIX_CLONE = "Copy of ";
    @Id
    @SequenceGenerator(name="SEQ_TASK_PROJECTS_PROJECT_ID", sequenceName="SEQ_TASK_PROJECTS_PROJECT_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_TASK_PROJECTS_PROJECT_ID")
    @Column(name="PROJECT_ID")
    private long id;
    private String name;
    private String description;
    private String color;
    @Column(name="CALENDAR_INTEGRATED")
    private boolean calendarIntegrated = false;
    @OneToMany(mappedBy="project", cascade={CascadeType.REMOVE}, orphanRemoval=true)
    private Set<Status> status = new HashSet<Status>();
    @ElementCollection
    @CollectionTable(name="TASK_PROJECT_MANAGERS", joinColumns={@JoinColumn(name="PROJECT_ID")})
    private Set<String> manager = new HashSet<String>();
    @ElementCollection
    @CollectionTable(name="TASK_PROJECT_PARTICIPATORS", joinColumns={@JoinColumn(name="PROJECT_ID")})
    private Set<String> participator = new HashSet<String>();
    @Temporal(value=TemporalType.DATE)
    @Column(name="DUE_DATE")
    private Date dueDate;
    @ManyToOne(optional=true, fetch=FetchType.LAZY)
    @JoinColumn(name="PARENT_PROJECT_ID", nullable=true)
    private Project parent;
    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private List<Project> children = new LinkedList<Project>();
    @ManyToMany(mappedBy="hiddenProjects", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private Set<UserSetting> hiddenOn = new HashSet<UserSetting>();

    public Project() {
    }

    public Project(String name, String description, Set<Status> status, Set<String> manager, Set<String> participator) {
        this.name = name;
        this.description = description;
        this.status = status;
        this.manager = manager;
        this.participator = participator;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Deprecated
    public Set<Status> getStatus() {
        return this.status;
    }

    @Deprecated
    public void setStatus(Set<Status> status) {
        this.status = status;
    }

    @Deprecated
    public Set<String> getParticipator() {
        if (this.participator == null) {
            this.participator = ProjectUtil.getParticipator(this.getId());
        }
        return this.participator;
    }

    public void setParticipator(Set<String> participator) {
        this.participator = participator;
    }

    @Deprecated
    public Set<String> getManager() {
        if (this.manager == null) {
            this.manager = ProjectUtil.getManager(this.getId());
        }
        return this.manager;
    }

    public void setManager(Set<String> manager) {
        this.manager = manager;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public boolean isCalendarIntegrated() {
        return this.calendarIntegrated;
    }

    public void setCalendarIntegrated(boolean calendarIntegrated) {
        this.calendarIntegrated = calendarIntegrated;
    }

    public Project getParent() {
        return this.parent;
    }

    public void setParent(Project parent) {
        this.parent = parent;
    }

    @Deprecated
    public List<Project> getChildren() {
        return this.children;
    }

    @Deprecated
    public void setChildren(List<Project> children) {
        this.children = children;
    }

    public Project clone(boolean cloneTask) {
        Project project = new Project(this.getName(), this.getDescription(), new HashSet<Status>(), null, null);
        project.setId(this.getId());
        project.setColor(this.getColor());
        project.setDueDate(this.getDueDate());
        if (this.getParent() != null) {
            project.setParent(this.getParent().clone(false));
        }
        project.setCalendarIntegrated(this.isCalendarIntegrated());
        project.status = new HashSet<Status>();
        project.children = new LinkedList<Project>();
        return project;
    }

    public boolean canView(Identity user) {
        HashSet<String> permissions = new HashSet<String>(this.getParticipator());
        permissions.addAll(this.getManager());
        return this.hasPermission(user, permissions);
    }

    public boolean canEdit(Identity user) {
        return this.hasPermission(user, this.getManager());
    }

    private boolean hasPermission(Identity user, Set<String> permissions) {
        if (permissions.contains(user.getUserId())) {
            return true;
        }
        HashSet<MembershipEntry> memberships = new HashSet<MembershipEntry>();
        for (String per : permissions) {
            MembershipEntry entry = MembershipEntry.parse((String)per);
            if (entry == null) continue;
            memberships.add(entry);
        }
        for (MembershipEntry entry : user.getMemberships()) {
            if (!memberships.contains(entry)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.getId() ^ this.getId() >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Project)) {
            return false;
        }
        Project other = (Project)obj;
        return this.getId() == other.getId();
    }
}

