/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import org.exoplatform.calendar.model.Event;
import org.exoplatform.commons.utils.HTMLEntityEncoder;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.task.dao.TaskQuery;
import org.exoplatform.task.domain.Comment;
import org.exoplatform.task.domain.Label;
import org.exoplatform.task.domain.Priority;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.exception.ParameterEntityException;
import org.exoplatform.task.model.CommentModel;
import org.exoplatform.task.model.GroupKey;
import org.exoplatform.task.model.TaskModel;
import org.exoplatform.task.model.User;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.StatusService;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.service.UserService;
import org.exoplatform.task.util.CommentUtil;
import org.exoplatform.task.util.DateUtil;
import org.exoplatform.task.util.ListUtil;
import org.exoplatform.task.util.ResourceUtil;
import org.exoplatform.task.util.StringUtil;
import org.exoplatform.task.util.UserUtil;
import org.exoplatform.web.controller.router.Router;

public final class TaskUtil {
    public static final String URL_TASK_DETAIL = "/taskDetail/";
    private static final Log LOG = ExoLogger.getExoLogger((String)TaskUtil.class.getName());
    public static final String TITLE = "title";
    public static final String PRIORITY = "priority";
    public static final String DUEDATE = "dueDate";
    public static final String CREATED_TIME = "createdTime";
    public static final String NONE = "none";
    public static final String STATUS = "status";
    public static final String ASSIGNEE = "assignee";
    public static final String PROJECT = "project";
    public static final String LABEL = "label";
    public static final String RANK = "rank";
    public static final String MEMBERSHIP = "membership";
    public static final String CREATED_BY = "createdBy";
    public static final String COWORKER = "coworker";
    public static final ListAccess<Task> EMPTY_TASK_LIST = new ListAccess<Task>(){

        public Task[] load(int index, int length) throws Exception, IllegalArgumentException {
            return new Task[0];
        }

        public int getSize() throws Exception {
            return 0;
        }
    };

    private TaskUtil() {
    }

    public static Map<String, String> getDefOrders(ResourceBundle bundle) {
        return TaskUtil.resolve(Arrays.asList(TITLE, PRIORITY, DUEDATE, CREATED_TIME), bundle);
    }

    public static Map<String, String> getDefGroupBys(long currentProject, ResourceBundle bundle) {
        if (currentProject == -1L) {
            return TaskUtil.resolve(Arrays.asList(NONE, ASSIGNEE, LABEL, DUEDATE), bundle);
        }
        return TaskUtil.resolve(Arrays.asList(NONE, ASSIGNEE, LABEL, DUEDATE, STATUS), bundle);
    }

    public static Map<String, String> resolve(List<String> keys, ResourceBundle bundle) {
        LinkedHashMap<String, String> labels = new LinkedHashMap<String, String>();
        for (String k : keys) {
            String label;
            if (k.isEmpty()) {
                k = NONE;
            }
            try {
                label = bundle.getString("label." + k);
            }
            catch (Exception e) {
                LOG.warn((Object)("Error while resolving label 'label." + k + "' with locale " + bundle.getLocale()), (Throwable)e);
                label = k;
            }
            labels.put(k, label);
        }
        return labels;
    }

    public static TaskQuery buildTaskQuery(TaskQuery query, String keyword, List<Long> searchLabelIds, Status status, DUE dueDate, Priority priority, List<String> searchAssignee, Boolean showCompleted, TimeZone timezone) {
        if (keyword != null && !keyword.trim().isEmpty()) {
            query.setKeyword(keyword);
        }
        if (searchLabelIds != null && !searchLabelIds.isEmpty()) {
            query.setLabelIds(searchLabelIds);
        }
        if (status != null) {
            query.setStatus(status);
        }
        if (dueDate != null) {
            Date[] due = TaskUtil.convertDueDate(dueDate.name(), timezone);
            query.setDueDateFrom(due[0]);
            query.setDueDateTo(due[1]);
        }
        if (priority != null) {
            query.setPriority(priority);
        }
        if (searchAssignee != null && !searchAssignee.isEmpty()) {
            query.setAssignee(searchAssignee);
        }
        if (showCompleted != null && !showCompleted.booleanValue()) {
            query.setCompleted(showCompleted);
        }
        return query;
    }

    public static Date[] convertDueDate(String dueDate, TimeZone timezone) {
        Date[] due = new Date[]{null, null};
        if (dueDate != null && !dueDate.isEmpty()) {
            Calendar today = Calendar.getInstance(timezone);
            today.set(11, 0);
            today.set(12, 0);
            today.set(13, 0);
            today.set(14, 0);
            switch (DUE.valueOf(dueDate.toUpperCase())) {
                case OVERDUE: {
                    today.add(5, -1);
                    due[1] = today.getTime();
                    break;
                }
                case TODAY: {
                    due[0] = today.getTime();
                    today.add(5, 1);
                    due[1] = new Date(today.getTimeInMillis() - 1L);
                    break;
                }
                case TOMORROW: {
                    today.add(5, 1);
                    due[0] = today.getTime();
                    today.add(5, 1);
                    due[1] = new Date(today.getTimeInMillis() - 1L);
                    break;
                }
                case UPCOMING: {
                    today.add(5, 2);
                    due[0] = today.getTime();
                }
            }
        }
        return due;
    }

    public static TaskModel getTaskModel(Long id, boolean loadAllComment, ResourceBundle bundle, String username, TaskService taskService, OrganizationService orgService, UserService userService, ProjectService projectService) throws EntityNotFoundException {
        int numberCoworkers;
        TaskModel taskModel = new TaskModel();
        Task task = taskService.getTask(id);
        Set<String> coworker = TaskUtil.getCoworker(taskService, id);
        task.setCoworker(coworker);
        taskModel.setTask(task);
        taskModel.setReadOnly(TaskUtil.hasViewOnlyPermission(task));
        User assignee = null;
        int n = numberCoworkers = coworker != null ? coworker.size() : 0;
        if (task.getAssignee() != null && !task.getAssignee().isEmpty()) {
            assignee = userService.loadUser(task.getAssignee());
        }
        taskModel.setAssignee(assignee);
        taskModel.setNumberCoworkers(numberCoworkers);
        ListAccess<Comment> listComments = taskService.getComments(task.getId());
        long commentCount = ListUtil.getSize(listComments);
        taskModel.setCommentCount(commentCount);
        int limitComment = loadAllComment ? -1 : 2;
        List<Comment> cmts = Arrays.asList(ListUtil.load(listComments, 0, limitComment));
        Collections.reverse(cmts);
        ArrayList<CommentModel> comments = new ArrayList<CommentModel>();
        taskService.loadSubComments(cmts);
        for (Comment c : cmts) {
            User u = userService.loadUser(c.getAuthor());
            CommentModel commentModel = new CommentModel(c, u, CommentUtil.formatMention(c.getComment(), userService));
            comments.add(commentModel);
            if (c.getSubComments() == null || c.getSubComments().isEmpty()) continue;
            ArrayList<CommentModel> subComments = new ArrayList<CommentModel>();
            for (Comment comment : c.getSubComments()) {
                User user = userService.loadUser(comment.getAuthor());
                subComments.add(new CommentModel(comment, user, CommentUtil.formatMention(comment.getComment(), userService)));
            }
            commentModel.setSubComments(subComments);
        }
        taskModel.setComments(comments);
        User currentUser = userService.loadUser(username);
        taskModel.setCurrentUser(currentUser);
        HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
        String breadcumbs = "<li class=\"muted\" >" + bundle.getString("label.noProject") + "</li>";
        if (task.getStatus() != null) {
            Project p = task.getStatus().getProject();
            breadcumbs = "<li><a class=\"project-name\" href=\"javascript:void(0)\">" + encoder.encode(p.getName()) + "</a></li>";
        }
        taskModel.setBreadcumbs(breadcumbs);
        ListAccess<Label> labels = taskService.findLabelsByTask(id, username);
        if (labels != null) {
            taskModel.setLabels(Arrays.asList(ListUtil.load(labels, 0, -1)));
        }
        return taskModel;
    }

    public static Map<GroupKey, List<Task>> groupTasks(List<Task> tasks, String groupBy, String username, TimeZone userTimezone, ResourceBundle bundle, TaskService taskService, UserService userService) throws EntityNotFoundException {
        TreeMap<GroupKey, List<Task>> maps = new TreeMap<GroupKey, List<Task>>();
        for (Task task : tasks) {
            for (GroupKey key : TaskUtil.getGroupName(task, groupBy, username, userTimezone, bundle, taskService, userService)) {
                LinkedList<Task> list = (LinkedList<Task>)maps.get(key);
                if (list == null) {
                    list = new LinkedList<Task>();
                    maps.put(key, list);
                }
                list.add(task);
            }
        }
        return maps;
    }

    @Deprecated
    public static int countTasks(TaskService taskService, TaskQuery taskQuery) {
        ListAccess<Task> list = taskService.findTasks(taskQuery);
        return ListUtil.getSize(list);
    }

    @Deprecated
    public static Map<GroupKey, ListAccess<Task>> findTasks(TaskService taskService, TaskQuery query, String groupBy, TimeZone userTimezone, UserService userService) {
        TreeMap<GroupKey, ListAccess<Task>> maps = new TreeMap<GroupKey, ListAccess<Task>>();
        TaskQuery selectFieldQuery = query.clone();
        if (groupBy == null || groupBy.trim().isEmpty() || NONE.equalsIgnoreCase(groupBy)) {
            ListAccess<Task> tasks = taskService.findTasks(query);
            GroupKey key = new GroupKey("", null, 0);
            maps.put(key, tasks);
            return maps;
        }
        if (DUEDATE.equalsIgnoreCase(groupBy)) {
            Calendar c = Calendar.getInstance(userTimezone);
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
            Date fromDueDate = null;
            Date toDueDate = null;
            c.add(14, -1);
            toDueDate = c.getTime();
            TaskQuery q = query.clone();
            q.setDueDateTo(toDueDate);
            GroupKey key = new GroupKey("Overdue", toDueDate, 0);
            ListAccess<Task> tasks = taskService.findTasks(q);
            if (ListUtil.getSize(tasks) > 0) {
                maps.put(key, tasks);
            }
            c.add(14, 1);
            fromDueDate = c.getTime();
            c.add(11, 24);
            c.add(14, -1);
            toDueDate = c.getTime();
            q = query.clone();
            q.setDueDateFrom(fromDueDate);
            q.setDueDateTo(toDueDate);
            key = new GroupKey("Today", fromDueDate, 1);
            tasks = taskService.findTasks(q);
            if (ListUtil.getSize(tasks) > 0) {
                maps.put(key, tasks);
            }
            c.add(14, 1);
            fromDueDate = c.getTime();
            c.add(11, 24);
            c.add(14, -1);
            toDueDate = c.getTime();
            q = query.clone();
            q.setDueDateFrom(fromDueDate);
            q.setDueDateTo(toDueDate);
            key = new GroupKey("Tomorrow", fromDueDate, 2);
            tasks = taskService.findTasks(q);
            if (ListUtil.getSize(tasks) > 0) {
                maps.put(key, tasks);
            }
            c.add(14, 1);
            fromDueDate = c.getTime();
            toDueDate = null;
            q = query.clone();
            q.setDueDateFrom(fromDueDate);
            q.setDueDateTo(toDueDate);
            key = new GroupKey("Upcoming", fromDueDate, 3);
            tasks = taskService.findTasks(q);
            if (ListUtil.getSize(tasks) > 0) {
                maps.put(key, tasks);
            }
            q = query.clone();
            q.setNullField(DUEDATE);
            key = new GroupKey("No Due date", null, 4);
            tasks = taskService.findTasks(q);
            if (ListUtil.getSize(tasks) > 0) {
                maps.put(key, tasks);
            }
        } else if (PROJECT.equalsIgnoreCase(groupBy)) {
            List projects = taskService.selectTaskField(selectFieldQuery, "status.project");
            for (int i = 0; i < projects.size(); ++i) {
                Project p = (Project)projects.get(i);
                GroupKey key = new GroupKey(p.getName(), p, i);
                TaskQuery q = query.clone();
                q.setProjectIds(Arrays.asList(p.getId()));
                ListAccess<Task> tasks = taskService.findTasks(q);
                if (ListUtil.getSize(tasks) <= 0) continue;
                maps.put(key, tasks);
            }
            if (query.getProjectIds() == null || query.getProjectIds().isEmpty()) {
                GroupKey key = new GroupKey("No Project", null, Integer.MAX_VALUE);
                TaskQuery q = query.clone();
                q.setNullField(STATUS);
                ListAccess<Task> tasks = taskService.findTasks(q);
                if (ListUtil.getSize(tasks) > 0) {
                    maps.put(key, tasks);
                }
            }
        } else if (STATUS.equalsIgnoreCase(groupBy)) {
            ListAccess<Task> tasks;
            GroupKey key;
            TaskQuery q;
            List statuses = taskService.selectTaskField(selectFieldQuery, STATUS);
            for (Status st : statuses) {
                q = query.clone();
                q.setStatus(st);
                key = new GroupKey(st.getName(), st, st.getRank());
                tasks = taskService.findTasks(q);
                if (ListUtil.getSize(tasks) <= 0) continue;
                maps.put(key, tasks);
            }
            if (query.getProjectIds() == null || query.getProjectIds().isEmpty()) {
                q = query.clone();
                q.setNullField(STATUS);
                key = new GroupKey("No Status", null, Integer.MAX_VALUE);
                tasks = taskService.findTasks(q);
                if (ListUtil.getSize(tasks) > 0) {
                    maps.put(key, tasks);
                }
            }
        } else if (ASSIGNEE.equalsIgnoreCase(groupBy)) {
            ListAccess<Task> tasks;
            GroupKey key;
            TaskQuery q;
            List assignees = taskService.selectTaskField(selectFieldQuery, ASSIGNEE);
            for (int i = 0; i < assignees.size(); ++i) {
                String assignee = (String)assignees.get(i);
                if (assignee == null) continue;
                q = query.clone();
                q.setAssignee(Arrays.asList(assignee));
                User user = userService.loadUser(assignee);
                key = new GroupKey(user.getDisplayName(), user, i);
                tasks = taskService.findTasks(q);
                if (ListUtil.getSize(tasks) <= 0) continue;
                maps.put(key, tasks);
            }
            if (query.getAssignee() == null) {
                q = query.clone();
                q.setNullField(ASSIGNEE);
                key = new GroupKey("Unassigned", null, Integer.MAX_VALUE);
                tasks = taskService.findTasks(q);
                if (ListUtil.getSize(tasks) > 0) {
                    maps.put(key, tasks);
                }
            }
        } else if (LABEL.equalsIgnoreCase(groupBy)) {
            ListAccess<Task> tasks;
            GroupKey key;
            List labels = taskService.selectTaskField(selectFieldQuery, "lblMapping.label");
            for (int i = 0; i < labels.size(); ++i) {
                Label label = (Label)labels.get(i);
                if (label == null) continue;
                TaskQuery q = query.clone();
                q.setLabelIds(Arrays.asList(label.getId()));
                key = new GroupKey(label.getName(), label, i);
                tasks = taskService.findTasks(q);
                if (ListUtil.getSize(tasks) <= 0) continue;
                maps.put(key, tasks);
            }
            TaskQuery q = query.clone();
            q.setEmptyField("lblMapping");
            key = new GroupKey("No Label", null, Integer.MAX_VALUE);
            tasks = taskService.findTasks(q);
            if (ListUtil.getSize(tasks) > 0) {
                maps.put(key, tasks);
            }
        }
        return maps;
    }

    public static String getWorkPlan(Calendar start, Calendar end, ResourceBundle bundle) {
        List<String> params;
        String bundleKey;
        String endDateFormat;
        if (start == null || end == null) {
            return null;
        }
        long duration = TaskUtil.normalizeDate(end).getTimeInMillis() - TaskUtil.normalizeDate(start).getTimeInMillis();
        long durationInMinute = duration / 60000L;
        long durationInHours = durationInMinute / 60L;
        long durationInDays = durationInHours / 24L;
        boolean hasHalfOfHour = durationInMinute % 60L != 0L;
        Calendar current = Calendar.getInstance(start.getTimeZone());
        boolean startTimeCurrentYear = start.get(1) == current.get(1);
        boolean endTimeCurrentYear = end.get(1) == current.get(1);
        boolean isSameYear = start.get(1) == end.get(1);
        boolean isSameMonth = isSameYear && start.get(2) == end.get(2);
        boolean isSameDay = isSameMonth && start.get(5) == end.get(5);
        String string = endDateFormat = endTimeCurrentYear ? "dd MMM" : "dd MMM YYYY";
        String startDateFormat = isSameMonth ? "dd" : (isSameYear || startTimeCurrentYear ? "dd MMM" : "dd MMM YYYY");
        Locale locale = bundle != null ? bundle.getLocale() : Locale.getDefault(Locale.Category.FORMAT);
        SimpleDateFormat startDF = new SimpleDateFormat(startDateFormat, locale);
        startDF.setTimeZone(start.getTimeZone());
        SimpleDateFormat endDF = new SimpleDateFormat(endDateFormat, locale);
        endDF.setTimeZone(start.getTimeZone());
        String fromDate = startDF.format(start.getTime());
        String toDate = endDF.format(end.getTime());
        if (durationInHours == 0L) {
            bundleKey = "message.workPlaned.minutes";
            params = Arrays.asList(endDF.format(start.getTime()));
        } else if (isSameDay && durationInHours == 1L) {
            params = Arrays.asList(toDate);
            bundleKey = hasHalfOfHour ? "message.workPlaned.hourMinutes" : "message.workPlaned.hour";
        } else if (isSameDay && durationInHours < 24L) {
            params = Arrays.asList(toDate, String.valueOf(durationInHours));
            bundleKey = hasHalfOfHour ? "message.workPlaned.hoursMinutes" : "message.workPlaned.hours";
        } else if (isSameDay && durationInHours == 24L) {
            params = Arrays.asList(toDate);
            bundleKey = "message.workPlaned.day";
        } else {
            params = Arrays.asList(fromDate, toDate, String.valueOf(durationInHours));
            bundleKey = durationInHours == 1L ? (hasHalfOfHour ? "message.workPlaned.daysHourMinutes" : "message.workPlaned.daysHour") : (hasHalfOfHour ? "message.workPlaned.daysHoursMinutes" : "message.workPlaned.daysHours");
        }
        return ResourceUtil.resolveMessage(bundle, bundleKey, params.toArray());
    }

    public static long getTaskIdFromURI(String requestPath) {
        long taskId = -1L;
        int index = requestPath.indexOf(URL_TASK_DETAIL);
        if (index >= 0) {
            int lastIndex = requestPath.indexOf(47, index += URL_TASK_DETAIL.length());
            String id = lastIndex > 0 ? requestPath.substring(index, lastIndex) : requestPath.substring(index);
            try {
                taskId = Long.parseLong(id);
            }
            catch (NumberFormatException ex) {
                taskId = -1L;
            }
        }
        return taskId;
    }

    public static String buildTaskURL(Task task) {
        if (task == null) {
            return "#";
        }
        StringBuilder urlBuilder = new StringBuilder(ResourceUtil.buildBaseURL());
        if (urlBuilder.length() <= 1) {
            return urlBuilder.toString();
        }
        return urlBuilder.append(URL_TASK_DETAIL).append(task.getId()).toString();
    }

    public static String buildTaskURL(Task task, SiteKey siteKey, ExoContainer container, Router router) {
        if (task == null) {
            return "#";
        }
        StringBuilder urlBuilder = new StringBuilder(ResourceUtil.buildBaseURL(siteKey, container, router));
        if (urlBuilder.length() <= 1) {
            return urlBuilder.toString();
        }
        return urlBuilder.append(URL_TASK_DETAIL).append(task.getId()).toString();
    }

    private static void buildHour(long duration, StringBuilder workplan, ResourceBundle bundle) {
        workplan.append(" (");
        int halfHour = 1800000;
        if (duration == (long)halfHour) {
            workplan.append("30 ").append(bundle.getString("label.minutes")).append(")");
        } else if (duration == (long)(halfHour * 2)) {
            workplan.append("1 ").append(bundle.getString("label.hour")).append(")");
        } else if (duration == (long)(halfHour * 48)) {
            workplan.append(bundle.getString("label.allday")).append(")");
        } else {
            long hour = duration / (long)(halfHour * 2);
            long day = hour / 24L;
            if (day > 0L) {
                hour %= 24L;
            }
            long odd = duration % (long)(halfHour * 2);
            boolean conjunction = false;
            if (day > 0L) {
                workplan.append(day).append(" ").append(bundle.getString("label.days"));
                conjunction = true;
            }
            if (hour > 0L) {
                if (conjunction) {
                    workplan.append(" ");
                }
                workplan.append(hour).append(" ").append(bundle.getString("label.hours"));
                conjunction = true;
            }
            if (odd > 0L) {
                if (conjunction) {
                    workplan.append(" ");
                }
                workplan.append("30 ").append(bundle.getString("label.minutes"));
            }
            workplan.append(")");
        }
    }

    private static Calendar normalizeDate(Calendar date) {
        Calendar result = Calendar.getInstance();
        result.setTimeInMillis(date.getTimeInMillis());
        if (result.get(12) == 59) {
            result.add(12, 1);
        }
        return result;
    }

    private static GroupKey[] getGroupName(Task task, String groupBy, String username, TimeZone userTimezone, ResourceBundle bundle, TaskService taskService, UserService userService) throws EntityNotFoundException {
        if (PROJECT.equalsIgnoreCase(groupBy)) {
            Status s = task.getStatus();
            if (s == null) {
                return new GroupKey[]{new GroupKey(bundle.getString("label.noProject"), null, Integer.MAX_VALUE)};
            }
            return new GroupKey[]{new GroupKey(s.getProject().getName(), s.getProject(), (int)s.getProject().getId())};
        }
        if (STATUS.equalsIgnoreCase(groupBy)) {
            Status s = task.getStatus();
            if (s == null) {
                return new GroupKey[]{new GroupKey(bundle.getString("label.todo"), null, Integer.MIN_VALUE)};
            }
            return new GroupKey[]{new GroupKey(ResourceUtil.resolveStatus(bundle, s.getName()), s, s.getRank())};
        }
        if (ASSIGNEE.equalsIgnoreCase(groupBy)) {
            GroupKey[] groupKeyArray;
            String assignee = task.getAssignee();
            User user = userService.loadUser(assignee);
            if (assignee != null && user.getUsername() != "guest" && user.getUsername() != null) {
                GroupKey[] groupKeyArray2 = new GroupKey[1];
                groupKeyArray = groupKeyArray2;
                groupKeyArray2[0] = new GroupKey(assignee, user, assignee.hashCode());
            } else {
                GroupKey[] groupKeyArray3 = new GroupKey[1];
                groupKeyArray = groupKeyArray3;
                groupKeyArray3[0] = new GroupKey(bundle.getString("label.unassigned"), null, Integer.MAX_VALUE);
            }
            return groupKeyArray;
        }
        if (DUEDATE.equalsIgnoreCase(groupBy)) {
            Date dueDate = task.getDueDate();
            Calendar calendar = null;
            if (dueDate != null) {
                calendar = Calendar.getInstance(userTimezone);
                calendar.setTime(dueDate);
                if (DateUtil.isOverdue(calendar)) {
                    calendar.setTimeInMillis(System.currentTimeMillis());
                    calendar.add(5, -1);
                } else if (!DateUtil.isToday(calendar) && !DateUtil.isTomorrow(calendar)) {
                    calendar.setTimeInMillis(System.currentTimeMillis());
                    calendar.add(5, 7);
                }
                calendar.set(10, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                dueDate = calendar.getTime();
            }
            return new GroupKey[]{new GroupKey(DateUtil.getDueDateLabel(calendar, bundle), dueDate, calendar == null ? Integer.MAX_VALUE : (int)calendar.getTimeInMillis())};
        }
        if (LABEL.equalsIgnoreCase(groupBy)) {
            ListAccess<Label> tmp = taskService.findLabelsByTask(task.getId(), username);
            List<Label> labels = Arrays.asList(ListUtil.load(tmp, 0, -1));
            if (labels.isEmpty()) {
                return new GroupKey[]{new GroupKey(bundle.getString("label.noLabel"), null, Integer.MAX_VALUE)};
            }
            GroupKey[] keys = new GroupKey[labels.size()];
            for (int i = 0; i < keys.length; ++i) {
                Label label = labels.get(i);
                keys[i] = new GroupKey(label.getName(), label, (int)label.getId());
            }
            return keys;
        }
        return new GroupKey[0];
    }

    public static Event buildEvent(Event event, Task task) {
        HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
        if (task.getStatus() != null) {
            event.setCalendarId(String.valueOf(task.getStatus().getProject().getId()));
            event.setEventState(encoder.encode(task.getStatus().getName()));
        } else {
            event.setCalendarId(String.valueOf(-2L));
        }
        event.setDescription(task.getDescription());
        event.setEventCategoryId("defaultEventCategoryIdAll");
        event.setEventCategoryName("defaultEventCategoryNameAll");
        event.setEventType(Event.TYPE_TASK);
        if (task.getStartDate() == null) {
            throw new IllegalStateException("Can't build event with a task that doesn't have workplan");
        }
        event.setFromDateTime(task.getStartDate());
        event.setToDateTime(task.getEndDate());
        event.setId(String.valueOf(task.getId()));
        if (task.getPriority() != null) {
            switch (task.getPriority()) {
                case HIGH: {
                    event.setPriority(Event.PRIORITY_HIGH);
                    break;
                }
                case NORMAL: {
                    event.setPriority(Event.PRIORITY_NORMAL);
                    break;
                }
                case LOW: {
                    event.setPriority(Event.PRIORITY_LOW);
                    break;
                }
                default: {
                    event.setPriority(Event.PRIORITY_NONE);
                }
            }
        }
        event.setSummary(task.getTitle());
        String assignee = task.getAssignee();
        if (assignee != null) {
            assignee = encoder.encode(assignee);
        }
        event.setTaskDelegator(assignee);
        return event;
    }

    public static List<Label> buildRootLabels(List<Label> labels) {
        LinkedList<Label> tmpParents;
        if (labels == null) {
            return labels;
        }
        LinkedHashSet<Label> rootLBLs = new LinkedHashSet<Label>();
        LinkedHashSet<Label> childs = new LinkedHashSet<Label>();
        block0: for (Label p : labels) {
            while (true) {
                Label parent;
                if ((parent = p.getParent()) == null) {
                    rootLBLs.add(p);
                    continue block0;
                }
                childs.add(p);
                p = parent;
            }
        }
        LinkedList parents = new LinkedList(rootLBLs);
        do {
            tmpParents = new LinkedList<Label>();
            for (Label p : parents) {
                LinkedList<Label> tmp = new LinkedList<Label>();
                for (Label c : childs) {
                    if (!c.getParent().equals(p)) continue;
                    tmp.add(c);
                }
                p.setChildren(tmp);
                tmpParents.addAll(tmp);
                childs.removeAll(tmp);
            }
        } while (!(parents = tmpParents).isEmpty() || !childs.isEmpty());
        return new LinkedList<Label>(rootLBLs);
    }

    public static List<Label> filterLabelTree(List<Label> allLabels, Label lbl) {
        LinkedList<Label> tmp = new LinkedList<Label>();
        for (Label l : allLabels) {
            if (TaskUtil.isLabelIn(l, lbl)) continue;
            tmp.add(l);
        }
        return tmp;
    }

    public static boolean canDeleteComment(Identity identity, Comment comment) {
        if (comment == null || identity == null) {
            return false;
        }
        if (identity.getUserId().equals(comment.getAuthor())) {
            return true;
        }
        Task task = comment.getTask();
        if (task.getStatus() != null) {
            Project pj = task.getStatus().getProject();
            return pj.canEdit(identity);
        }
        return false;
    }

    private static boolean isLabelIn(Label child, Label parent) {
        for (Label pr = child; pr != null; pr = pr.getParent()) {
            if (pr.getId() != parent.getId()) continue;
            return true;
        }
        return false;
    }

    public static Task saveTaskField(Task task, String username, String param, String[] values, TimeZone timezone, TaskService taskService, StatusService statusService) throws EntityNotFoundException, ParameterEntityException {
        if (timezone == null) {
            timezone = TimeZone.getDefault();
        }
        task.setCoworker(TaskUtil.getCoworker(taskService, task.getId()));
        if ("workPlan".equalsIgnoreCase(param)) {
            if (values == null) {
                task.setStartDate(null);
                task.setEndDate(null);
            } else {
                if (values.length != 2) {
                    LOG.error((Object)"workPlan updating lack of params");
                }
                try {
                    SimpleDateFormat wpf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                    wpf.setTimeZone(timezone);
                    Date startDate = wpf.parse(values[0]);
                    Date endDate = wpf.parse(values[1]);
                    task.setStartDate(startDate);
                    task.setEndDate(endDate);
                }
                catch (ParseException ex) {
                    LOG.info((Object)("Can parse date time value: " + values[0] + " or " + values[1] + " for Task with ID: " + task.getId()));
                    throw new ParameterEntityException(task.getId(), Task.class, param, values[0] + " or " + values[1], "cannot be parse to date", ex);
                }
            }
        } else {
            String value;
            String string = value = values != null && values.length > 0 ? values[0] : null;
            if (TITLE.equalsIgnoreCase(param)) {
                task.setTitle(value);
            } else if (DUEDATE.equalsIgnoreCase(param)) {
                if (value == null || value.trim().isEmpty()) {
                    task.setDueDate(null);
                } else {
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                    df.setTimeZone(timezone);
                    try {
                        Date date = df.parse(value);
                        task.setDueDate(date);
                    }
                    catch (ParseException ex) {
                        LOG.info((Object)("Can parse date time value: " + value + " for Task with ID: " + task.getId()));
                        throw new ParameterEntityException(task.getId(), Task.class, param, value, "cannot be parse to date", ex);
                    }
                }
            } else if (STATUS.equalsIgnoreCase(param)) {
                try {
                    Long statusId = Long.parseLong(value.toUpperCase());
                    Status status = statusService.getStatus(statusId);
                    if (status == null) {
                        LOG.info((Object)("Status does not exist with ID: " + value));
                        throw new EntityNotFoundException(task.getId(), (Class<?>)Status.class);
                    }
                    task.setStatus(status);
                }
                catch (NumberFormatException ex) {
                    LOG.info((Object)("Status is unacceptable: " + value + " for Task with ID: " + task.getId()));
                    throw new ParameterEntityException(task.getId(), Task.class, param, value, "is unacceptable", ex);
                }
            } else if ("description".equalsIgnoreCase(param)) {
                value = StringUtil.encodeInjectedHtmlTag(value);
                task.setDescription(value);
            } else if ("completed".equalsIgnoreCase(param)) {
                task.setCompleted(Boolean.parseBoolean(value));
            } else if (ASSIGNEE.equalsIgnoreCase(param)) {
                task.setAssignee(value);
            } else if (COWORKER.equalsIgnoreCase(param)) {
                HashSet<String> coworker = new HashSet<String>();
                if (values != null) {
                    for (String v : values) {
                        if (v == null || v.isEmpty()) continue;
                        coworker.add(v);
                    }
                }
                task.setCoworker(coworker);
            } else if (PRIORITY.equalsIgnoreCase(param)) {
                Priority priority = Priority.valueOf(value);
                task.setPriority(priority);
            } else if (PROJECT.equalsIgnoreCase(param)) {
                try {
                    Long projectId = Long.parseLong(value);
                    if (projectId > 0L) {
                        Status st = statusService.getDefaultStatus(projectId);
                        if (st == null) {
                            throw new ParameterEntityException(task.getId(), Task.class, param, value, "Status for project is not found", null);
                        }
                        task.setStatus(st);
                    }
                    task.setStatus(null);
                }
                catch (NumberFormatException ex) {
                    throw new ParameterEntityException(task.getId(), Task.class, param, value, "ProjectID must be long", ex);
                }
            } else if ("labels".equalsIgnoreCase(param)) {
                ArrayList<Long> ids = new ArrayList<Long>(values.length);
                ArrayList<String> labelsToCreate = new ArrayList<String>();
                for (int i = 0; i < values.length; ++i) {
                    try {
                        if (values[i] == null || values[i].isEmpty()) continue;
                        Long id = Long.parseLong(values[i]);
                        Label label = taskService.getLabel(id);
                        if (label != null) {
                            ids.add(Long.parseLong(values[i]));
                            continue;
                        }
                        labelsToCreate.add(values[i]);
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        labelsToCreate.add(values[i]);
                    }
                }
                HashSet<Long> persisted = new HashSet<Long>();
                ListAccess<Label> tmp = taskService.findLabelsByTask(task.getId(), username);
                List<Label> labels = Arrays.asList(ListUtil.load(tmp, 0, -1));
                for (Label label : labels) {
                    if (!ids.contains(label.getId())) {
                        taskService.removeTaskFromLabel(task.getId(), label.getId());
                        continue;
                    }
                    persisted.add(label.getId());
                }
                for (String string2 : labelsToCreate) {
                    Label l = new Label();
                    l.setName(string2);
                    l.setUsername(username);
                    l = taskService.createLabel(l);
                    ids.add(l.getId());
                }
                for (Long l : ids) {
                    if (persisted.contains(l)) continue;
                    taskService.addTaskToLabel(task.getId(), l);
                }
            } else if ("calendarIntegrated".equalsIgnoreCase(param)) {
                task.setCalendarIntegrated(Boolean.parseBoolean(value));
            } else {
                LOG.info((Object)("Field name: " + param + " is not supported for entity Task"));
                throw new ParameterEntityException(task.getId(), Task.class, param, value, "is not supported for the entity Task", null);
            }
        }
        return taskService.updateTask(task);
    }

    public static boolean hasEditPermission(Task task) {
        Project project;
        Identity identity = ConversationState.getCurrent().getIdentity();
        String userId = identity.getUserId();
        if (task.getAssignee() != null && task.getAssignee().equals(identity.getUserId()) || TaskUtil.getCoworker(task.getId()).contains(userId) || task.getCreatedBy() != null && task.getCreatedBy().equals(userId)) {
            return true;
        }
        if (task.getStatus() != null && (project = task.getStatus().getProject()).canView(identity)) {
            return true;
        }
        return UserUtil.isPlatformAdmin(identity);
    }

    public static boolean hasViewPermission(Task task) {
        Identity identity = ConversationState.getCurrent().getIdentity();
        String userId = identity.getUserId();
        return TaskUtil.hasMentionedUser(task, userId) || TaskUtil.hasEditPermission(task);
    }

    private static boolean hasMentionedUser(Task task, String userId) {
        TaskService taskService = TaskUtil.getTaskService();
        Set<String> mentionedUsers = taskService.getMentionedUsers(task.getId());
        return mentionedUsers.contains(userId);
    }

    public static boolean hasViewOnlyPermission(Task task) {
        return TaskUtil.hasViewPermission(task) && !TaskUtil.hasEditPermission(task);
    }

    public static boolean hasDeletePermission(Task task) {
        Project project;
        Identity identity = ConversationState.getCurrent().getIdentity();
        String userId = identity.getUserId();
        if (task.getCreatedBy() != null && task.getCreatedBy().equals(userId)) {
            return true;
        }
        if (task.getStatus() != null && (project = task.getStatus().getProject()).canEdit(identity)) {
            return true;
        }
        return UserUtil.isPlatformAdmin(identity);
    }

    public static boolean hasPermissionOnField(Task task, String name, String[] values, StatusService statusService, TaskService taskService, ProjectService projectService) {
        String value = values != null && values.length > 0 ? values[0] : null;
        Identity identity = ConversationState.getCurrent().getIdentity();
        try {
            if (STATUS.equalsIgnoreCase(name)) {
                Long statusId = Long.parseLong(value);
                Status status = statusService.getStatus(statusId);
                return status.getProject().canView(identity);
            }
            if (PROJECT.equalsIgnoreCase(name)) {
                Long projectId = Long.parseLong(value);
                if (projectId > 0L) {
                    Project project = projectService.getProject(projectId);
                    return project.canView(identity);
                }
            } else if ("labels".equalsIgnoreCase(name)) {
                boolean valid = true;
                for (int i = 0; i < values.length; ++i) {
                    if (values[i] == null || values[i].isEmpty()) continue;
                    long labelId = 0L;
                    try {
                        Label label;
                        labelId = Long.parseLong(values[i]);
                        if (labelId <= 0L || (label = taskService.getLabel(labelId)) == null) continue;
                        valid = valid && label.getUsername().equals(identity.getUserId());
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return valid;
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Can not check permission on task field", (Throwable)ex);
        }
        return true;
    }

    private static TaskService getTaskService() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (container instanceof RootContainer) {
            container = ((RootContainer)container).getPortalContainer(PortalContainer.getCurrentPortalContainerName());
        }
        return (TaskService)container.getComponentInstanceOfType(TaskService.class);
    }

    public static Set<String> getCoworker(TaskService taskService, long taskId) {
        return taskService.getCoworker(taskId);
    }

    public static Set<String> getCoworker(long taskId) {
        return TaskUtil.getTaskService().getCoworker(taskId);
    }

    public static enum DUE {
        OVERDUE,
        TODAY,
        TOMORROW,
        UPCOMING;

    }
}

