/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.rest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.RuntimeDelegate;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.rest.impl.RuntimeDelegateImpl;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.task.domain.Comment;
import org.exoplatform.task.domain.Label;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.model.CommentModel;
import org.exoplatform.task.rest.TaskRestService;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.StatusService;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.service.UserService;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestTaskRestService {
    @Mock
    TaskService taskService;
    @Mock
    ProjectService projectService;
    @Mock
    StatusService statusService;
    @Mock
    UserService userService;
    @Mock
    SpaceService spaceService;

    @Before
    public void setup() {
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
    }

    @Test
    public void testGetTasks() throws Exception {
        TaskRestService taskRestService = new TaskRestService(this.taskService, this.projectService, this.statusService, this.userService, this.spaceService);
        Identity root = new Identity("root");
        ConversationState.setCurrent((ConversationState)new ConversationState(root));
        Task task1 = new Task();
        Task task2 = new Task();
        Task task3 = new Task();
        Task task4 = new Task();
        ArrayList<Task> uncompletedTasks = new ArrayList<Task>();
        task1.setCompleted(true);
        uncompletedTasks.add(task2);
        uncompletedTasks.add(task3);
        uncompletedTasks.add(task4);
        ArrayList<Task> overdueTasks = new ArrayList<Task>();
        overdueTasks.add(task1);
        overdueTasks.add(task2);
        final ArrayList<Task> incomingTasks = new ArrayList<Task>();
        incomingTasks.add(task1);
        incomingTasks.add(task2);
        ListAccess<Task> incomingTasksListAccess = new ListAccess<Task>(){

            public Task[] load(int i, int i1) {
                return new Task[]{(Task)incomingTasks.get(0), (Task)incomingTasks.get(1)};
            }

            public int getSize() throws Exception {
                return incomingTasks.size();
            }
        };
        Mockito.when((Object)this.taskService.getUncompletedTasks("root", 20)).thenReturn(uncompletedTasks);
        Mockito.when((Object)this.taskService.countUncompletedTasks("root")).thenReturn((Object)uncompletedTasks.size());
        Mockito.when((Object)this.taskService.getOverdueTasks("root", 20)).thenReturn(overdueTasks);
        Mockito.when((Object)this.taskService.countOverdueTasks("root")).thenReturn((Object)overdueTasks.size());
        Mockito.when((Object)this.taskService.getIncomingTasks("root")).thenReturn((Object)incomingTasksListAccess);
        Mockito.when((Object)this.taskService.countOverdueTasks("root")).thenReturn((Object)incomingTasksListAccess.getSize());
        Mockito.when((Object)this.taskService.findTasks((String)Mockito.eq((Object)"root"), (String)Mockito.eq((Object)"searchTerm"), Mockito.anyInt())).thenReturn(Collections.singletonList(task4));
        Mockito.when((Object)this.taskService.countTasks((String)Mockito.eq((Object)"root"), (String)Mockito.eq((Object)"searchTerm"))).thenReturn((Object)1L);
        Response response = taskRestService.getTasks("overdue", null, 0, 20, false);
        Response response1 = taskRestService.getTasks("incoming", null, 0, 20, false);
        Response response2 = taskRestService.getTasks("", null, 0, 20, false);
        Response response3 = taskRestService.getTasks("whatever", "searchTerm", 0, 20, true);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        List tasks = (List)response.getEntity();
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)2L, (long)tasks.size());
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response1.getStatus());
        List tasks1 = (List)response1.getEntity();
        Assert.assertNotNull((Object)tasks1);
        Assert.assertEquals((long)2L, (long)tasks1.size());
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response2.getStatus());
        List tasks2 = (List)response2.getEntity();
        Assert.assertNotNull((Object)tasks2);
        Assert.assertEquals((long)3L, (long)tasks2.size());
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response3.getStatus());
        JSONObject tasks3JsonObject = (JSONObject)response3.getEntity();
        Assert.assertNotNull((Object)tasks3JsonObject);
        Assert.assertTrue((boolean)tasks3JsonObject.has("size"));
        Assert.assertTrue((boolean)tasks3JsonObject.has("tasks"));
        JSONArray tasks3 = (JSONArray)tasks3JsonObject.get("tasks");
        Assert.assertNotNull((Object)tasks3);
        Assert.assertEquals((long)1L, (long)tasks3.length());
        Long tasks3Size = (Long)tasks3JsonObject.get("size");
        Assert.assertEquals((long)1L, (long)tasks3Size);
    }

    @Test
    public void testUpdateTaskById() throws Exception {
        TaskRestService taskRestService = new TaskRestService(this.taskService, this.projectService, this.statusService, this.userService, this.spaceService);
        Identity john = new Identity("john");
        ConversationState.setCurrent((ConversationState)new ConversationState(john));
        Task task1 = new Task();
        Task task2 = new Task();
        task1.setId(1L);
        task1.setTitle("oldTask");
        task1.setCreatedBy("john");
        task1.setAssignee("john");
        task2.setId(2L);
        task2.setTitle("updatedTask");
        this.taskService.createTask(task1);
        this.taskService.createTask(task2);
        Mockito.when((Object)this.taskService.getTask(1L)).thenReturn((Object)task1);
        Mockito.when((Object)this.taskService.updateTask(task2)).thenReturn((Object)task2);
        Response response = taskRestService.updateTaskById(1L, task2);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Task task = (Task)response.getEntity();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"updatedTask", (Object)task.getTitle());
    }

    @Test
    public void testGetProjects() throws Exception {
        TaskRestService taskRestService = new TaskRestService(this.taskService, this.projectService, this.statusService, this.userService, this.spaceService);
        Identity root = new Identity("root");
        ConversationState.setCurrent((ConversationState)new ConversationState(root));
        Project project1 = new Project();
        project1.setName("project1");
        this.projectService.createProject(project1);
        Project project2 = new Project();
        project2.setName("project2");
        this.projectService.createProject(project2);
        Project project3 = new Project();
        project3.setName("project3");
        this.projectService.createProject(project3);
        Response response = taskRestService.getProjects();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Assert.assertNotNull((Object)response.getEntity());
    }

    @Test
    public void testGetDefaultStatusByProjectId() throws Exception {
        TaskRestService taskRestService = new TaskRestService(this.taskService, this.projectService, this.statusService, this.userService, this.spaceService);
        Identity john = new Identity("john");
        ConversationState.setCurrent((ConversationState)new ConversationState(john));
        Project project = new Project();
        project.setId(1L);
        HashSet<String> manager = new HashSet<String>();
        manager.add("john");
        project.setManager(manager);
        Status status = new Status();
        status.setId(1L);
        status.setName("status 1");
        Mockito.when((Object)this.projectService.getProject(Long.valueOf(1L))).thenReturn((Object)project);
        Mockito.when((Object)this.statusService.getDefaultStatus(1L)).thenReturn((Object)status);
        Response response = taskRestService.getDefaultStatusByProjectId(1L);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Status status1 = (Status)response.getEntity();
        Assert.assertNotNull((Object)status1);
        Assert.assertEquals((Object)"status 1", (Object)status1.getName());
    }

    @Test
    public void testGetLabels() throws Exception {
        TaskRestService taskRestService = new TaskRestService(this.taskService, this.projectService, this.statusService, this.userService, this.spaceService);
        Identity root = new Identity("root");
        ConversationState.setCurrent((ConversationState)new ConversationState(root));
        Label label1 = new Label();
        label1.setId(1L);
        label1.setName("label1");
        Label label2 = new Label();
        label2.setId(2L);
        label1.setName("label2");
        Label label3 = new Label();
        label3.setId(3L);
        label1.setName("label3");
        final ArrayList<Label> labels = new ArrayList<Label>();
        labels.add(label1);
        labels.add(label2);
        labels.add(label3);
        ListAccess<Label> labelsListAccess = new ListAccess<Label>(){

            public Label[] load(int offset, int limit) {
                return new Label[]{(Label)labels.get(0), (Label)labels.get(1), (Label)labels.get(2)};
            }

            public int getSize() throws Exception {
                return labels.size();
            }
        };
        Mockito.when((Object)this.taskService.findLabelsByUser(root.getUserId())).thenReturn((Object)labelsListAccess);
        Response response = taskRestService.getLabels();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        List labelList = (List)response.getEntity();
        Assert.assertNotNull((Object)labelList);
        Assert.assertEquals((long)3L, (long)labelList.size());
    }

    @Test
    public void getLabelsByTaskId() throws Exception {
        TaskRestService taskRestService = new TaskRestService(this.taskService, this.projectService, this.statusService, this.userService, this.spaceService);
        Identity root = new Identity("root");
        ConversationState.setCurrent((ConversationState)new ConversationState(root));
        Label label1 = new Label();
        label1.setId(1L);
        label1.setName("label1");
        Label label2 = new Label();
        label2.setId(2L);
        label1.setName("label2");
        Label label3 = new Label();
        label3.setId(3L);
        label1.setName("label3");
        final ArrayList<Label> labels = new ArrayList<Label>();
        labels.add(label1);
        labels.add(label2);
        labels.add(label3);
        ListAccess<Label> labelsListAccess = new ListAccess<Label>(){

            public Label[] load(int offset, int limit) {
                return new Label[]{(Label)labels.get(0), (Label)labels.get(1), (Label)labels.get(2)};
            }

            public int getSize() throws Exception {
                return labels.size();
            }
        };
        Mockito.when((Object)this.taskService.findLabelsByTask(1L, root.getUserId())).thenReturn((Object)labelsListAccess);
        Response response = taskRestService.getLabelsByTaskId(1L);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        List labelList = (List)response.getEntity();
        Assert.assertNotNull((Object)labelList);
        Assert.assertEquals((long)3L, (long)labelList.size());
    }

    @Test
    public void testAddTaskToLabel() throws Exception {
        TaskRestService taskRestService = new TaskRestService(this.taskService, this.projectService, this.statusService, this.userService, this.spaceService);
        Identity root = new Identity("root");
        ConversationState.setCurrent((ConversationState)new ConversationState(root));
        Task task = new Task();
        task.setId(1L);
        task.setCreatedBy("root");
        task.setAssignee("root");
        this.taskService.createTask(task);
        Label label1 = new Label();
        label1.setId(1L);
        label1.setName("label1");
        Label label2 = new Label();
        label2.setId(2L);
        label2.setName("label1");
        Mockito.when((Object)this.taskService.createLabel(label1)).thenReturn((Object)label1);
        Mockito.when((Object)this.taskService.getTask(1L)).thenReturn((Object)task);
        Response response = taskRestService.addTaskToLabel(label1, 1L);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Label addedLabel = (Label)response.getEntity();
        Assert.assertNotNull((Object)addedLabel);
    }

    @Test
    public void testAddTaskComment() throws Exception {
        TaskRestService taskRestService = new TaskRestService(this.taskService, this.projectService, this.statusService, this.userService, this.spaceService);
        Identity john = new Identity("john");
        ConversationState.setCurrent((ConversationState)new ConversationState(john));
        Task task = new Task();
        task.setId(1L);
        task.setCreatedBy("john");
        task.setAssignee("john");
        this.taskService.createTask(task);
        Comment comment = new Comment();
        comment.setId(1L);
        Mockito.when((Object)this.taskService.addComment(1L, john.getUserId(), "commentText")).thenReturn((Object)comment);
        Mockito.when((Object)this.taskService.getTask(1L)).thenReturn((Object)task);
        Response response = taskRestService.addTaskComment("commentText", 1L);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        CommentModel commentModel = (CommentModel)response.getEntity();
        Assert.assertNotNull((Object)commentModel);
        Assert.assertEquals((Object)commentModel.getFormattedComment(), (Object)"commentText");
        response = taskRestService.addTaskComment("", 1L);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        response = taskRestService.addTaskComment("x%20%3C%3D%202", 1L);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        commentModel = (CommentModel)response.getEntity();
        Assert.assertNotNull((Object)commentModel);
        Assert.assertEquals((Object)commentModel.getFormattedComment(), (Object)"x <= 2");
    }

    @Test
    public void testAddTaskSubComment() throws Exception {
        TaskRestService taskRestService = new TaskRestService(this.taskService, this.projectService, this.statusService, this.userService, this.spaceService);
        Identity john = new Identity("john");
        ConversationState.setCurrent((ConversationState)new ConversationState(john));
        Task task = new Task();
        task.setId(1L);
        task.setCreatedBy("john");
        task.setAssignee("john");
        this.taskService.createTask(task);
        Comment comment = new Comment();
        comment.setId(1L);
        comment.setComment("commentText");
        Mockito.when((Object)this.taskService.addComment(1L, 1L, john.getUserId(), "commentText")).thenReturn((Object)comment);
        Mockito.when((Object)this.taskService.getTask(1L)).thenReturn((Object)task);
        Response response = taskRestService.addTaskSubComment("commentText", 1L, 1L);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        CommentModel commentModel = (CommentModel)response.getEntity();
        Assert.assertNotNull((Object)commentModel);
        Assert.assertEquals((Object)commentModel.getFormattedComment(), (Object)"commentText");
        response = taskRestService.addTaskSubComment("", 1L, 1L);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        response = taskRestService.addTaskSubComment("x%20%3C%3D%202", 1L, 1L);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        commentModel = (CommentModel)response.getEntity();
        Assert.assertNotNull((Object)commentModel);
        Assert.assertEquals((Object)commentModel.getFormattedComment(), (Object)"x <= 2");
    }
}

