/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.service;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.idgenerator.IDGeneratorService;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.task.TestUtils;
import org.exoplatform.task.dao.CommentHandler;
import org.exoplatform.task.dao.DAOHandler;
import org.exoplatform.task.dao.LabelHandler;
import org.exoplatform.task.dao.StatusHandler;
import org.exoplatform.task.dao.TaskHandler;
import org.exoplatform.task.domain.Comment;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.model.CommentModel;
import org.exoplatform.task.model.TaskModel;
import org.exoplatform.task.model.User;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.service.UserService;
import org.exoplatform.task.service.impl.TaskServiceImpl;
import org.exoplatform.task.util.TaskUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class TaskUtilsTest {
    private TaskService taskService;
    private TaskService originTaskService;
    private ListenerService listenerService;
    private ResourceBundle rb_en;
    @Mock
    private ExoContainer container;
    @Mock
    private TaskHandler taskHandler;
    @Mock
    private CommentHandler commentHandler;
    @Mock
    private StatusHandler statusHandler;
    @Mock
    private LabelHandler labelHandler;
    @Mock
    private DAOHandler daoHandler;
    @Mock
    private UserService userService;
    @Mock
    IdGenerator idGenerator;
    @Mock
    private IDGeneratorService idGeneratorService;
    @Captor
    private ArgumentCaptor<Comment> commentCaptor;

    @Before
    public void setUp() throws Exception {
        PortalContainer container = PortalContainer.getInstance();
        this.listenerService = new ListenerService(new ExoContainerContext((ExoContainer)container));
        Mockito.when((Object)this.daoHandler.getTaskHandler()).thenReturn((Object)this.taskHandler);
        Mockito.when((Object)this.daoHandler.getCommentHandler()).thenReturn((Object)this.commentHandler);
        Mockito.when((Object)this.daoHandler.getStatusHandler()).thenReturn((Object)this.statusHandler);
        Mockito.when((Object)this.daoHandler.getLabelHandler()).thenReturn((Object)this.labelHandler);
        this.taskService = new TaskServiceImpl(this.daoHandler, this.listenerService);
        this.originTaskService = (TaskService)container.getComponentInstanceOfType(TaskService.class);
        container.unregisterComponent(TaskService.class);
        container.registerComponentInstance(TaskService.class, (Object)this.taskService);
        Mockito.when((Object)this.taskHandler.create(Matchers.any(Task.class))).thenReturn((Object)TestUtils.getDefaultTask());
        Mockito.when((Object)this.taskHandler.update(Matchers.any(Task.class))).thenReturn((Object)TestUtils.getDefaultTask());
        Mockito.when((Object)this.taskHandler.find((Serializable)Long.valueOf(TestUtils.EXISTING_TASK_ID))).thenReturn((Object)TestUtils.getDefaultTask());
        Mockito.when((Object)this.taskHandler.getCoworker(Matchers.anyLong())).thenReturn(Collections.emptySet());
        Mockito.when((Object)this.labelHandler.findLabelsByTask(Matchers.anyLong(), (String)Matchers.any())).thenReturn(null);
        Mockito.when((Object)this.statusHandler.find((Serializable)Long.valueOf(TestUtils.EXISTING_STATUS_ID))).thenReturn((Object)TestUtils.getDefaultStatus());
        Mockito.when((Object)this.commentHandler.find((Serializable)Long.valueOf(TestUtils.EXISTING_COMMENT_ID))).thenReturn((Object)TestUtils.getDefaultComment());
        Mockito.when((Object)this.commentHandler.findMentionedUsersOfTask(Matchers.anyLong())).thenReturn(Collections.emptySet());
        IdGenerator idGenerator = new IdGenerator(this.idGeneratorService);
        Mockito.when((Object)this.idGeneratorService.generateStringID(Matchers.any(String.class))).thenReturn((Object)Long.toString(System.currentTimeMillis()));
        Mockito.when((Object)this.userService.loadUser((String)Matchers.any())).thenAnswer((Answer)new Answer<User>(){

            public User answer(InvocationOnMock invocation) throws Throwable {
                return new User(invocation.getArguments()[0].toString(), null, null, null, null, null, null);
            }
        });
        Identity root = new Identity("root");
        ConversationState.setCurrent((ConversationState)new ConversationState(root));
        this.rb_en = ResourceBundle.getBundle("locale.portlet.taskManagement", Locale.ENGLISH);
    }

    @After
    public void tearDown() {
        PortalContainer container = PortalContainer.getInstance();
        container.unregisterComponent(TaskService.class);
        container.registerComponentInstance(TaskService.class, (Object)this.originTaskService);
        this.taskService = null;
        ConversationState.setCurrent(null);
    }

    @Test
    public void testGetTaskModel() throws EntityNotFoundException {
        String username = "Tib";
        String comment = "Bla bla bla bla bla";
        String authorSubComment = "Tib2";
        String subCommentContent = "Bla bla bla bla bla sub comment";
        this.taskService.addComment(TestUtils.EXISTING_TASK_ID, username, comment);
        ((CommentHandler)Mockito.verify((Object)this.commentHandler, (VerificationMode)Mockito.times((int)1))).create(this.commentCaptor.capture());
        Comment parentComment = (Comment)this.commentCaptor.getValue();
        Assert.assertEquals((long)TestUtils.EXISTING_TASK_ID, (long)parentComment.getTask().getId());
        Assert.assertEquals((Object)username, (Object)parentComment.getAuthor());
        Assert.assertEquals((Object)comment, (Object)parentComment.getComment());
        long parentCommentId = parentComment.getId();
        this.taskService.addComment(TestUtils.EXISTING_TASK_ID, parentCommentId, authorSubComment, subCommentContent);
        ((CommentHandler)Mockito.verify((Object)this.commentHandler, (VerificationMode)Mockito.times((int)2))).create(this.commentCaptor.capture());
        Comment subComment = (Comment)this.commentCaptor.getValue();
        Assert.assertEquals((long)TestUtils.EXISTING_TASK_ID, (long)subComment.getTask().getId());
        Assert.assertEquals((Object)authorSubComment, (Object)subComment.getAuthor());
        Assert.assertEquals((Object)subCommentContent, (Object)subComment.getComment());
        subComment.setParentComment(parentComment);
        ListAccess loadedComments = (ListAccess)Mockito.mock(ListAccess.class);
        try {
            Mockito.when((Object)loadedComments.getSize()).thenReturn((Object)1);
            Mockito.when((Object)loadedComments.load(Matchers.anyInt(), Matchers.anyInt())).thenReturn((Object)new Comment[]{parentComment});
            Mockito.when((Object)this.commentHandler.findComments(TestUtils.EXISTING_TASK_ID)).thenReturn((Object)loadedComments);
            Mockito.when((Object)this.commentHandler.getSubComments((List)Matchers.any())).thenReturn(Collections.singletonList(subComment));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Task task = this.taskService.getTask(TestUtils.EXISTING_TASK_ID);
        HashSet<String> watchers = new HashSet<String>(Arrays.asList("user1", "user2"));
        task.setWatcher(watchers);
        TaskModel taskModel = TaskUtil.getTaskModel((Long)TestUtils.EXISTING_TASK_ID, (boolean)true, (ResourceBundle)this.rb_en, (String)username, (TaskService)this.taskService, null, (UserService)this.userService, null);
        Assert.assertNotNull((Object)taskModel);
        Assert.assertFalse((boolean)taskModel.isWatched());
        watchers.add("Tib");
        taskModel = TaskUtil.getTaskModel((Long)TestUtils.EXISTING_TASK_ID, (boolean)true, (ResourceBundle)this.rb_en, (String)username, (TaskService)this.taskService, null, (UserService)this.userService, null);
        Assert.assertTrue((boolean)taskModel.isWatched());
        List comments = taskModel.getComments();
        Assert.assertNotNull((Object)comments);
        Assert.assertEquals((long)1L, (long)comments.size());
        CommentModel parentCommentModel = (CommentModel)comments.get(0);
        Assert.assertNotNull((Object)parentCommentModel);
        Assert.assertEquals((long)parentComment.getId(), (long)parentCommentModel.getId());
        Assert.assertEquals((Object)username, (Object)parentCommentModel.getAuthor().getUsername());
        Assert.assertEquals((Object)comment, (Object)parentCommentModel.getComment());
        List subCommentModels = parentCommentModel.getSubComments();
        Assert.assertNotNull((Object)subCommentModels);
        Assert.assertEquals((long)1L, (long)subCommentModels.size());
        CommentModel subCommentModel = (CommentModel)subCommentModels.get(0);
        Assert.assertEquals((long)subComment.getId(), (long)subCommentModel.getId());
        Assert.assertEquals((Object)authorSubComment, (Object)subCommentModel.getAuthor().getUsername());
        Assert.assertEquals((Object)subCommentContent, (Object)subCommentModel.getComment());
    }
}

