/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.task.TestDtoUtils;
import org.exoplatform.task.TestUtils;
import org.exoplatform.task.dao.DAOHandler;
import org.exoplatform.task.dao.ProjectHandler;
import org.exoplatform.task.dao.ProjectQuery;
import org.exoplatform.task.dao.StatusHandler;
import org.exoplatform.task.dao.TaskHandler;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.dto.ProjectDto;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.exception.NotAllowedOperationOnEntityException;
import org.exoplatform.task.service.StatusService;
import org.exoplatform.task.service.impl.StatusServiceImpl;
import org.exoplatform.task.storage.ProjectStorage;
import org.exoplatform.task.storage.StatusStorage;
import org.exoplatform.task.storage.TaskStorage;
import org.exoplatform.task.storage.impl.ProjectStorageImpl;
import org.exoplatform.task.storage.impl.StatusStorageImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class StatusServiceTest {
    StatusService statusService;
    StatusStorage statusStorage;
    ProjectStorage projectStorage;
    TaskStorage taskStorage;
    @Mock
    ListenerService listenerService;
    @Mock
    TaskHandler taskHandler;
    @Mock
    StatusHandler statusHandler;
    @Mock
    ProjectHandler projectHandler;
    @Mock
    DAOHandler daoHandler;
    @Captor
    ArgumentCaptor<Status> statusCaptor;
    @Captor
    ArgumentCaptor<Task> taskCaptor;

    @Before
    public void setUp() {
        PortalContainer.getInstance();
        this.projectStorage = new ProjectStorageImpl(this.daoHandler);
        this.statusStorage = new StatusStorageImpl(this.daoHandler, this.projectStorage, this.taskStorage);
        this.statusService = new StatusServiceImpl(this.daoHandler, this.statusStorage, this.projectStorage, this.listenerService);
        Mockito.when((Object)this.daoHandler.getTaskHandler()).thenReturn((Object)this.taskHandler);
        Mockito.when((Object)this.daoHandler.getStatusHandler()).thenReturn((Object)this.statusHandler);
        Mockito.when((Object)this.daoHandler.getProjectHandler()).thenReturn((Object)this.projectHandler);
        Mockito.when((Object)this.taskHandler.find((Serializable)Long.valueOf(TestUtils.EXISTING_TASK_ID))).thenReturn((Object)TestUtils.getDefaultTask());
        Mockito.when((Object)this.statusHandler.find((Serializable)Long.valueOf(TestUtils.EXISTING_STATUS_ID))).thenReturn((Object)TestUtils.getDefaultStatus());
        Mockito.when((Object)this.daoHandler.getStatusHandler().findHighestRankStatusByProject(TestUtils.EXISTING_TASK_ID)).thenReturn((Object)TestUtils.getDefaultStatus());
    }

    @After
    public void tearDown() {
        this.statusService = null;
    }

    @Test
    public void testCreateDefaultStatusesProject() {
        ProjectDto project = TestDtoUtils.getDefaultProject();
        this.statusService.createInitialStatuses(project);
        ((StatusHandler)Mockito.verify((Object)this.statusHandler, (VerificationMode)Mockito.times((int)4))).create(Matchers.any(Status.class));
    }

    @Test
    public void testCreateStatus() {
        ProjectDto project = TestDtoUtils.getDefaultProject();
        Status currStatus = new Status(1L, "oldStatus");
        Mockito.when((Object)this.statusHandler.findHighestRankStatusByProject(project.getId())).thenReturn((Object)currStatus);
        this.statusService.createStatus(project, "newStatus");
        ((StatusHandler)Mockito.verify((Object)this.statusHandler, (VerificationMode)Mockito.times((int)1))).create(this.statusCaptor.capture());
        Status result = (Status)this.statusCaptor.getValue();
        int currRank = currStatus.getRank() != null ? currStatus.getRank() : -1;
        Assert.assertEquals((long)(currRank + 1), (long)result.getRank().intValue());
        Assert.assertEquals((Object)"newStatus", (Object)result.getName());
    }

    @Test
    public void testDeleteLastStatus() throws EntityNotFoundException, NotAllowedOperationOnEntityException, Exception {
        Project project = TestUtils.getDefaultProject();
        Status s1 = TestUtils.getDefaultStatus();
        s1.setProject(project);
        Status s2 = TestUtils.getDefaultStatus();
        s2.setId(2L);
        s2.setProject(project);
        Task t = TestUtils.getDefaultTask();
        t.setStatus(s2);
        HashSet<String> participator = new HashSet<String>();
        participator.add("Tib");
        ProjectQuery query = new ProjectQuery();
        query.setId(project.getId());
        Mockito.when((Object)this.daoHandler.getProjectHandler().selectProjectField(query, "participator")).thenReturn(Collections.singletonList(participator));
        Mockito.when((Object)this.statusHandler.find((Serializable)Long.valueOf(s2.getId()))).thenReturn((Object)s2);
        Mockito.when((Object)this.statusHandler.getStatuses(project.getId())).thenReturn(Arrays.asList(s1, s2)).thenReturn(Arrays.asList(s1));
        this.statusService.removeStatus(s2.getId());
        ((StatusHandler)Mockito.verify((Object)this.statusHandler, (VerificationMode)Mockito.times((int)1))).delete(this.statusCaptor.capture());
    }

    @Test
    public void testUpdateStatus() throws EntityNotFoundException, NotAllowedOperationOnEntityException {
        Project project = TestUtils.getDefaultProject();
        Status s1 = TestUtils.getDefaultStatus();
        Status s2 = TestUtils.getDefaultStatus();
        Status s3 = TestUtils.getDefaultStatus();
        s2.setId(2L);
        s2.setName("s3");
        s2.setProject(project);
        s3.setId(2L);
        s3.setName("s3");
        s3.setProject(project);
        ArrayList<Status> sts = new ArrayList<Status>();
        sts.add(s1);
        sts.add(s2);
        Mockito.when((Object)this.statusHandler.find((Serializable)Long.valueOf(s2.getId()))).thenReturn((Object)s2);
        Mockito.when((Object)this.statusHandler.getStatuses(project.getId())).thenReturn(sts);
        try {
            this.statusService.updateStatus(s2.getId(), s1.getName());
            Assert.fail((String)"should raise exception for duplicating name");
        }
        catch (NotAllowedOperationOnEntityException notAllowedOperationOnEntityException) {
            // empty catch block
        }
        Mockito.when((Object)this.daoHandler.getStatusHandler().update((Object)s2)).thenReturn((Object)s2);
        this.statusService.updateStatus(s2.getId(), "s3");
        ((StatusHandler)Mockito.verify((Object)this.statusHandler, (VerificationMode)Mockito.times((int)1))).update(this.statusCaptor.capture());
        Assert.assertEquals((long)s2.getId(), (long)((Status)this.statusCaptor.getValue()).getId());
        Assert.assertEquals((Object)"s3", (Object)((Status)this.statusCaptor.getValue()).getName());
    }
}

