/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.legacy.service;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.TimeZone;
import org.exoplatform.task.domain.Priority;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.legacy.service.ParserContext;
import org.exoplatform.task.legacy.service.TaskParser;
import org.exoplatform.task.legacy.service.impl.TaskParserImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestTaskParser {
    private TaskParser creator;
    private ParserContext context = new ParserContext(TimeZone.getDefault());

    @Before
    public void setup() {
        this.creator = new TaskParserImpl();
    }

    @Test
    public void testParserHighPriority() {
        Task task = this.creator.parse("Test task !High tomorrow", this.context);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Test task tomorrow", (Object)task.getTitle());
        Assert.assertEquals((String)"Priority must be high", (Object)Priority.HIGH, (Object)task.getPriority());
        task = this.creator.parse("Test task !HIGH tomorrow", this.context);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"Test task tomorrow", (Object)task.getTitle());
        Assert.assertEquals((String)"Priority must be High", (Object)Priority.HIGH, (Object)task.getPriority());
        task = this.creator.parse("Test task !higH tomorrow", this.context);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)"", (Object)"Test task tomorrow", (Object)task.getTitle());
        Assert.assertEquals((String)"Priority must be High", (Object)Priority.HIGH, (Object)task.getPriority());
        task = this.creator.parse("Test task !Low tomorrow !higH", this.context);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)"", (Object)"Test task tomorrow", (Object)task.getTitle());
        Assert.assertEquals((String)"Priority must be High", (Object)Priority.HIGH, (Object)task.getPriority());
    }

    @Test
    public void testParserLowPriority() {
        Task task = this.creator.parse("Test task !Low tomorrow", this.context);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)"", (Object)"Test task tomorrow", (Object)task.getTitle());
        Assert.assertEquals((String)"Priority must be low", (Object)Priority.LOW, (Object)task.getPriority());
        task = this.creator.parse("Test task !LOW tomorrow", this.context);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)"", (Object)"Test task tomorrow", (Object)task.getTitle());
        Assert.assertEquals((String)"Priority must be low", (Object)Priority.LOW, (Object)task.getPriority());
        task = this.creator.parse("Test task !loW tomorrow", this.context);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)"", (Object)"Test task tomorrow", (Object)task.getTitle());
        Assert.assertEquals((String)"Priority must be low", (Object)Priority.LOW, (Object)task.getPriority());
    }

    @Test
    public void testParserAssignee() {
        Task task = this.creator.parse("Test task @john tomorrow", this.context);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)"", (Object)"Test task tomorrow", (Object)task.getTitle());
        Assert.assertEquals((String)"Assignee must be john", (Object)"john", (Object)task.getAssignee());
        task = this.creator.parse("Test task tomorrow @john", this.context);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)"", (Object)"Test task tomorrow", (Object)task.getTitle());
        Assert.assertEquals((String)"Assignee must be john", (Object)"john", (Object)task.getAssignee());
    }

    @Test
    public void testParserAssigneeAndCoworkerWhenInMiddleOfTheMessage() {
        String message = "Test task @john @mary tomorrow";
        Task task = this.creator.parse(message, this.context);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)"", (Object)"Test task tomorrow", (Object)task.getTitle());
        Assert.assertEquals((String)"Assignee must be john", (Object)"john", (Object)task.getAssignee());
        Assert.assertNotNull((Object)task.getCoworker());
        Assert.assertEquals((String)"There must be 1 coworker", (long)1L, (long)task.getCoworker().size());
        Assert.assertEquals((String)"Coworker must be mary", (Object)"mary", task.getCoworker().iterator().next());
    }

    @Test
    public void testParserAssigneeAndCoworkerWhenAtTheEndOfTheMessage() {
        String message = "Test task tomorrow @john @mary";
        Task task = this.creator.parse(message, this.context);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)"", (Object)"Test task tomorrow", (Object)task.getTitle());
        Assert.assertEquals((String)"Assignee must be john", (Object)"john", (Object)task.getAssignee());
        Assert.assertNotNull((Object)task.getCoworker());
        Assert.assertEquals((String)"There must be 1 coworker", (long)1L, (long)task.getCoworker().size());
        Assert.assertEquals((String)"Coworker must be mary", (Object)"mary", task.getCoworker().iterator().next());
    }

    @Test
    public void testParserAssigneeAndMultipleCoworkerWhenAtTheEndOfTheMessage() {
        String message = "Test task tomorrow @john @mary @james";
        Task task = this.creator.parse(message, this.context);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)"", (Object)"Test task tomorrow", (Object)task.getTitle());
        Assert.assertEquals((String)"Assignee must be john", (Object)"john", (Object)task.getAssignee());
        Assert.assertNotNull((Object)task.getCoworker());
        Assert.assertEquals((String)"There must be 2 coworkers", (long)2L, (long)task.getCoworker().size());
        Assert.assertTrue((String)"mary must be part of the coworkers", (boolean)task.getCoworker().contains("mary"));
        Assert.assertTrue((String)"james must be part of the coworkers", (boolean)task.getCoworker().contains("james"));
    }

    @Test
    public void testParserDueDate() {
        Calendar current = Calendar.getInstance();
        Task task = this.creator.parse("Test task ^today tomorrow", this.context);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)"", (Object)"Test task tomorrow", (Object)task.getTitle());
        Date dueDate = task.getDueDate();
        Assert.assertNotNull((Object)dueDate);
        Calendar dueCalendar = Calendar.getInstance();
        dueCalendar.setTime(dueDate);
        Assert.assertEquals((long)current.get(5), (long)dueCalendar.get(5));
        Assert.assertEquals((long)current.get(2), (long)dueCalendar.get(2));
        Assert.assertEquals((long)current.get(1), (long)dueCalendar.get(1));
    }

    @Test
    public void testParserDueDateTomorrow() {
        Calendar tomorrow = Calendar.getInstance();
        tomorrow.add(5, 1);
        Task task = this.creator.parse("Test task ^tomorrow need to do", this.context);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)"", (Object)"Test task need to do", (Object)task.getTitle());
        Date dueDate = task.getDueDate();
        Assert.assertNotNull((Object)dueDate);
        Calendar dueCalendar = Calendar.getInstance();
        dueCalendar.setTime(dueDate);
        Assert.assertEquals((long)tomorrow.get(5), (long)dueCalendar.get(5));
        Assert.assertEquals((long)tomorrow.get(2), (long)dueCalendar.get(2));
        Assert.assertEquals((long)tomorrow.get(1), (long)dueCalendar.get(1));
    }

    @Test
    public void testParserDueDateNextFriday() {
        Calendar nextFriday = Calendar.getInstance();
        nextFriday.add(5, 1);
        while (nextFriday.get(7) != 6) {
            nextFriday.add(5, 1);
        }
        Task task = this.creator.parse("Test task ^Friday need to do", this.context);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)"", (Object)"Test task need to do", (Object)task.getTitle());
        Date dueDate = task.getDueDate();
        Assert.assertNotNull((Object)dueDate);
        Calendar dueCalendar = Calendar.getInstance();
        dueCalendar.setTime(dueDate);
        Assert.assertEquals((long)nextFriday.get(5), (long)dueCalendar.get(5));
        Assert.assertEquals((long)nextFriday.get(2), (long)dueCalendar.get(2));
        Assert.assertEquals((long)nextFriday.get(1), (long)dueCalendar.get(1));
    }

    @Test
    public void testParserDueDateNextWeek() {
        Calendar nextFriday = Calendar.getInstance();
        nextFriday.add(5, 7);
        Task task = this.creator.parse("Test task ^next week need to do", this.context);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)"", (Object)"Test task need to do", (Object)task.getTitle());
        Date dueDate = task.getDueDate();
        Assert.assertNotNull((Object)dueDate);
        Calendar dueCalendar = Calendar.getInstance();
        dueCalendar.setTime(dueDate);
        Assert.assertEquals((long)nextFriday.get(5), (long)dueCalendar.get(5));
        Assert.assertEquals((long)nextFriday.get(2), (long)dueCalendar.get(2));
        Assert.assertEquals((long)nextFriday.get(1), (long)dueCalendar.get(1));
    }

    @Test
    public void testParserDueDateNextMonth() {
        Calendar nextMonth = Calendar.getInstance();
        nextMonth.add(2, 1);
        Task task = this.creator.parse("Test task ^next month need to do", this.context);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)"", (Object)"Test task need to do", (Object)task.getTitle());
        Date dueDate = task.getDueDate();
        Assert.assertNotNull((Object)dueDate);
        Calendar dueCalendar = Calendar.getInstance();
        dueCalendar.setTime(dueDate);
        Assert.assertEquals((long)nextMonth.get(5), (long)dueCalendar.get(5));
        Assert.assertEquals((long)nextMonth.get(2), (long)dueCalendar.get(2));
        Assert.assertEquals((long)nextMonth.get(1), (long)dueCalendar.get(1));
    }

    @Test
    public void testParserDueDateAtSpecificDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 2);
        Task task = this.creator.parse("Test task ^" + calendar.get(5) + " need to do", this.context);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)"", (Object)"Test task need to do", (Object)task.getTitle());
        Date dueDate = task.getDueDate();
        Assert.assertNotNull((Object)dueDate);
        Calendar dueCalendar = Calendar.getInstance();
        dueCalendar.setTime(dueDate);
        Assert.assertEquals((long)calendar.get(5), (long)dueCalendar.get(5));
        Assert.assertEquals((long)calendar.get(2), (long)dueCalendar.get(2));
        Assert.assertEquals((long)calendar.get(1), (long)dueCalendar.get(1));
    }

    @Test
    public void testParserDueDateAtMar24() {
        Calendar nextMonth = Calendar.getInstance();
        long currentTime = nextMonth.getTimeInMillis();
        nextMonth.set(2, 2);
        nextMonth.set(5, 24);
        if (currentTime > nextMonth.getTimeInMillis()) {
            nextMonth.add(1, 1);
        }
        Task task = this.creator.parse("Test task ^24-mar need to do", this.context);
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((String)"", (Object)"Test task need to do", (Object)task.getTitle());
        Date dueDate = task.getDueDate();
        Assert.assertNotNull((Object)dueDate);
        Calendar dueCalendar = Calendar.getInstance();
        dueCalendar.setTime(dueDate);
        Assert.assertEquals((long)nextMonth.get(5), (long)dueCalendar.get(5));
        Assert.assertEquals((long)nextMonth.get(2), (long)dueCalendar.get(2));
        Assert.assertEquals((long)nextMonth.get(1), (long)dueCalendar.get(1));
    }

    private void assertEqual(Collection<String> expected, Collection<String> actual) {
        if (expected.size() != actual.size()) {
            Assert.fail((String)"Size of 2 collection must be the same");
        }
        for (String e1 : expected) {
            boolean existed = false;
            for (String e2 : actual) {
                if (e1 != e2 && !e1.equals(e2)) continue;
                existed = true;
                break;
            }
            if (existed) continue;
            Assert.fail((String)("Collection is not the same, expect: " + expected + ", actual: " + actual));
        }
    }
}

