/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.security;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.task.AbstractTest;
import org.exoplatform.task.dao.DAOHandler;
import org.exoplatform.task.dao.ProjectHandler;
import org.exoplatform.task.dao.TaskHandler;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.legacy.service.ParserContext;
import org.exoplatform.task.legacy.service.TaskParser;
import org.exoplatform.task.legacy.service.impl.TaskParserImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestPermission
extends AbstractTest {
    private TaskHandler tDAO;
    private ProjectHandler pDAO;
    private DAOHandler daoHandler;
    private TaskParser parser = new TaskParserImpl();
    private ParserContext context = new ParserContext(TimeZone.getDefault());

    @Before
    public void setup() {
        PortalContainer container = PortalContainer.getInstance();
        this.daoHandler = (DAOHandler)container.getComponentInstanceOfType(DAOHandler.class);
        this.pDAO = this.daoHandler.getProjectHandler();
        this.tDAO = this.daoHandler.getTaskHandler();
        this.pDAO = this.daoHandler.getProjectHandler();
    }

    @After
    public void tearDown() {
        this.tDAO.deleteAll();
        this.daoHandler.getStatusHandler().deleteAll();
        this.pDAO.deleteAll();
    }

    @Test
    public void testTaskAssignPermission() {
        String user1 = "user1";
        String user2 = "user2";
        ArrayList<Task> tasks = new ArrayList<Task>();
        Task task1 = this.parser.parse("Task of User 1", this.context);
        task1.setCreatedBy(user1);
        task1.setAssignee(user1);
        tasks.add(task1);
        Task task2 = this.parser.parse("Task of User 1 assign to user 2", this.context);
        task2.setCreatedBy(user1);
        task2.setAssignee(user2);
        tasks.add(task2);
        this.tDAO.createAll(tasks);
        Assert.assertEquals((long)2L, (long)this.tDAO.findByUser(user1).size());
        Assert.assertEquals((long)1L, (long)this.tDAO.findByUser(user2).size());
        Assert.assertEquals((long)0L, (long)this.tDAO.findByUser("John Doe").size());
    }

    @Test
    public void testTaskCoworkerPermission() {
        String user1 = "user1";
        String user2 = "user2";
        HashSet<String> coworkers = new HashSet<String>();
        coworkers.add(user2);
        ArrayList<Task> tasks = new ArrayList<Task>();
        Task task1 = this.parser.parse("Task of User 1", this.context);
        task1.setCreatedBy(user1);
        task1.setAssignee(user1);
        tasks.add(task1);
        Task task2 = this.parser.parse("Task of User 1 with user2 as coworker", this.context);
        task2.setCreatedBy(user1);
        task2.setAssignee(user1);
        task2.setCoworker(coworkers);
        tasks.add(task2);
        this.tDAO.createAll(tasks);
        Assert.assertEquals((long)2L, (long)this.tDAO.findByUser(user1).size());
        Assert.assertEquals((long)1L, (long)this.tDAO.findByUser(user2).size());
        Assert.assertEquals((long)0L, (long)this.tDAO.findByUser("John Doe").size());
    }

    @Test
    public void testProjectManagerPermission() throws Exception {
        String user1 = "user1";
        String user2 = "user2";
        HashSet<String> managers = new HashSet<String>();
        managers.add(user2);
        Project project = new Project();
        project.setName("Project of user 2 manager");
        project.setManager(managers);
        this.pDAO.create((Object)project);
        Status status = new Status();
        status.setName("TODO");
        status.setRank(Integer.valueOf(1));
        status.setProject(project);
        this.daoHandler.getStatusHandler().create((Object)status);
        Task task1 = this.parser.parse("Task of User 1", this.context);
        task1.setCreatedBy(user1);
        task1.setAssignee(user1);
        Task task2 = this.parser.parse("Task of User 1 in project user 2 manage", this.context);
        task2.setCreatedBy(user1);
        task2.setAssignee(user1);
        task2.setStatus(status);
        this.tDAO.create((Object)task1);
        this.tDAO.create((Object)task2);
        Assert.assertEquals((long)2L, (long)this.tDAO.findByUser(user1).size());
        Assert.assertEquals((long)1L, (long)this.tDAO.findByUser(user2).size());
        Assert.assertEquals((long)0L, (long)this.tDAO.findByUser("John Doe").size());
        Assert.assertEquals((long)0L, (long)this.pDAO.findAllByMembershipsAndKeyword(this.getMembershipsUser(user1), null, null).getSize());
        Assert.assertEquals((long)1L, (long)this.pDAO.findAllByMembershipsAndKeyword(this.getMembershipsUser(user2), null, null).getSize());
    }

    @Test
    public void testProjectMemberPermission() throws Exception {
        String user1 = "user1";
        String user2 = "user2";
        HashSet<String> members = new HashSet<String>();
        members.add(user2);
        Project project = new Project();
        project.setName("Project of user 2 manager");
        project.setManager(members);
        this.pDAO.create((Object)project);
        Status status = new Status();
        status.setName("TODO");
        status.setRank(Integer.valueOf(1));
        status.setProject(project);
        this.daoHandler.getStatusHandler().create((Object)status);
        Task task1 = this.parser.parse("Task of User 1", this.context);
        task1.setCreatedBy(user1);
        task1.setAssignee(user1);
        Task task2 = this.parser.parse("Task of User 1 in project user 2 member", this.context);
        task2.setCreatedBy(user1);
        task2.setAssignee(user1);
        task2.setStatus(status);
        this.tDAO.create((Object)task1);
        this.tDAO.create((Object)task2);
        Assert.assertEquals((long)2L, (long)this.tDAO.findByUser(user1).size());
        Assert.assertEquals((long)1L, (long)this.tDAO.findByUser(user2).size());
        Assert.assertEquals((long)0L, (long)this.tDAO.findByUser("John Doe").size());
        Assert.assertEquals((long)0L, (long)this.pDAO.findAllByMembershipsAndKeyword(this.getMembershipsUser(user1), null, null).getSize());
        Assert.assertEquals((long)1L, (long)this.pDAO.findAllByMembershipsAndKeyword(this.getMembershipsUser(user2), null, null).getSize());
    }

    private List<String> getMembershipsUser(String user) {
        ArrayList<String> memberships = new ArrayList<String>();
        memberships.add(user);
        return memberships;
    }
}

