/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.legacy.service;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.exoplatform.task.domain.Priority;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.Task;

public class TaskBuilder {
    private String title;
    private String description;
    private Priority priority = Priority.NORMAL;
    private String context;
    private String assignee;
    private Set<String> coworker;
    private Set<String> watcher;
    private Status status;
    private String createdBy;
    private Date createdTime = new Date();
    private Date endDate;
    private Date startDate;
    private Date dueDate;

    public Task build() {
        Task task = new Task();
        task.setTitle(this.title);
        task.setDescription(this.description);
        task.setPriority(this.priority);
        task.setContext(this.context);
        task.setAssignee(this.assignee);
        task.setCoworker(this.coworker);
        task.setWatcher(this.watcher);
        task.setStatus(this.status);
        task.setCreatedBy(this.createdBy);
        task.setCreatedTime(this.createdTime);
        task.setEndDate(this.endDate);
        task.setStartDate(this.startDate);
        task.setDueDate(this.dueDate);
        return task;
    }

    public TaskBuilder withTitle(String title) {
        this.title = title;
        return this;
    }

    public TaskBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public TaskBuilder withPriority(Priority priority) {
        this.priority = priority;
        return this;
    }

    public TaskBuilder withAssignee(String assignee) {
        this.assignee = assignee;
        return this;
    }

    public TaskBuilder withWatcher(Set<String> watcher) {
        this.watcher = watcher;
        return this;
    }

    public TaskBuilder withCoworker(Set<String> coworker) {
        this.coworker = coworker;
        return this;
    }

    public TaskBuilder addCoworker(String coworker) {
        if (this.coworker == null) {
            this.coworker = new HashSet<String>();
        }
        this.coworker.add(coworker);
        return this;
    }

    public TaskBuilder withContext(String context) {
        this.context = context;
        return this;
    }

    public TaskBuilder withDueDate(Date date) {
        this.dueDate = date;
        return this;
    }

    public TaskBuilder withStatus(Status status) {
        this.status = status;
        return this;
    }

    public TaskBuilder withCreatedBy(String username) {
        this.createdBy = username;
        return this;
    }

    public TaskBuilder withEndDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    public TaskBuilder withStartDate(Date date) {
        this.startDate = date;
        return this;
    }
}

