/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.service;

import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import org.exoplatform.services.security.Identity;
import org.exoplatform.task.dao.OrderBy;
import org.exoplatform.task.dao.TaskQuery;
import org.exoplatform.task.domain.Priority;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.dto.ChangeLogEntry;
import org.exoplatform.task.dto.LabelDto;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.dto.TasksList;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.util.TaskUtil;

public interface TaskService {
    public static final String TASK_CREATION = "exo.task.taskCreation";
    public static final String TASK_UPDATE = "exo.task.taskUpdate";
    public static final String TASK_COMMENT_CREATION = "exo.task.taskCommentCreation";

    public TaskDto createTask(TaskDto var1);

    public TaskDto updateTask(TaskDto var1);

    public void updateTaskOrder(long var1, Status var3, long[] var4);

    public void removeTask(long var1) throws EntityNotFoundException;

    public TaskDto cloneTask(long var1) throws EntityNotFoundException;

    public TaskDto getTask(long var1) throws EntityNotFoundException;

    public List<TaskDto> getWatchedTasks(String var1, int var2);

    public Long countWatchedTasks(String var1);

    public List<TaskDto> getAssignedTasks(String var1, int var2);

    public Long countAssignedTasks(String var1);

    public List<TaskDto> getCollaboratedTasks(String var1, int var2);

    public Long countCollaboratedTasks(String var1);

    public List<TaskDto> findTasks(String var1, String var2, int var3);

    public int countTasks(TaskQuery var1) throws Exception;

    public <T> List<T> selectTaskField(TaskQuery var1, String var2);

    public List<TaskDto> findTasksByLabel(LabelDto var1, List<Long> var2, String var3, OrderBy var4, int var5, int var6) throws Exception;

    public int countTasksByLabel(LabelDto var1, List<Long> var2, String var3, OrderBy var4) throws Exception;

    public ChangeLogEntry addTaskLog(long var1, String var3, String var4, String var5) throws EntityNotFoundException;

    public List<ChangeLogEntry> getTaskLogs(long var1, int var3, int var4) throws Exception;

    public TaskDto findTaskByActivityId(String var1);

    public Set<String> getCoworker(long var1);

    public Set<String> getMentionedUsers(long var1);

    public List<TaskDto> getUncompletedTasks(String var1, int var2);

    public Long countUncompletedTasks(String var1);

    public List<TaskDto> getIncomingTasks(String var1, int var2, int var3) throws Exception;

    public int countIncomingTasks(String var1) throws Exception;

    public List<TaskDto> getOverdueTasks(String var1, int var2);

    public Long countOverdueTasks(String var1);

    public Set<String> getWatchersOfTask(TaskDto var1);

    public void addWatcherToTask(String var1, TaskDto var2) throws Exception;

    public void deleteWatcherOfTask(String var1, TaskDto var2) throws Exception;

    public List<TaskDto> findTasks(TaskQuery var1, int var2, int var3) throws Exception;

    public long countTasks(String var1, String var2);

    public List<Object[]> countTaskStatusByProject(long var1);

    public TasksList filterTasks(String var1, long var2, String var4, List<Long> var5, TaskUtil.DUE var6, Priority var7, List<String> var8, List<String> var9, List<String> var10, Long var11, Long var12, Identity var13, String var14, String var15, TimeZone var16, boolean var17, boolean var18, boolean var19, boolean var20, String var21, String var22, int var23, int var24) throws Exception;

    public boolean isExternal(String var1);
}

