/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.service.impl;

import java.util.List;
import javax.inject.Inject;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.task.dao.DAOHandler;
import org.exoplatform.task.domain.Label;
import org.exoplatform.task.domain.LabelTaskMapping;
import org.exoplatform.task.dto.LabelDto;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.service.LabelService;
import org.exoplatform.task.service.impl.LabelServiceImpl$AjcClosure1;
import org.exoplatform.task.service.impl.LabelServiceImpl$AjcClosure11;
import org.exoplatform.task.service.impl.LabelServiceImpl$AjcClosure3;
import org.exoplatform.task.service.impl.LabelServiceImpl$AjcClosure5;
import org.exoplatform.task.service.impl.LabelServiceImpl$AjcClosure7;
import org.exoplatform.task.service.impl.LabelServiceImpl$AjcClosure9;
import org.exoplatform.task.storage.LabelStorage;
import org.exoplatform.task.storage.ProjectStorage;
import org.exoplatform.task.util.StorageUtil;

public class LabelServiceImpl
implements LabelService {
    private static final Log LOG;
    String LABEL_ADDED_TO_TASK = "exo.task.labelAddedToTask";
    String LABEL_DELETED_FROM_TASK = "exo.task.labelDeletedFromTask";
    @Inject
    private DAOHandler daoHandler;
    @Inject
    private LabelStorage labelStorage;
    @Inject
    private ProjectStorage projectStorage;
    private ListenerService listenerService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    public LabelServiceImpl(LabelStorage labelStorage, DAOHandler daoHandler, ProjectStorage projectStorage, ListenerService listenerService) {
        this.labelStorage = labelStorage;
        this.daoHandler = daoHandler;
        this.projectStorage = projectStorage;
        this.listenerService = listenerService;
    }

    @Override
    public List<LabelDto> findLabelsByUser(String username, int offset, int limit) {
        return this.labelStorage.findLabelsByUser(username, offset, limit);
    }

    @Override
    public List<LabelDto> findLabelsByProject(long projectId, Identity currentUser, int offset, int limit) {
        return this.labelStorage.findLabelsByProject(projectId, currentUser, this.projectStorage, offset, limit);
    }

    @Override
    public List<LabelDto> findLabelsByTask(TaskDto task, long projectId, Identity currentUser, int offset, int limit) {
        return this.labelStorage.findLabelsByTask(task, projectId, currentUser, this.projectStorage, offset, limit);
    }

    @Override
    public LabelDto getLabel(long labelId) {
        return StorageUtil.labelToDto((Label)this.daoHandler.getLabelHandler().find(Long.valueOf(labelId)));
    }

    @Override
    @ExoTransactional
    public LabelDto createLabel(LabelDto label) {
        LabelDto labelDto = label;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)labelDto);
        Object[] objectArray = new Object[]{this, labelDto, joinPoint};
        LabelServiceImpl$AjcClosure1 labelServiceImpl$AjcClosure1 = new LabelServiceImpl$AjcClosure1(objectArray);
        return (LabelDto)ExoTransactionalAspect.aspectOf().around(labelServiceImpl$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public LabelDto updateLabel(LabelDto label, List<Label.FIELDS> fields) throws EntityNotFoundException {
        LabelDto labelDto = label;
        List<Label.FIELDS> list = fields;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)labelDto, list);
        Object[] objectArray = new Object[]{this, labelDto, list, joinPoint};
        LabelServiceImpl$AjcClosure3 labelServiceImpl$AjcClosure3 = new LabelServiceImpl$AjcClosure3(objectArray);
        return (LabelDto)ExoTransactionalAspect.aspectOf().around(labelServiceImpl$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public LabelDto updateLabel(LabelDto label) throws EntityNotFoundException {
        LabelDto labelDto = label;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)labelDto);
        Object[] objectArray = new Object[]{this, labelDto, joinPoint};
        LabelServiceImpl$AjcClosure5 labelServiceImpl$AjcClosure5 = new LabelServiceImpl$AjcClosure5(objectArray);
        return (LabelDto)ExoTransactionalAspect.aspectOf().around(labelServiceImpl$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public void removeLabel(long labelId) {
        long l = labelId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), joinPoint};
        LabelServiceImpl$AjcClosure7 labelServiceImpl$AjcClosure7 = new LabelServiceImpl$AjcClosure7(objectArray);
        ExoTransactionalAspect.aspectOf().around(labelServiceImpl$AjcClosure7.linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public void addTaskToLabel(TaskDto task, Long labelId) throws EntityNotFoundException {
        TaskDto taskDto = task;
        Long l = labelId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)taskDto, (Object)l);
        Object[] objectArray = new Object[]{this, taskDto, l, joinPoint};
        LabelServiceImpl$AjcClosure9 labelServiceImpl$AjcClosure9 = new LabelServiceImpl$AjcClosure9(objectArray);
        ExoTransactionalAspect.aspectOf().around(labelServiceImpl$AjcClosure9.linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public void removeTaskFromLabel(TaskDto task, Long labelId) throws EntityNotFoundException {
        TaskDto taskDto = task;
        Long l = labelId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)taskDto, (Object)l);
        Object[] objectArray = new Object[]{this, taskDto, l, joinPoint};
        LabelServiceImpl$AjcClosure11 labelServiceImpl$AjcClosure11 = new LabelServiceImpl$AjcClosure11(objectArray);
        ExoTransactionalAspect.aspectOf().around(labelServiceImpl$AjcClosure11.linkClosureAndJoinPoint(69648));
    }

    private void broadcastEvent(String eventName, LabelTaskMapping data) {
        ConversationState conversationState = ConversationState.getCurrent();
        String currentUserName = conversationState.getIdentity().getUserId();
        try {
            if (data != null) {
                this.listenerService.broadcast(eventName, (Object)currentUserName, (Object)data);
            }
        }
        catch (Exception e) {
            LOG.warn("Error while broadcasting event {}", new Object[]{eventName, e});
        }
    }

    static {
        LabelServiceImpl.ajc$preClinit();
        LOG = ExoLogger.getExoLogger(LabelServiceImpl.class);
    }

    static /* synthetic */ LabelDto createLabel_aroundBody0(LabelServiceImpl ajc$this, LabelDto label, JoinPoint joinPoint) {
        return ajc$this.labelStorage.createLabel(label);
    }

    static /* synthetic */ LabelDto updateLabel_aroundBody2(LabelServiceImpl ajc$this, LabelDto label, List fields, JoinPoint joinPoint) {
        LabelDto lb = ajc$this.getLabel(label.getId());
        if (lb == null) {
            throw new EntityNotFoundException(label.getId(), (Class<?>)LabelDto.class);
        }
        for (Label.FIELDS field : fields) {
            switch (field) {
                case NAME: {
                    lb.setName(label.getName());
                    break;
                }
                case COLOR: {
                    lb.setColor(label.getColor());
                    break;
                }
                case PARENT: {
                    lb.setParent(label.getParent());
                    break;
                }
                case HIDDEN: {
                    lb.setHidden(label.isHidden());
                }
            }
        }
        return StorageUtil.labelToDto((Label)ajc$this.daoHandler.getLabelHandler().update(StorageUtil.mappingLabelToEntity(lb)));
    }

    static /* synthetic */ LabelDto updateLabel_aroundBody4(LabelServiceImpl ajc$this, LabelDto label, JoinPoint joinPoint) {
        LabelDto lb = ajc$this.getLabel(label.getId());
        if (lb == null) {
            throw new EntityNotFoundException(label.getId(), (Class<?>)LabelDto.class);
        }
        lb.setName(label.getName());
        lb.setColor(label.getColor());
        lb.setHidden(label.isHidden());
        return StorageUtil.labelToDto((Label)ajc$this.daoHandler.getLabelHandler().update(StorageUtil.labelToEntity(lb)));
    }

    static /* synthetic */ void removeLabel_aroundBody6(LabelServiceImpl ajc$this, long labelId, JoinPoint joinPoint) {
        ajc$this.daoHandler.getLabelHandler().delete(StorageUtil.labelToEntity(ajc$this.getLabel(labelId)));
    }

    static /* synthetic */ void addTaskToLabel_aroundBody8(LabelServiceImpl ajc$this, TaskDto task, Long labelId, JoinPoint joinPoint) {
        LabelTaskMapping mapping = new LabelTaskMapping();
        mapping.setLabel(StorageUtil.mappingLabelToEntity(ajc$this.getLabel(labelId)));
        mapping.setTask(StorageUtil.taskToEntity(task));
        ajc$this.daoHandler.getLabelTaskMappingHandler().create(mapping);
        ajc$this.broadcastEvent(ajc$this.LABEL_ADDED_TO_TASK, mapping);
    }

    static /* synthetic */ void removeTaskFromLabel_aroundBody10(LabelServiceImpl ajc$this, TaskDto task, Long labelId, JoinPoint joinPoint) {
        LabelTaskMapping mapping = ajc$this.daoHandler.getLabelTaskMappingHandler().findLabelTaskMapping(labelId, task.getId());
        ajc$this.daoHandler.getLabelTaskMappingHandler().delete(mapping);
        ajc$this.broadcastEvent(ajc$this.LABEL_DELETED_FROM_TASK, mapping);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("LabelServiceImpl.java", LabelServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createLabel", "org.exoplatform.task.service.impl.LabelServiceImpl", "org.exoplatform.task.dto.LabelDto", "label", "", "org.exoplatform.task.dto.LabelDto"), 73);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateLabel", "org.exoplatform.task.service.impl.LabelServiceImpl", "org.exoplatform.task.dto.LabelDto:java.util.List", "label:fields", "org.exoplatform.task.exception.EntityNotFoundException", "org.exoplatform.task.dto.LabelDto"), 79);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateLabel", "org.exoplatform.task.service.impl.LabelServiceImpl", "org.exoplatform.task.dto.LabelDto", "label", "org.exoplatform.task.exception.EntityNotFoundException", "org.exoplatform.task.dto.LabelDto"), 107);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeLabel", "org.exoplatform.task.service.impl.LabelServiceImpl", "long", "labelId", "", "void"), 120);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addTaskToLabel", "org.exoplatform.task.service.impl.LabelServiceImpl", "org.exoplatform.task.dto.TaskDto:java.lang.Long", "task:labelId", "org.exoplatform.task.exception.EntityNotFoundException", "void"), 127);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeTaskFromLabel", "org.exoplatform.task.service.impl.LabelServiceImpl", "org.exoplatform.task.dto.TaskDto:java.lang.Long", "task:labelId", "org.exoplatform.task.exception.EntityNotFoundException", "void"), 137);
    }
}

