/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.service.impl;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.task.dao.DAOHandler;
import org.exoplatform.task.dto.CommentDto;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.service.CommentService;
import org.exoplatform.task.service.impl.CommentServiceImpl$AjcClosure1;
import org.exoplatform.task.service.impl.CommentServiceImpl$AjcClosure3;
import org.exoplatform.task.service.impl.CommentServiceImpl$AjcClosure5;
import org.exoplatform.task.storage.CommentStorage;
import org.exoplatform.task.storage.TaskStorage;

public class CommentServiceImpl
implements CommentService {
    private static final Log LOG;
    private static final Pattern pattern;
    @Inject
    private TaskStorage taskStorage;
    @Inject
    private CommentStorage commentStorage;
    @Inject
    private DAOHandler daoHandler;
    private ListenerService listenerService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public CommentServiceImpl(TaskStorage taskStorage, CommentStorage commentStorage, DAOHandler daoHandler, ListenerService listenerService) {
        this.taskStorage = taskStorage;
        this.commentStorage = commentStorage;
        this.daoHandler = daoHandler;
        this.listenerService = listenerService;
    }

    @Override
    public CommentDto getComment(long commentId) {
        CommentDto comment = this.commentStorage.getComment(commentId);
        comment.setComment(this.substituteUsernames(comment.getComment()));
        return comment;
    }

    @Override
    public List<CommentDto> getComments(long taskId, int offset, int limit) {
        return this.commentStorage.getComments(taskId, offset, limit);
    }

    @Override
    public List<CommentDto> getCommentsWithSubs(long taskId, int offset, int limit) {
        return this.commentStorage.getCommentsWithSubs(taskId, offset, limit);
    }

    @Override
    public int countComments(long taskId) {
        return this.commentStorage.countComments(taskId);
    }

    @Override
    public List<CommentDto> loadSubComments(List<CommentDto> listComments) {
        if (listComments == null || listComments.isEmpty()) {
            return null;
        }
        listComments.forEach(comment -> comment.setComment(this.substituteUsernames(comment.getComment())));
        List<CommentDto> subComments = this.commentStorage.loadSubComments(listComments);
        for (CommentDto comment2 : listComments) {
            subComments.forEach(subComment -> subComment.setComment(this.substituteUsernames(subComment.getComment())));
            comment2.setSubComments(subComments.stream().filter(subComment -> subComment.getParentComment().getId() == comment2.getId()).collect(Collectors.toList()));
        }
        return listComments;
    }

    @Override
    @ExoTransactional
    public CommentDto addComment(TaskDto task, long parentCommentId, String username, String comment) throws EntityNotFoundException {
        TaskDto taskDto = task;
        long l = parentCommentId;
        String string = username;
        String string2 = comment;
        Object[] objectArray = new Object[]{taskDto, Conversions.longObject((long)l), string, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, taskDto, Conversions.longObject((long)l), string, string2, joinPoint};
        CommentServiceImpl$AjcClosure1 commentServiceImpl$AjcClosure1 = new CommentServiceImpl$AjcClosure1(objectArray2);
        return (CommentDto)ExoTransactionalAspect.aspectOf().around(commentServiceImpl$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public CommentDto addComment(TaskDto task, String username, String comment) throws EntityNotFoundException {
        TaskDto taskDto = task;
        String string = username;
        String string2 = comment;
        Object[] objectArray = new Object[]{taskDto, string, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, taskDto, string, string2, joinPoint};
        CommentServiceImpl$AjcClosure3 commentServiceImpl$AjcClosure3 = new CommentServiceImpl$AjcClosure3(objectArray2);
        return (CommentDto)ExoTransactionalAspect.aspectOf().around(commentServiceImpl$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public void removeComment(long commentId) throws EntityNotFoundException {
        long l = commentId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), joinPoint};
        CommentServiceImpl$AjcClosure5 commentServiceImpl$AjcClosure5 = new CommentServiceImpl$AjcClosure5(objectArray);
        ExoTransactionalAspect.aspectOf().around(commentServiceImpl$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    private String substituteUsernames(String message) {
        if (message == null || message.trim().isEmpty()) {
            return message;
        }
        Matcher matcher = pattern.matcher(message);
        StringBuffer buf = new StringBuffer();
        while (matcher.find()) {
            Identity identity;
            String username = matcher.group().substring(1);
            if (username == null || username.isEmpty() || (identity = LinkProvider.getIdentityManager().getOrCreateIdentity("organization", username, false)) == null || identity.isDeleted() || !identity.isEnable()) continue;
            try {
                username = LinkProvider.getProfileLink((String)username, (String)"dw");
            }
            catch (Exception e) {
                continue;
            }
            if (username == null) continue;
            matcher.appendReplacement(buf, username);
        }
        if (buf.length() > 0) {
            matcher.appendTail(buf);
            return buf.toString();
        }
        return message;
    }

    static {
        CommentServiceImpl.ajc$preClinit();
        LOG = ExoLogger.getExoLogger(CommentServiceImpl.class);
        pattern = Pattern.compile("@([^\\s]+)|@([^\\s]+)$");
    }

    static /* synthetic */ CommentDto addComment_aroundBody0(CommentServiceImpl ajc$this, TaskDto task, long parentCommentId, String username, String comment, JoinPoint joinPoint) {
        CommentDto commentDto = ajc$this.commentStorage.addComment(task, parentCommentId, username, comment);
        try {
            ajc$this.listenerService.broadcast("exo.task.taskCommentCreation", (Object)commentDto.getTask(), (Object)commentDto);
            if (commentDto.getTask().getStatus() != null) {
                ajc$this.listenerService.broadcast("exo.project.projectModified", null, (Object)commentDto.getTask().getStatus().getProject());
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while broadcasting task creation event", (Throwable)e);
        }
        return commentDto;
    }

    static /* synthetic */ CommentDto addComment_aroundBody2(CommentServiceImpl ajc$this, TaskDto task, String username, String comment, JoinPoint joinPoint) {
        return ajc$this.addComment(task, 0L, username, comment);
    }

    static /* synthetic */ void removeComment_aroundBody4(CommentServiceImpl ajc$this, long commentId, JoinPoint joinPoint) {
        CommentDto comment = ajc$this.commentStorage.getComment(commentId);
        if (comment == null) {
            LOG.info((Object)("Can not find comment with ID: " + commentId));
            throw new EntityNotFoundException(commentId, (Class<?>)CommentDto.class);
        }
        ajc$this.commentStorage.removeComment(commentId);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CommentServiceImpl.java", CommentServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addComment", "org.exoplatform.task.service.impl.CommentServiceImpl", "org.exoplatform.task.dto.TaskDto:long:java.lang.String:java.lang.String", "task:parentCommentId:username:comment", "org.exoplatform.task.exception.EntityNotFoundException", "org.exoplatform.task.dto.CommentDto"), 109);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addComment", "org.exoplatform.task.service.impl.CommentServiceImpl", "org.exoplatform.task.dto.TaskDto:java.lang.String:java.lang.String", "task:username:comment", "org.exoplatform.task.exception.EntityNotFoundException", "org.exoplatform.task.dto.CommentDto"), 126);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeComment", "org.exoplatform.task.service.impl.CommentServiceImpl", "long", "commentId", "org.exoplatform.task.exception.EntityNotFoundException", "void"), 133);
    }
}

