/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.domain;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.task.domain.Project;

@Entity(name="TaskUserSetting")
@ExoEntity
@Table(name="TASK_USER_SETTINGS")
public class UserSetting {
    @Id
    @Column(name="USERNAME")
    private String username;
    @Column(name="SHOW_HIDDEN_PROJECT")
    private boolean showHiddenProject = false;
    @Column(name="SHOW_HIDDEN_LABEL")
    private boolean showHiddenLabel = false;
    @ManyToMany
    @JoinTable(name="TASK_HIDDEN_PROJECTS", joinColumns={@JoinColumn(name="USERNAME", referencedColumnName="USERNAME")}, inverseJoinColumns={@JoinColumn(name="PROJECT_ID", referencedColumnName="PROJECT_ID")})
    private Set<Project> hiddenProjects = new HashSet<Project>();

    public UserSetting() {
    }

    public UserSetting(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isShowHiddenProject() {
        return this.showHiddenProject;
    }

    public void setShowHiddenProject(boolean showHiddenProject) {
        this.showHiddenProject = showHiddenProject;
    }

    public boolean isShowHiddenLabel() {
        return this.showHiddenLabel;
    }

    public void setShowHiddenLabel(boolean showHiddenLabel) {
        this.showHiddenLabel = showHiddenLabel;
    }

    public Set<Project> getHiddenProjects() {
        return this.hiddenProjects;
    }

    public void setHiddenProjects(Set<Project> hiddenProjects) {
        this.hiddenProjects = hiddenProjects;
    }

    public boolean isHiddenProject(Project project) {
        if (project == null) {
            return false;
        }
        for (Project p : this.hiddenProjects) {
            if (p.getId() != project.getId()) continue;
            return true;
        }
        return false;
    }

    public UserSetting clone() {
        UserSetting setting = new UserSetting(this.getUsername());
        setting.setShowHiddenProject(this.isShowHiddenProject());
        HashSet<Project> hiddenProjects = new HashSet<Project>();
        if (this.getHiddenProjects() != null) {
            for (Project p : this.getHiddenProjects()) {
                hiddenProjects.add(p.clone(false));
            }
        }
        setting.setHiddenProjects(hiddenProjects);
        return setting;
    }
}

