/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.service;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.task.TestUtils;
import org.exoplatform.task.dao.DAOHandler;
import org.exoplatform.task.dao.LabelHandler;
import org.exoplatform.task.dao.StatusHandler;
import org.exoplatform.task.dao.TaskHandler;
import org.exoplatform.task.domain.Label;
import org.exoplatform.task.dto.LabelDto;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.service.LabelService;
import org.exoplatform.task.service.StatusService;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.service.UserService;
import org.exoplatform.task.service.impl.LabelServiceImpl;
import org.exoplatform.task.service.impl.StatusServiceImpl;
import org.exoplatform.task.service.impl.TaskServiceImpl;
import org.exoplatform.task.storage.LabelStorage;
import org.exoplatform.task.storage.ProjectStorage;
import org.exoplatform.task.storage.StatusStorage;
import org.exoplatform.task.storage.TaskStorage;
import org.exoplatform.task.storage.impl.LabelStorageImpl;
import org.exoplatform.task.storage.impl.ProjectStorageImpl;
import org.exoplatform.task.storage.impl.StatusStorageImpl;
import org.exoplatform.task.storage.impl.TaskStorageImpl;
import org.exoplatform.task.util.StorageUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class LabelServiceTest {
    StatusService statusService;
    LabelService labelService;
    TaskService taskService;
    StatusStorage statusStorage;
    TaskStorage taskStorage;
    LabelStorage labelStorage;
    ProjectStorage projectStorage;
    ListenerService listenerService;
    @Mock
    TaskHandler taskHandler;
    @Mock
    StatusHandler statusHandler;
    @Mock
    LabelHandler labelHandler;
    @Mock
    DAOHandler daoHandler;
    @Mock
    UserService userService;
    @Captor
    ArgumentCaptor<Label> labelCaptor;

    @Before
    public void setUp() {
        PortalContainer.getInstance();
        this.projectStorage = new ProjectStorageImpl(this.daoHandler);
        this.taskStorage = new TaskStorageImpl(this.daoHandler, this.userService, this.projectStorage);
        this.statusStorage = new StatusStorageImpl(this.daoHandler, this.projectStorage);
        this.statusService = new StatusServiceImpl(this.daoHandler, this.statusStorage, this.projectStorage, this.listenerService);
        this.labelStorage = new LabelStorageImpl(this.daoHandler);
        this.labelService = new LabelServiceImpl(this.labelStorage, this.daoHandler, this.projectStorage, this.listenerService);
        this.taskService = new TaskServiceImpl(this.taskStorage, this.daoHandler, this.listenerService);
        Mockito.when((Object)this.daoHandler.getLabelHandler()).thenReturn((Object)this.labelHandler);
        Mockito.when((Object)((Label)this.labelHandler.find((Serializable)Long.valueOf(TestUtils.EXISTING_LABEL_ID)))).thenReturn((Object)StorageUtil.labelToEntity((LabelDto)TestUtils.getDefaultLabel()));
    }

    @After
    public void tearDown() {
        this.labelService = null;
    }

    @Test
    public void testCreateDefaultLabelTask() {
        LabelDto label = TestUtils.getDefaultLabel();
        Mockito.when((Object)((Label)this.daoHandler.getLabelHandler().create((Object)((Label)Matchers.any())))).thenReturn((Object)StorageUtil.labelToEntity((LabelDto)label));
        this.labelService.createLabel(label);
        ((LabelHandler)Mockito.verify((Object)this.labelHandler, (VerificationMode)Mockito.times((int)1))).create((Object)((Label)this.labelCaptor.capture()));
        Label result = (Label)this.labelCaptor.getValue();
        Assert.assertEquals((Object)"TODO", (Object)result.getName());
        Assert.assertEquals((Object)"label", (Object)result.getUsername());
    }

    @Test
    public void testRemoveLabel() {
        this.labelService.removeLabel(TestUtils.EXISTING_TASK_ID);
        ((LabelHandler)Mockito.verify((Object)this.labelHandler, (VerificationMode)Mockito.times((int)1))).delete((Object)((Label)this.labelCaptor.capture()));
        Label result = (Label)this.labelCaptor.getValue();
        result.setId(TestUtils.EXISTING_LABEL_ID);
        Assert.assertEquals((long)TestUtils.EXISTING_TASK_ID, (long)result.getId());
    }

    @Test
    public void testUpdateLabelName() throws EntityNotFoundException {
        LabelDto label = this.labelService.getLabel(TestUtils.EXISTING_LABEL_ID);
        label.setId(TestUtils.EXISTING_LABEL_ID);
        label.setName("exo");
        Mockito.when((Object)((Label)this.daoHandler.getLabelHandler().update((Object)((Label)Matchers.any())))).thenReturn((Object)StorageUtil.labelToEntity((LabelDto)label));
        this.labelService.updateLabel(label, Arrays.asList(Label.FIELDS.NAME));
        ((LabelHandler)Mockito.verify((Object)this.labelHandler, (VerificationMode)Mockito.times((int)1))).update((Object)((Label)this.labelCaptor.capture()));
        Assert.assertEquals((Object)"exo", (Object)((Label)this.labelCaptor.getValue()).getName());
    }

    @Test
    public void testUpdateLabelColor() throws EntityNotFoundException {
        LabelDto label = this.labelService.getLabel(TestUtils.EXISTING_LABEL_ID);
        label.setId(TestUtils.EXISTING_LABEL_ID);
        label.setColor("white");
        Mockito.when((Object)((Label)this.daoHandler.getLabelHandler().update((Object)((Label)Matchers.any())))).thenReturn((Object)StorageUtil.labelToEntity((LabelDto)label));
        this.labelService.updateLabel(label, Arrays.asList(Label.FIELDS.COLOR));
        ((LabelHandler)Mockito.verify((Object)this.labelHandler, (VerificationMode)Mockito.times((int)1))).update((Object)((Label)this.labelCaptor.capture()));
        Assert.assertEquals((Object)"white", (Object)((Label)this.labelCaptor.getValue()).getColor());
    }

    @Test
    public void testUpdateLabelPARENT() throws EntityNotFoundException {
        LabelDto parentLabel = this.labelService.getLabel(TestUtils.EXISTING_LABEL_ID);
        LabelDto label = new LabelDto();
        long labelId = 5L;
        label.setId(labelId);
        label.setUsername("root");
        label.setName("testLabel");
        label.setParent(parentLabel);
        Mockito.when((Object)((Label)this.daoHandler.getLabelHandler().find((Serializable)Long.valueOf(labelId)))).thenReturn((Object)StorageUtil.labelToEntity((LabelDto)label));
        Mockito.when((Object)((Label)this.daoHandler.getLabelHandler().update((Object)((Label)Matchers.any())))).thenReturn((Object)StorageUtil.labelToEntity((LabelDto)label));
        this.labelService.updateLabel(label, Collections.singletonList(Label.FIELDS.PARENT));
        ((LabelHandler)Mockito.verify((Object)this.labelHandler, (VerificationMode)Mockito.times((int)1))).update((Object)((Label)this.labelCaptor.capture()));
        Assert.assertEquals((Object)label.getParent(), (Object)StorageUtil.labelToDto((Label)((Label)this.labelCaptor.getValue()).getParent()));
    }

    @Test
    public void testUpdateLabelHIDDEN() throws EntityNotFoundException {
        LabelDto label = this.labelService.getLabel(TestUtils.EXISTING_LABEL_ID);
        label.setId(TestUtils.EXISTING_LABEL_ID);
        label.setHidden(true);
        Mockito.when((Object)((Label)this.daoHandler.getLabelHandler().update((Object)((Label)Matchers.any())))).thenReturn((Object)StorageUtil.labelToEntity((LabelDto)label));
        this.labelService.updateLabel(label, Arrays.asList(Label.FIELDS.HIDDEN));
        ((LabelHandler)Mockito.verify((Object)this.labelHandler, (VerificationMode)Mockito.times((int)1))).update((Object)((Label)this.labelCaptor.capture()));
        Assert.assertEquals((Object)true, (Object)((Label)this.labelCaptor.getValue()).isHidden());
    }
}

