/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.dao;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.task.AbstractTest;
import org.exoplatform.task.dao.CommentHandler;
import org.exoplatform.task.dao.DAOHandler;
import org.exoplatform.task.dao.LabelHandler;
import org.exoplatform.task.dao.OrderBy;
import org.exoplatform.task.dao.TaskHandler;
import org.exoplatform.task.dao.TaskLogHandler;
import org.exoplatform.task.dao.TaskQuery;
import org.exoplatform.task.dao.condition.Conditions;
import org.exoplatform.task.domain.ChangeLog;
import org.exoplatform.task.domain.Label;
import org.exoplatform.task.domain.LabelTaskMapping;
import org.exoplatform.task.domain.Priority;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.service.UserService;
import org.exoplatform.task.service.impl.TaskServiceImpl;
import org.exoplatform.task.storage.ProjectStorage;
import org.exoplatform.task.storage.TaskStorage;
import org.exoplatform.task.storage.impl.TaskStorageImpl;
import org.exoplatform.task.util.ListUtil;
import org.exoplatform.task.util.TaskUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestTaskDAO
extends AbstractTest {
    private TaskHandler tDAO;
    private CommentHandler cDAO;
    private DAOHandler daoHandler;
    private final String username = "root";
    private LabelHandler labelHandler;
    private ListenerService listenerService;
    private ProjectStorage projectStorage;
    private UserService userService;
    private TaskStorage taskStorage;
    private TaskService taskService;

    @Before
    public void setup() {
        PortalContainer container = PortalContainer.getInstance();
        this.daoHandler = (DAOHandler)container.getComponentInstanceOfType(DAOHandler.class);
        this.tDAO = this.daoHandler.getTaskHandler();
        this.cDAO = this.daoHandler.getCommentHandler();
        this.labelHandler = this.daoHandler.getLabelHandler();
        this.taskStorage = new TaskStorageImpl(this.daoHandler, this.userService, this.projectStorage);
        this.taskService = new TaskServiceImpl(this.taskStorage, this.daoHandler, this.listenerService);
    }

    @After
    public void tearDown() {
        for (Task t : this.tDAO.findAll()) {
            t.setStatus(null);
        }
        this.tDAO.updateAll(this.tDAO.findAll());
        this.daoHandler.getLabelTaskMappingHandler().deleteAll();
        this.daoHandler.getTaskLogHandler().deleteAll();
        this.cDAO.deleteAll();
        this.tDAO.deleteAll();
        this.labelHandler.deleteAll();
    }

    @Test
    public void testTaskCreation() {
        Task task = new Task();
        task.setTitle("Testing task creation");
        this.tDAO.create((Object)task);
        List list = this.tDAO.findAll();
        Assert.assertEquals((long)1L, (long)list.size());
        task = new Task();
        task.setTitle("There is an important meeting tomorrow !high");
        this.tDAO.create((Object)task);
        list = this.tDAO.findAll();
        Assert.assertEquals((long)2L, (long)list.size());
        task = (Task)this.tDAO.find((Serializable)Long.valueOf(task.getId()));
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"There is an important meeting tomorrow !high", (Object)task.getTitle());
        Assert.assertEquals((Object)Priority.NORMAL, (Object)task.getPriority());
    }

    @Test
    public void testFindTaskByQuery() throws Exception {
        Task task = this.newTaskInstance("Test find task by query", "description of find task by query", "root");
        this.tDAO.create((Object)task);
        TaskQuery query = new TaskQuery();
        query.setTitle("task");
        ListAccess tasks = this.tDAO.findTasks(query);
        Assert.assertTrue((tasks.getSize() > 0 ? 1 : 0) != 0);
        query = new TaskQuery();
        query.setTitle("testFindTaskByQuery0123456789");
        tasks = this.tDAO.findTasks(query);
        Assert.assertEquals((long)0L, (long)tasks.getSize());
        Assert.assertEquals((long)0L, (long)((Task[])ListUtil.load((ListAccess)tasks, (int)0, (int)-1)).length);
        query = new TaskQuery();
        query.setDescription("description of find task by query");
        tasks = this.tDAO.findTasks(query);
        Assert.assertTrue((tasks.getSize() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((((Task[])ListUtil.load((ListAccess)tasks, (int)0, (int)-1)).length > 0 ? 1 : 0) != 0);
        query = new TaskQuery();
        query.setDescription("testFindTaskByQuery0123456789");
        tasks = this.tDAO.findTasks(query);
        Assert.assertEquals((long)0L, (long)tasks.getSize());
        Assert.assertEquals((long)0L, (long)((Task[])ListUtil.load((ListAccess)tasks, (int)0, (int)-1)).length);
        query = new TaskQuery();
        query.setAssignee(Arrays.asList("root"));
        tasks = this.tDAO.findTasks(query);
        Assert.assertTrue((tasks.getSize() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((((Task[])ListUtil.load((ListAccess)tasks, (int)0, (int)-1)).length > 0 ? 1 : 0) != 0);
        query = new TaskQuery();
        query.setAssignee(Arrays.asList("testFindTaskByQuery0123456789"));
        tasks = this.tDAO.findTasks(query);
        Assert.assertEquals((long)0L, (long)tasks.getSize());
        Assert.assertEquals((long)0L, (long)((Task[])ListUtil.load((ListAccess)tasks, (int)0, (int)-1)).length);
        query = new TaskQuery();
        query.setKeyword("find task by query");
        tasks = this.tDAO.findTasks(query);
        Assert.assertTrue((tasks.getSize() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((((Task[])ListUtil.load((ListAccess)tasks, (int)0, (int)-1)).length > 0 ? 1 : 0) != 0);
        query = new TaskQuery();
        query.setKeyword("testFindTaskByQuery0123456789");
        tasks = this.tDAO.findTasks(query);
        Assert.assertEquals((long)0L, (long)tasks.getSize());
        Assert.assertEquals((long)0L, (long)((Task[])ListUtil.load((ListAccess)tasks, (int)0, (int)-1)).length);
        query = new TaskQuery();
        query.setKeyword(" Find  QUERY");
        tasks = this.tDAO.findTasks(query);
        Assert.assertEquals((long)1L, (long)tasks.getSize());
        Assert.assertEquals((long)1L, (long)((Task[])ListUtil.load((ListAccess)tasks, (int)0, (int)-1)).length);
    }

    @Test
    public void testFindTaskOrderByDueDate() throws Exception {
        Calendar calendar = Calendar.getInstance();
        Task task = this.newTaskInstance("task 1", "description of task 1", "root");
        task.setDueDate(calendar.getTime());
        this.tDAO.create((Object)task);
        task = this.newTaskInstance("task 2", "description of task 2", "root");
        calendar.add(5, 1);
        task.setDueDate(calendar.getTime());
        this.tDAO.create((Object)task);
        task = this.newTaskInstance("task 3", "description of task 3", "root");
        calendar.add(5, -2);
        task.setDueDate(calendar.getTime());
        this.tDAO.create((Object)task);
        task = this.newTaskInstance("task 4", "description of task 4", "root");
        calendar.add(5, 3);
        task.setDueDate(calendar.getTime());
        this.tDAO.create((Object)task);
        task = this.newTaskInstance("task 5", "description of task 5", "root");
        this.tDAO.create((Object)task);
        TaskQuery taskQuery = new TaskQuery();
        taskQuery.setAssignee(Arrays.asList("root"));
        OrderBy.ASC order = new OrderBy.ASC(Conditions.TASK_DUEDATE);
        taskQuery.setOrderBy(Arrays.asList(order));
        ListAccess list = this.tDAO.findTasks(taskQuery);
        Assert.assertEquals((long)5L, (long)list.getSize());
        Task[] tasks = (Task[])list.load(0, -1);
        Assert.assertEquals((Object)"task 3", (Object)tasks[0].getTitle());
        Assert.assertEquals((Object)"task 1", (Object)tasks[1].getTitle());
        Assert.assertEquals((Object)"task 2", (Object)tasks[2].getTitle());
        Assert.assertEquals((Object)"task 4", (Object)tasks[3].getTitle());
        Assert.assertEquals((Object)"task 5", (Object)tasks[4].getTitle());
    }

    @Test
    public void testFindTaskByQueryAdvance() throws Exception {
        Project project = new Project();
        project.setName("Project1");
        project.setParticipator(new HashSet<String>(Arrays.asList("root")));
        project = (Project)this.daoHandler.getProjectHandler().create((Object)project);
        Task task = this.newTaskInstance("testTask", "task with label", "root");
        this.tDAO.create((Object)task);
        TaskQuery query = new TaskQuery();
        query.setEmptyField("lblMapping");
        ListAccess tasks = this.tDAO.findTasks(query);
        Assert.assertEquals((long)1L, (long)tasks.getSize());
        Label label = new Label("testLabel", "root", project);
        this.labelHandler.create((Object)label);
        LabelTaskMapping mapping = new LabelTaskMapping(label, task);
        this.daoHandler.getLabelTaskMappingHandler().create((Object)mapping);
        query = new TaskQuery();
        query.setLabelIds(Arrays.asList(label.getId()));
        tasks = this.tDAO.findTasks(query);
        Assert.assertEquals((long)1L, (long)tasks.getSize());
        Status status = this.newStatusInstance("TO DO", 1);
        status.setProject(project);
        status = (Status)this.daoHandler.getStatusHandler().create((Object)status);
        task.setStatus(status);
        this.tDAO.update((Object)task);
        query = new TaskQuery();
        query.setStatus(status);
        tasks = this.tDAO.findTasks(query);
        Assert.assertEquals((long)1L, (long)tasks.getSize());
        query = new TaskQuery();
        query.setAssigneeOrCoworkerOrInProject("root", Arrays.asList(-100L));
        tasks = this.tDAO.findTasks(query);
        Assert.assertEquals((long)1L, (long)tasks.getSize());
        query = new TaskQuery();
        query.setAssigneeOrCoworkerOrInProject("test", Arrays.asList(project.getId()));
        tasks = this.tDAO.findTasks(query);
        Assert.assertEquals((long)1L, (long)tasks.getSize());
        Date date = new Date();
        task.setDueDate(date);
        this.tDAO.update((Object)task);
        query = new TaskQuery();
        query.setDueDateFrom(date);
        tasks = this.tDAO.findTasks(query);
        Assert.assertEquals((long)1L, (long)tasks.getSize());
        task.setPriority(Priority.HIGH);
        this.tDAO.update((Object)task);
        query = new TaskQuery();
        query.setPriority(Priority.HIGH);
        tasks = this.tDAO.findTasks(query);
        Assert.assertEquals((long)1L, (long)tasks.getSize());
        query = new TaskQuery();
        query.setAssignee(Arrays.asList("root"));
        tasks = this.tDAO.findTasks(query);
        Assert.assertEquals((long)1L, (long)tasks.getSize());
        task.setCompleted(true);
        this.tDAO.update((Object)task);
        query = new TaskQuery();
        query.setCompleted(Boolean.valueOf(true));
        tasks = this.tDAO.findTasks(query);
        Assert.assertEquals((long)1L, (long)tasks.getSize());
    }

    @Test
    public void testFindTaskByMembership() {
        Project project = new Project();
        project.setName("Project1");
        project.setParticipator(new HashSet<String>(Arrays.asList("root")));
        project = (Project)this.daoHandler.getProjectHandler().create((Object)project);
        Status status = this.newStatusInstance("TO DO", 1);
        status.setProject(project);
        this.daoHandler.getStatusHandler().create((Object)status);
        Task task1 = this.newTaskInstance("Task 1", "", "root");
        task1.setStatus(status);
        this.tDAO.create((Object)task1);
        TaskQuery query = new TaskQuery();
        query.setMemberships(Arrays.asList("root"));
        ListAccess listTasks = this.tDAO.findTasks(query);
        Assert.assertEquals((long)1L, (long)ListUtil.getSize((ListAccess)listTasks));
        query = new TaskQuery();
        Identity user = new Identity("root");
        query.setAccessible(user);
        query.setKeyword("Task");
        listTasks = this.tDAO.findTasks(query);
        Assert.assertEquals((long)1L, (long)ListUtil.getSize((ListAccess)listTasks));
        Task task2 = this.newTaskInstance("task2", "", null);
        this.tDAO.create((Object)task2);
        Label label = new Label("label1", "root", project);
        this.labelHandler.create((Object)label);
        LabelTaskMapping mapping = new LabelTaskMapping(label, task2);
        this.daoHandler.getLabelTaskMappingHandler().create((Object)mapping);
        query = new TaskQuery();
        query.setAccessible(user);
        query.setKeyword("Task");
        listTasks = this.tDAO.findTasks(query);
        Assert.assertEquals((long)2L, (long)ListUtil.getSize((ListAccess)listTasks));
    }

    @Test
    public void testFindTasksByLabel() throws Exception {
        Project project = new Project();
        project.setName("Project1");
        this.daoHandler.getProjectHandler().create((Object)project);
        Status status = this.newStatusInstance("TO DO", 1);
        status.setProject(project);
        this.daoHandler.getStatusHandler().create((Object)status);
        Task task = this.newTaskInstance("task1", "", "root");
        task.setStatus(status);
        this.tDAO.create((Object)task);
        Label label = new Label("label1", "root", project);
        this.labelHandler.create((Object)label);
        LabelTaskMapping mapping = new LabelTaskMapping(label, task);
        this.daoHandler.getLabelTaskMappingHandler().create((Object)mapping);
        ListAccess tasks = this.tDAO.findTasksByLabel(label.getId(), Arrays.asList(project.getId()), "root", null);
        Assert.assertEquals((long)1L, (long)tasks.getSize());
        Assert.assertEquals((long)task.getId(), (long)((Task[])tasks.load(0, -1))[0].getId());
        this.daoHandler.getLabelTaskMappingHandler().delete((Object)mapping);
        tasks = this.tDAO.findTasksByLabel(label.getId(), Arrays.asList(project.getId()), "root", null);
        Assert.assertEquals((long)0L, (long)tasks.getSize());
    }

    @Test
    public void testRemoveTaskLabel() throws Exception {
        Project project = new Project();
        project.setName("project1");
        this.daoHandler.getProjectHandler().create((Object)project);
        Status status = new Status();
        status.setName("status1");
        status.setRank(Integer.valueOf(1));
        status.setProject(project);
        this.daoHandler.getStatusHandler().create((Object)status);
        Task task = this.newTaskInstance("task1", "", "root");
        task.setStatus(status);
        this.tDAO.create((Object)task);
        Label label = new Label("label1", "root", project);
        label.setProject(project);
        this.labelHandler.create((Object)label);
        LabelTaskMapping mapping = new LabelTaskMapping(label, task);
        this.daoHandler.getLabelTaskMappingHandler().create((Object)mapping);
        ListAccess labels = this.labelHandler.findLabelsByTask(task.getId(), project.getId());
        Assert.assertEquals((long)1L, (long)labels.getSize());
        this.endRequestLifecycle();
        this.initializeContainerAndStartRequestLifecycle();
        this.tDAO.delete((Object)((Task)this.tDAO.find((Serializable)Long.valueOf(task.getId()))));
        labels = this.labelHandler.findLabelsByTask(task.getId(), project.getId());
        Assert.assertEquals((long)0L, (long)labels.getSize());
    }

    @Test
    public void testGetIncomingTask() {
        Project project = new Project();
        project.setName("Project1");
        project = (Project)this.daoHandler.getProjectHandler().create((Object)project);
        Status status = this.newStatusInstance("TO DO", 1);
        status.setProject(project);
        this.daoHandler.getStatusHandler().create((Object)status);
        Task task1 = this.newTaskInstance("Task 1", "", "root");
        this.tDAO.create((Object)task1);
        Task task2 = this.newTaskInstance("Task 2", "", "root");
        task2.setStatus(status);
        this.tDAO.create((Object)task2);
        TaskQuery query = new TaskQuery();
        query.setIsIncomingOf("root");
        ListAccess listTasks = this.tDAO.findTasks(query);
        List<Task> tasks = Arrays.asList((Task[])ListUtil.load((ListAccess)listTasks, (int)0, (int)-1));
        this.assertContain(tasks, task1.getId());
        this.assertNotContain(tasks, task2.getId());
    }

    @Test
    public void testGetTodoTask() {
        Project project = new Project();
        project.setName("Project1");
        this.daoHandler.getProjectHandler().create((Object)project);
        Status status = this.newStatusInstance("TO DO", 1);
        status.setProject(project);
        this.daoHandler.getStatusHandler().create((Object)status);
        Task task1 = this.newTaskInstance("Task 1", "", null);
        this.tDAO.create((Object)task1);
        Task task2 = this.newTaskInstance("Task 2", "", null);
        task2.setStatus(status);
        this.tDAO.create((Object)task2);
        Task task3 = this.newTaskInstance("Task 3", "", "root");
        task3.setDueDate(new Date());
        this.tDAO.create((Object)task3);
        Task task4 = this.newTaskInstance("Task 4", "", "root");
        task4.setDueDate(new Date());
        task4.setStatus(status);
        this.tDAO.create((Object)task4);
        Task task5 = this.newTaskInstance("Task 5", "", "root");
        task5.setStatus(status);
        task5.setCompleted(true);
        this.tDAO.create((Object)task5);
        TaskQuery query = new TaskQuery();
        query.setIsTodoOf("root");
        query.setCompleted(Boolean.valueOf(false));
        ListAccess listTasks = this.tDAO.findTasks(query);
        List<Task> tasks = Arrays.asList((Task[])ListUtil.load((ListAccess)listTasks, (int)0, (int)-1));
        this.assertContain(tasks, task3.getId());
        this.assertContain(tasks, task4.getId());
        this.assertNotContain(tasks, task1.getId());
        this.assertNotContain(tasks, task2.getId());
        this.assertNotContain(tasks, task5.getId());
    }

    @Test
    public void testTaskLog() throws EntityNotFoundException {
        Task task = this.newTaskInstance("Task 1", "", null);
        this.tDAO.create((Object)task);
        TaskLogHandler logHandler = this.daoHandler.getTaskLogHandler();
        ListAccess logs = logHandler.findTaskLogs(Long.valueOf(task.getId()));
        Assert.assertEquals((long)0L, (long)ListUtil.getSize((ListAccess)logs));
        ChangeLog log = new ChangeLog();
        log.setTask(task);
        log.setAuthor("root");
        log.setActionName("has created task");
        logHandler.create((Object)log);
        logs = logHandler.findTaskLogs(Long.valueOf(task.getId()));
        Assert.assertEquals((long)1L, (long)ListUtil.getSize((ListAccess)logs));
    }

    @Test
    public void testTaskField() throws Exception {
        Task task = this.newTaskInstance("Task 1", "", null);
        HashSet<String> coworkers = new HashSet<String>();
        coworkers.add("worker1");
        task.setCoworker(coworkers);
        this.tDAO.create((Object)task);
        Assert.assertEquals((long)1L, (long)this.tDAO.getCoworker(task.getId()).size());
    }

    @Test
    public void testGetTaskWithCoworkers() throws Exception {
        Task task = this.newTaskInstance("Task 1", "", null);
        HashSet<String> coworkers = new HashSet<String>();
        coworkers.add("worker1");
        task.setCoworker(coworkers);
        this.tDAO.create((Object)task);
        Assert.assertEquals((long)1L, (long)this.tDAO.getTaskWithCoworkers(task.getId()).getCoworker().size());
        coworkers.add("worker2");
        coworkers.add("worker3");
        task.setCoworker(coworkers);
        Assert.assertEquals((long)3L, (long)this.tDAO.getTaskWithCoworkers(task.getId()).getCoworker().size());
        coworkers.remove("worker3");
        task.setCoworker(coworkers);
        Assert.assertEquals((long)2L, (long)this.tDAO.getTaskWithCoworkers(task.getId()).getCoworker().size());
    }

    @Test
    public void testTaskPermission() throws Exception {
        Task task = this.newTaskInstance("Task 1", "", "worker");
        Identity worker = new Identity("worker");
        Identity worker1 = new Identity("worker1");
        Identity worker2 = new Identity("worker2");
        Identity worker3 = new Identity("worker3");
        HashSet<String> coworkers = new HashSet<String>();
        coworkers.add("worker1");
        task.setCoworker(coworkers);
        task.setCreatedBy("worker3");
        this.tDAO.create((Object)task);
        ConversationState.setCurrent((ConversationState)new ConversationState(worker1));
        Assert.assertEquals((Object)true, (Object)TaskUtil.hasEditPermission((TaskService)this.taskService, (Task)task));
        ConversationState.setCurrent((ConversationState)new ConversationState(worker));
        Assert.assertEquals((Object)true, (Object)TaskUtil.hasEditPermission((TaskService)this.taskService, (Task)task));
        ConversationState.setCurrent((ConversationState)new ConversationState(worker2));
        Assert.assertEquals((Object)false, (Object)TaskUtil.hasEditPermission((TaskService)this.taskService, (Task)task));
        ConversationState.setCurrent((ConversationState)new ConversationState(worker3));
        Assert.assertEquals((Object)true, (Object)TaskUtil.hasEditPermission((TaskService)this.taskService, (Task)task));
        coworkers.add("worker2");
        task.setCoworker(coworkers);
        ConversationState.setCurrent((ConversationState)new ConversationState(worker2));
        Assert.assertEquals((Object)true, (Object)TaskUtil.hasEditPermission((TaskService)this.taskService, (Task)task));
    }

    @Test
    public void testSelectFieldInTask() throws Exception {
        Project project = new Project();
        project.setName("Project1");
        project = (Project)this.daoHandler.getProjectHandler().create((Object)project);
        Status status = this.newStatusInstance("TO DO", 1);
        status.setProject(project);
        Status status1 = this.newStatusInstance("IN Progress", 2);
        status1.setProject(project);
        this.daoHandler.getStatusHandler().create((Object)status);
        this.daoHandler.getStatusHandler().create((Object)status1);
        Task task1 = this.newTaskInstance("Task 1", "", null);
        this.tDAO.create((Object)task1);
        Task task2 = this.newTaskInstance("Task 2", "", null);
        task2.setStatus(status);
        this.tDAO.create((Object)task2);
        Task task3 = this.newTaskInstance("Task 3", "", "root");
        task3.setDueDate(new Date());
        this.tDAO.create((Object)task3);
        Task task4 = this.newTaskInstance("Task 4", "", "root");
        task4.setDueDate(new Date());
        task4.setStatus(status1);
        this.tDAO.create((Object)task4);
        Task task5 = this.newTaskInstance("Task 4", "", "root");
        task5.setStatus(status1);
        task5.setCompleted(true);
        this.tDAO.create((Object)task5);
        TaskQuery taskQuery = new TaskQuery();
        taskQuery.setProjectIds(Arrays.asList(project.getId()));
        ListAccess tasks = this.tDAO.findTasks(taskQuery);
    }

    @Test
    public void testGetUncompletedTasks() {
        Task task1 = this.newTaskInstance("Task 1", "", "root");
        task1.setCompleted(false);
        this.tDAO.create((Object)task1);
        Task task2 = this.newTaskInstance("Task 2", "", "root");
        task2.setCompleted(false);
        this.tDAO.create((Object)task2);
        Task task3 = this.newTaskInstance("Task 3", "", null);
        HashSet<String> coworker = new HashSet<String>();
        coworker.add("root");
        task3.setCoworker(coworker);
        task3.setCompleted(false);
        this.tDAO.create((Object)task3);
        Task task4 = this.newTaskInstance("Task 4", "", "root");
        task4.setCompleted(true);
        this.tDAO.create((Object)task4);
        Task task5 = this.newTaskInstance("Task 5", "", "root");
        task5.setCompleted(true);
        this.tDAO.create((Object)task5);
        Assert.assertNotNull((Object)this.tDAO.getUncompletedTasks("root", -1));
        Assert.assertEquals((String)"should be 3 uncompleted tasks", (Object)3L, (Object)this.tDAO.countUncompletedTasks("root"));
    }

    @Test
    public void testGetOverdueTasks() {
        Calendar calendar = Calendar.getInstance();
        Task task1 = this.newTaskInstance("task 1", "description of task 1", "root");
        calendar = Calendar.getInstance();
        calendar.add(5, -5);
        task1.setDueDate(calendar.getTime());
        this.tDAO.create((Object)task1);
        Task task2 = this.newTaskInstance("task 2", "description of task 2", "root");
        calendar = Calendar.getInstance();
        calendar.add(5, 2);
        task2.setDueDate(calendar.getTime());
        this.tDAO.create((Object)task2);
        Task task5 = this.newTaskInstance("task 5", "description of task 5", null);
        HashSet<String> coworker = new HashSet<String>();
        coworker.add("root");
        task5.setCoworker(coworker);
        calendar = Calendar.getInstance();
        calendar.add(5, -2);
        task5.setDueDate(calendar.getTime());
        this.tDAO.create((Object)task5);
        Assert.assertNotNull((Object)this.tDAO.getOverdueTasks("root", -1));
        Assert.assertEquals((String)"should be 2 overdue tasks", (Object)2L, (Object)this.tDAO.countOverdueTasks("root"));
    }

    @Test
    public void testAddWatchersToTasks() throws Exception {
        String user = "john";
        Task task = this.newTaskInstance("task ", "description of task ", "root");
        this.tDAO.create((Object)task);
        Set watchers = new HashSet();
        this.tDAO.addWatcherToTask(user, task);
        watchers = this.tDAO.getWatchersOfTask(task);
        Assert.assertEquals((long)1L, (long)watchers.size());
        Assert.assertTrue((boolean)watchers.contains(user));
    }

    @Test
    public void testDeleteWatchersToTasks() throws Exception {
        String user = "john";
        Task task = this.newTaskInstance("task ", "description of task", "root");
        this.tDAO.create((Object)task);
        this.tDAO.addWatcherToTask(user, task);
        Set watchers = this.tDAO.getWatchersOfTask(task);
        Assert.assertEquals((long)1L, (long)watchers.size());
        this.tDAO.deleteWatcherOfTask(user, task);
        watchers = this.tDAO.getWatchersOfTask(task);
        Assert.assertEquals((long)0L, (long)watchers.size());
    }

    @Test
    public void testGetWatchersOfTask() throws Exception {
        Task task = this.newTaskInstance("Task ", "", null);
        HashSet watchers = new HashSet();
        task = (Task)this.tDAO.create((Object)task);
        this.tDAO.addWatcherToTask("john", task);
        this.tDAO.addWatcherToTask("marry", task);
        Assert.assertEquals((long)2L, (long)this.tDAO.getWatchersOfTask(task).size());
        Assert.assertTrue((boolean)this.tDAO.getWatchersOfTask(task).contains("marry"));
        this.tDAO.deleteWatcherOfTask("marry", task);
        this.tDAO.update((Object)task);
        Assert.assertEquals((long)1L, (long)this.tDAO.getWatchersOfTask(task).size());
        Assert.assertFalse((boolean)this.tDAO.getWatchersOfTask(task).contains("marry"));
    }

    @Test
    public void testFindTasks() throws Exception {
        String user = "john";
        List<String> memberships = Arrays.asList("manager:/spaces/space1", "member:/spaces/space1");
        Task task = this.newTaskInstance("What is Lorem Ipsum?", "Lorem Ipsum is simply dummy text of the printing", user);
        this.tDAO.create((Object)task);
        ConversationState.setCurrent((ConversationState)new ConversationState(new Identity(user)));
        List tasks = this.tDAO.findTasks(user, memberships, "Lorem", 10);
        Assert.assertEquals((long)1L, (long)tasks.size());
        tasks = this.tDAO.findTasks(user, memberships, "lorem", 10);
        Assert.assertEquals((long)1L, (long)tasks.size());
        tasks = this.tDAO.findTasks(user, memberships, "simply", 10);
        Assert.assertEquals((long)1L, (long)tasks.size());
        tasks = this.tDAO.findTasks("root", memberships, "simply", 10);
        Assert.assertEquals((long)1L, (long)tasks.size());
        tasks = this.tDAO.findTasks("mary", memberships, "simply", 10);
        Assert.assertEquals((long)0L, (long)tasks.size());
        tasks = this.tDAO.findTasks(user, memberships, "example", 10);
        Assert.assertEquals((long)0L, (long)tasks.size());
    }

    @Test
    public void testCountTasks() throws Exception {
        String user = "john";
        Task task = this.newTaskInstance("What is Lorem Ipsum?", "Lorem Ipsum is simply dummy text of the printing", user);
        this.tDAO.create((Object)task);
        Assert.assertEquals((long)1L, (long)this.tDAO.countTasks(user, "Lorem"));
        Assert.assertEquals((long)1L, (long)this.tDAO.countTasks(user, "lorem"));
        Assert.assertEquals((long)1L, (long)this.tDAO.countTasks(user, "simply"));
        Assert.assertEquals((long)1L, (long)this.tDAO.countTasks("root", "simply"));
        Assert.assertEquals((long)0L, (long)this.tDAO.countTasks("mary", "simply"));
        Assert.assertEquals((long)0L, (long)this.tDAO.countTasks(user, "example"));
    }

    private Task newTaskInstance(String taskTitle, String description, String assignee) {
        Task task = new Task();
        task.setTitle(taskTitle);
        task.setDescription(description);
        task.setAssignee(assignee);
        task.setCreatedBy("root");
        task.setCreatedTime(new Date());
        return task;
    }

    private Status newStatusInstance(String name, int rank) {
        Status status = new Status();
        status.setName(name);
        status.setRank(Integer.valueOf(rank));
        return status;
    }

    private void assertContain(List<Task> tasks, Long taskId) {
        for (Task t : tasks) {
            if (t.getId() != taskId.longValue()) continue;
            return;
        }
        Assert.fail((String)("Task with ID " + taskId + " should exist on the list"));
    }

    private void assertNotContain(List<Task> tasks, Long taskId) {
        for (Task t : tasks) {
            if (t.getId() != taskId.longValue()) continue;
            Assert.fail((String)("Task with ID " + taskId + " should not exist on the list"));
        }
    }
}

