/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.management.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.inject.Inject;
import juzu.MimeType;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.impl.common.Tools;
import juzu.request.SecurityContext;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.UserSetting;
import org.exoplatform.task.exception.AbstractEntityException;
import org.exoplatform.task.exception.ProjectNotFoundException;
import org.exoplatform.task.management.templates.confirmDeleteProject;
import org.exoplatform.task.management.templates.groupSelectorDialog;
import org.exoplatform.task.management.templates.listProjects;
import org.exoplatform.task.management.templates.permissionSuggest;
import org.exoplatform.task.management.templates.projectDetail;
import org.exoplatform.task.management.templates.projectForm;
import org.exoplatform.task.management.templates.projectSearchResult;
import org.exoplatform.task.management.templates.shareDialog;
import org.exoplatform.task.management.templates.userSelectorDialog;
import org.exoplatform.task.model.Permission;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.UserService;
import org.exoplatform.task.utils.ProjectUtil;
import org.exoplatform.task.utils.UserUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ProjectController {
    @Inject
    ResourceBundle bundle;
    @Inject
    ProjectService projectService;
    @Inject
    UserService userService;
    @Inject
    OrganizationService orgService;
    @Inject
    @Path(value="projectForm.gtmpl")
    projectForm form;
    @Inject
    @Path(value="projectDetail.gtmpl")
    projectDetail detail;
    @Inject
    @Path(value="listProjects.gtmpl")
    listProjects listProjects;
    @Inject
    @Path(value="shareDialog.gtmpl")
    shareDialog shareDialog;
    @Inject
    @Path(value="confirmDeleteProject.gtmpl")
    confirmDeleteProject confirmDeleteProject;
    @Inject
    @Path(value="userSelectorDialog.gtmpl")
    userSelectorDialog userSelectorDialog;
    @Inject
    @Path(value="groupSelectorDialog.gtmpl")
    groupSelectorDialog groupSelectorDialog;
    @Inject
    @Path(value="projectSearchResult.gtmpl")
    projectSearchResult projectSearchResult;
    @Inject
    @Path(value="permissionSuggest.gtmpl")
    permissionSuggest permissionSuggest;
    private static final Log LOG = ExoLogger.getExoLogger(ProjectController.class);

    @Resource
    @Ajax
    @MimeType.HTML
    public Response projectForm(Long parentId, SecurityContext securityContext) {
        Project parent;
        try {
            parent = this.projectService.getProjectById(parentId);
        }
        catch (ProjectNotFoundException e) {
            parent = new Project();
        }
        org.exoplatform.task.model.User user = this.userService.loadUser(securityContext.getRemoteUser());
        return this.form.with().breadcumbs((Object)ProjectUtil.buildBreadcumbs((Long)parent.getId(), (ProjectService)this.projectService, (ResourceBundle)this.bundle)).parent((Object)parent).user((Object)user).ok().withCharset(Tools.UTF_8);
    }

    @Resource
    @Ajax
    @MimeType.JSON
    public Response createProject(String space_group_id, String name, String description, Long parentId, SecurityContext securityContext) {
        String currentUser = securityContext.getRemoteUser();
        if (currentUser == null) {
            return Response.status((int)401).body((CharSequence)"You must login to create new project");
        }
        if (name == null || name.isEmpty()) {
            return Response.status((int)412).body((CharSequence)"Name of project is required");
        }
        try {
            Project project;
            if (space_group_id != null) {
                List memberships = UserUtils.getSpaceMemberships((String)space_group_id);
                HashSet<String> managers = new HashSet<String>(Arrays.asList(currentUser, (String)memberships.get(0)));
                HashSet<String> participators = new HashSet<String>(Arrays.asList((String)memberships.get(1)));
                project = this.projectService.createDefaultStatusProjectWithAttributes(parentId, name, description, managers, participators);
            } else {
                project = this.projectService.createDefaultStatusProjectWithManager(name, description, parentId, currentUser);
            }
            JSONObject result = new JSONObject();
            result.put("id", project.getId());
            result.put("name", (Object)project.getName());
            result.put("color", (Object)"transparent");
            return Response.ok((CharSequence)result.toString()).withCharset(Tools.UTF_8);
        }
        catch (AbstractEntityException e) {
            return Response.status((int)e.getHttpStatusCode()).body((CharSequence)e.getMessage());
        }
        catch (JSONException ex) {
            return Response.status((int)500).body((CharSequence)ex.getMessage());
        }
    }

    @Resource
    @Ajax
    @MimeType.JSON
    public Response cloneProject(Long id, String cloneTask, SecurityContext securityContext) {
        try {
            Project project = this.projectService.cloneProjectById(id.longValue(), Boolean.parseBoolean(cloneTask));
            JSONObject result = new JSONObject();
            result.put("id", project.getId());
            result.put("name", (Object)project.getName());
            result.put("color", (Object)project.getColor());
            return Response.ok((CharSequence)result.toString()).withCharset(Tools.UTF_8);
        }
        catch (AbstractEntityException e) {
            return Response.status((int)e.getHttpStatusCode()).body((CharSequence)e.getMessage());
        }
        catch (JSONException ex) {
            return Response.status((int)500).body((CharSequence)ex.getMessage());
        }
    }

    @Resource
    @Ajax
    @MimeType.HTML
    public Response openConfirmDelete(Long id) {
        try {
            Project project = this.projectService.getProjectById(id);
            if (project != null) {
                String msg = this.bundle.getString("popup.msg.deleteProject");
                msg = msg.replace("{}", project.getName());
                return this.confirmDeleteProject.with().pid((Object)project.getId()).msg((Object)msg).ok().withCharset(Tools.UTF_8);
            }
            return Response.status((int)404);
        }
        catch (AbstractEntityException e) {
            return Response.status((int)e.getHttpStatusCode()).body((CharSequence)e.getMessage());
        }
    }

    @Resource
    @Ajax
    @MimeType.HTML
    public Response openShareDialog(Long id) {
        try {
            Project project = this.projectService.getProjectById(id);
            return this.renderShareDialog(project, "");
        }
        catch (AbstractEntityException e) {
            return Response.status((int)e.getHttpStatusCode()).body((CharSequence)e.getMessage());
        }
    }

    @Resource
    @Ajax
    @MimeType.HTML
    public Response removePermission(Long id, String permission, String type) {
        try {
            Project project = this.projectService.removePermissionFromProjectId(id, permission, type);
            return this.renderShareDialog(project, type);
        }
        catch (AbstractEntityException e) {
            return Response.status((int)e.getHttpStatusCode()).body((CharSequence)e.getMessage());
        }
    }

    @Resource
    @Ajax
    @MimeType.HTML
    public Response openUserSelector(Long id, String type, String groupId, String keyword, String filter) {
        try {
            ListAccess users;
            Project project = this.projectService.getProjectById(id);
            UserHandler uHandler = this.orgService.getUserHandler();
            List<User> tmp = null;
            if (keyword != null && !keyword.isEmpty()) {
                String searchKeyword = keyword;
                if (searchKeyword.indexOf("*") < 0) {
                    if (searchKeyword.charAt(0) != '*') {
                        searchKeyword = "*" + searchKeyword;
                    }
                    if (searchKeyword.charAt(searchKeyword.length() - 1) != '*') {
                        searchKeyword = searchKeyword + "*";
                    }
                }
                searchKeyword = searchKeyword.replace('?', '_');
                Query q = new Query();
                if ("userName".equals(filter)) {
                    q.setUserName(searchKeyword);
                }
                if ("lastName".equals(filter)) {
                    q.setLastName(searchKeyword);
                }
                if ("firstName".equals(filter)) {
                    q.setFirstName(searchKeyword);
                }
                if ("email".equals(filter)) {
                    q.setEmail(searchKeyword);
                }
                ListAccess users2 = uHandler.findUsersByQuery(q);
                tmp = new ArrayList();
                for (User u : (User[])users2.load(0, users2.getSize())) {
                    tmp.add(u);
                }
            }
            if (groupId != null && !groupId.isEmpty()) {
                if (tmp == null) {
                    users = uHandler.findUsersByGroupId(groupId);
                    tmp = new ArrayList();
                    for (User u : (User[])users.load(0, users.getSize())) {
                        tmp.add(u);
                    }
                } else {
                    MembershipHandler memberShipHandler = this.orgService.getMembershipHandler();
                    CopyOnWriteArrayList results = new CopyOnWriteArrayList();
                    results.addAll(tmp);
                    for (User u : tmp) {
                        if (memberShipHandler.findMembershipsByUserAndGroup(u.getUserName(), groupId).size() != 0) continue;
                        results.remove(u);
                    }
                    tmp = results;
                }
            }
            if (tmp == null) {
                users = uHandler.findAllUsers();
                tmp = new ArrayList();
                for (User u : (User[])users.load(0, users.getSize())) {
                    tmp.add(u);
                }
            }
            HashSet<org.exoplatform.task.model.User> allUsers = new HashSet<org.exoplatform.task.model.User>();
            if (tmp != null) {
                for (User u : tmp) {
                    org.exoplatform.task.model.User user = this.userService.loadUser(u.getUserName());
                    allUsers.add(user);
                }
            }
            allUsers.removeAll("manager".equals(type) ? project.getManager() : project.getParticipator());
            return this.userSelectorDialog.with().type((Object)type).users(allUsers).groupId((Object)(groupId == null ? "" : groupId)).keyword((Object)(keyword == null ? "" : keyword)).filter((Object)(filter == null ? "" : filter)).ok();
        }
        catch (AbstractEntityException e) {
            return Response.status((int)e.getHttpStatusCode()).body((CharSequence)e.getMessage());
        }
        catch (Exception ex) {
            return Response.status((int)500).body((CharSequence)ex.getMessage());
        }
    }

    @Resource
    @Ajax
    @MimeType.HTML
    public Response openGroupSelector(String type, Boolean onlyGroup) {
        Collection msTypes;
        Collection groups;
        try {
            groups = this.orgService.getGroupHandler().getAllGroups();
            msTypes = this.orgService.getMembershipTypeHandler().findMembershipTypes();
        }
        catch (Exception e) {
            return Response.status((int)503).body((CharSequence)e.getMessage());
        }
        List allGroups = new ArrayList();
        if (groups != null) {
            allGroups = UserUtils.buildGroupTree((Collection)groups);
        }
        ArrayList<String> allMSTypes = new ArrayList<String>();
        if (msTypes != null) {
            for (Object mst : msTypes) {
                allMSTypes.add(((MembershipType)mst).getName());
            }
        }
        if (onlyGroup == null) {
            onlyGroup = Boolean.FALSE;
        }
        return this.groupSelectorDialog.with().type((Object)type).groups(allGroups).membershipTypes(allMSTypes).groupOnly((Object)onlyGroup).ok();
    }

    @Resource
    @Ajax
    @MimeType.HTML
    public Response findPermission(String keyword) {
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        try {
            String userKeyword = "*" + keyword + "*";
            Query query = new Query();
            query.setUserName(userKeyword);
            ListAccess users = this.orgService.getUserHandler().findUsersByQuery(query);
            for (User u : (User[])users.load(0, users.getSize())) {
                permissions.add(Permission.parse((String)u.getUserName(), (OrganizationService)this.orgService));
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)ex);
        }
        try {
            for (Group g : this.orgService.getGroupHandler().getAllGroups()) {
                if (!g.getLabel().contains(keyword)) continue;
                String perm = "*:" + g.getId();
                permissions.add(Permission.parse((String)perm, (OrganizationService)this.orgService));
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)ex);
        }
        return this.permissionSuggest.with().keyword((Object)keyword).permissions(permissions).ok().withCharset(Tools.UTF_8);
    }

    @Resource
    @Ajax
    @MimeType.HTML
    public Response savePermission(Long id, String[] permissions, String type) {
        try {
            String name = "manager".equals(type) ? type : "participator";
            Project project = this.projectService.updateProjectInfo(id.longValue(), name, permissions);
            return this.renderShareDialog(project, "");
        }
        catch (AbstractEntityException e) {
            return Response.status((int)e.getHttpStatusCode()).body((CharSequence)e.getMessage());
        }
    }

    @Resource
    @Ajax
    @MimeType.HTML
    public Response projectTree(String space_group_id, SecurityContext securityContext) {
        List projects = ProjectUtil.getProjectTree((String)space_group_id, (ProjectService)this.projectService);
        UserSetting setting = this.userService.getUserSetting(securityContext.getRemoteUser());
        return this.listProjects.with().userSetting((Object)setting).projects((Object)projects).ok().withCharset(Tools.UTF_8);
    }

    @Resource
    @Ajax
    @MimeType.JSON
    public Response projectTreeAsJSON(String space_group_id) throws JSONException {
        List projects = ProjectUtil.getProjectTree((String)space_group_id, (ProjectService)this.projectService);
        Project root = new Project();
        root.setName(this.bundle.getString("label.projects"));
        projects.add(0, root);
        JSONArray array = new JSONArray();
        this.buildJSON(array, projects);
        return Response.ok((CharSequence)array.toString()).withCharset(Tools.UTF_8);
    }

    @Resource
    @Ajax
    @MimeType.HTML
    public Response getBreadCumbs(Long id) {
        String breadcumbs = ProjectUtil.buildBreadcumbs((Long)id, (ProjectService)this.projectService, (ResourceBundle)this.bundle);
        return Response.ok((CharSequence)breadcumbs.toString()).withCharset(Tools.UTF_8);
    }

    private JSONArray buildJSON(JSONArray array, List<Project> projects) throws JSONException {
        for (Project p : projects) {
            JSONObject json = new JSONObject();
            json.put("id", p.getId());
            json.put("text", (Object)p.getName());
            array.put((Object)json);
            if (p.getChildren() == null) continue;
            this.buildJSON(array, p.getChildren());
        }
        return array;
    }

    @Resource
    @Ajax
    @MimeType.HTML
    public Response projectDetail(Long id) {
        try {
            Project parent;
            Project project = this.projectService.getProjectById(id);
            LinkedList<String> groups = new LinkedList<String>();
            HashMap<String, org.exoplatform.task.model.User> users = new HashMap<String, org.exoplatform.task.model.User>();
            if (project.getManager() != null && !project.getManager().isEmpty()) {
                for (String man : project.getManager()) {
                    Permission per = Permission.parse((String)man, (OrganizationService)this.orgService);
                    if (per.getType() == 1) {
                        org.exoplatform.task.model.User user = this.userService.loadUser(man);
                        users.put(man, user);
                        continue;
                    }
                    groups.add(per.getDisplayName());
                }
            }
            if ((parent = project.getParent()) == null) {
                parent = new Project();
            }
            return this.detail.with().breadcumbs((Object)ProjectUtil.buildBreadcumbs((Long)parent.getId(), (ProjectService)this.projectService, (ResourceBundle)this.bundle)).parent((Object)parent).project((Object)project).userMap(users).groups(groups).ok().withCharset(Tools.UTF_8);
        }
        catch (AbstractEntityException e) {
            return Response.status((int)e.getHttpStatusCode()).body((CharSequence)e.getMessage());
        }
    }

    @Resource
    @Ajax
    @MimeType(value={"text/plain"})
    public Response saveProjectInfo(Long projectId, String name, String[] value) {
        if (name == null) {
            return Response.status((int)406).body((CharSequence)"Field name is required");
        }
        try {
            this.projectService.updateProjectInfo(projectId.longValue(), name, value);
            return Response.ok((CharSequence)"Update successfully");
        }
        catch (AbstractEntityException e) {
            return Response.status((int)e.getHttpStatusCode()).body((CharSequence)e.getMessage());
        }
    }

    @Resource
    @Ajax
    @MimeType(value={"text/plain"})
    public Response deleteProject(Long projectId, Boolean deleteChild) {
        try {
            this.projectService.deleteProjectById(projectId.longValue(), deleteChild.booleanValue());
            return Response.ok((CharSequence)"Delete project successfully");
        }
        catch (AbstractEntityException e) {
            return Response.status((int)e.getHttpStatusCode()).body((CharSequence)e.getMessage());
        }
    }

    @Resource
    @Ajax
    @MimeType.HTML
    public Response findProject(String keyword, Long currentProject) {
        Identity identity = ConversationState.getCurrent().getIdentity();
        List projects = this.projectService.findProjectByKeyWord(identity, keyword);
        projects = ProjectUtil.buildRootProjects((List)projects);
        return this.projectSearchResult.with().keyword((Object)keyword).projects((Object)projects).currentProjectId((Object)currentProject).ok();
    }

    private Response renderShareDialog(Project project, String editingField) {
        Permission p;
        ArrayList<Permission> managers = new ArrayList<Permission>();
        ArrayList<Permission> participants = new ArrayList<Permission>();
        if (project.getManager() != null && project.getManager().size() > 0) {
            for (String permission : project.getManager()) {
                p = Permission.parse((String)permission, (OrganizationService)this.orgService);
                if (p == null) continue;
                managers.add(p);
            }
        }
        if (project.getParticipator() != null && project.getParticipator().size() > 0) {
            for (String permission : project.getParticipator()) {
                p = Permission.parse((String)permission, (OrganizationService)this.orgService);
                if (p == null) continue;
                participants.add(p);
            }
        }
        ArrayList<String> msTypes = new ArrayList<String>();
        try {
            Collection membershipTypes = this.orgService.getMembershipTypeHandler().findMembershipTypes();
            for (MembershipType type : membershipTypes) {
                msTypes.add(type.getName());
            }
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
        }
        return this.shareDialog.with().pid((Object)project.getId()).participants(participants).managers(managers).msTypes(msTypes).editingField((Object)(editingField == null ? "" : editingField)).ok().withCharset(Tools.UTF_8);
    }
}

