/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.management.controller;

import java.util.Collections;
import java.util.LinkedList;
import javax.inject.Inject;
import juzu.MimeType;
import juzu.Resource;
import juzu.Response;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.exception.AbstractEntityException;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.StatusService;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class StatusController {
    private static final Log LOG = ExoLogger.getExoLogger(StatusController.class);
    @Inject
    ProjectService projectService;
    @Inject
    StatusService statusService;

    @Resource
    @Ajax
    @MimeType.JSON
    public Response getAllStatus(Long projectId) {
        try {
            Project project = this.projectService.getProjectById(projectId);
            JSONArray array = new JSONArray();
            LinkedList statuses = new LinkedList(project.getStatus());
            Collections.sort(statuses);
            for (Status status : statuses) {
                JSONObject json = new JSONObject();
                json.put("value", status.getId());
                json.put("text", (Object)status.getName());
                array.put((Object)json);
            }
            return Response.ok((CharSequence)array.toString());
        }
        catch (AbstractEntityException e) {
            LOG.warn((Object)("Impossible to retrieve status for Project " + projectId), (Throwable)e);
            return Response.status((int)e.getHttpStatusCode()).body((CharSequence)e.getMessage());
        }
        catch (JSONException ex) {
            LOG.warn((Object)"JSONException while create reporting", (Throwable)ex);
            return Response.status((int)500).body((CharSequence)"JSONException while create reporting");
        }
    }

    @Resource
    @Ajax
    @MimeType.JSON
    public Response updateStatus(Long id, String name) {
        try {
            Status status = this.statusService.updateStatus(id.longValue(), name);
            JSONObject json = new JSONObject();
            json.put("id", status.getId());
            json.put("name", (Object)status.getName());
            json.put("rank", (Object)status.getRank());
            return Response.ok((CharSequence)json.toString());
        }
        catch (AbstractEntityException e) {
            return Response.status((int)e.getHttpStatusCode()).body((CharSequence)e.getMessage());
        }
        catch (JSONException e) {
            return Response.status((int)500).body((CharSequence)e.getMessage());
        }
    }
}

