/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.management.controller;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.inject.Inject;
import juzu.Action;
import juzu.Path;
import juzu.Response;
import juzu.View;
import juzu.impl.common.Tools;
import juzu.request.SecurityContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.RequestNavigationData;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.task.dao.OrderBy;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.UserSetting;
import org.exoplatform.task.exception.ProjectNotFoundException;
import org.exoplatform.task.exception.TaskNotFoundException;
import org.exoplatform.task.management.controller.NavigationState;
import org.exoplatform.task.management.controller.ProjectController;
import org.exoplatform.task.management.controller.TaskManagement_;
import org.exoplatform.task.management.templates.index;
import org.exoplatform.task.model.TaskModel;
import org.exoplatform.task.service.ParserContext;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.TaskParser;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.service.UserService;
import org.exoplatform.task.utils.ProjectUtil;
import org.exoplatform.task.utils.TaskUtil;

public class TaskManagement {
    private static final Log LOG = ExoLogger.getExoLogger(TaskManagement.class);
    @Inject
    TaskService taskService;
    @Inject
    TaskParser taskParser;
    @Inject
    UserService userService;
    @Inject
    OrganizationService orgService;
    @Inject
    ProjectService projectService;
    @Inject
    @Path(value="index.gtmpl")
    index index;
    @Inject
    ResourceBundle bundle;
    @Inject
    ProjectController projectController;
    @Inject
    NavigationState navState;

    @View
    public Response.Content index(String space_group_id, SecurityContext securityContext) throws ProjectNotFoundException {
        long id;
        long currProject;
        String username = securityContext.getRemoteUser();
        PortalRequestContext prc = Util.getPortalRequestContext();
        String requestPath = prc.getControllerContext().getParameter(RequestNavigationData.REQUEST_PATH);
        TaskModel taskModel = null;
        List tasks = null;
        Project project = null;
        long l = currProject = space_group_id == null ? -1L : -2L;
        if (space_group_id == null) {
            long id2 = ProjectUtil.getProjectIdFromURI((String)requestPath);
            if (id2 > 0L && prc.getControllerContext().getRequest().getQueryString() == null) {
                currProject = id2;
                project = this.projectService.getProjectById(Long.valueOf(currProject));
            } else {
                currProject = -1L;
            }
        } else {
            currProject = -2L;
        }
        long taskId = this.navState.getTaskId();
        if (taskId <= 0L && (id = TaskUtil.getTaskIdFromURI((String)requestPath)) > 0L) {
            taskId = id;
        }
        if (taskId != -1L) {
            try {
                taskModel = TaskUtil.getTaskModel((Long)taskId, (boolean)false, (ResourceBundle)this.bundle, (String)username, (TaskService)this.taskService, (OrganizationService)this.orgService, (UserService)this.userService, (ProjectService)this.projectService);
                if (taskModel.getTask().getStatus() != null) {
                    project = taskModel.getTask().getStatus().getProject();
                    currProject = project.getId();
                    tasks = this.projectService.getTasksByProjectId(Arrays.asList(currProject), null);
                }
            }
            catch (TaskNotFoundException e) {
                taskId = -1L;
            }
        }
        LinkedList<Long> spaceProjectIds = null;
        List projects = ProjectUtil.getProjectTree((String)space_group_id, (ProjectService)this.projectService);
        if (space_group_id != null) {
            spaceProjectIds = new LinkedList<Long>();
            for (Project p : projects) {
                spaceProjectIds.add(p.getId());
            }
        }
        if (tasks == null) {
            tasks = space_group_id != null ? this.taskService.getToDoTasksByUser(username, spaceProjectIds, null, null, null) : (currProject > 0L ? this.projectService.getTasksByProjectId(Arrays.asList(currProject), null) : this.taskService.getIncomingTasksByUser(username, (OrderBy)new OrderBy.DESC("createdTime")));
        }
        HashMap<String, List> groupTasks = new HashMap<String, List>();
        groupTasks.put("", tasks);
        UserSetting setting = this.userService.getUserSetting(username);
        long taskNum = TaskUtil.getTaskNum((String)username, spaceProjectIds, (Long)currProject, (TaskService)this.taskService);
        Map defOrders = TaskUtil.getDefOrders((ResourceBundle)this.bundle);
        Map defGroupBys = TaskUtil.getDefGroupBys((long)currProject, (ResourceBundle)this.bundle);
        return this.index.with().currentProjectId((Object)currProject).taskId((Object)taskId).taskModel((Object)taskModel).orders((Object)defOrders).groups((Object)defGroupBys).project((Object)project).tasks((Object)tasks).taskNum((Object)taskNum).groupTasks(groupTasks).keyword((Object)"").groupBy((Object)"none").orderBy((Object)"createdTime").filter((Object)"").projects((Object)projects).userSetting((Object)setting).userTimezone((Object)this.userService.getUserTimezone(username)).bundle((Object)this.bundle).isInSpace((Object)(space_group_id != null ? 1 : 0)).viewType((Object)"").ok().withCharset(Tools.UTF_8);
    }

    @Action
    public Response permalink(String space_group_id, Long taskId) {
        this.navState.setTaskId(taskId);
        return TaskManagement_.index((String)space_group_id);
    }

    @Action
    public Response changeViewState(String space_group_id, String groupBy, String orderBy) {
        return TaskManagement_.index((String)space_group_id);
    }

    @Action
    public Response createTask(String space_group_id, String taskInput, String groupBy, String orderBy, SecurityContext securityContext) {
        if (taskInput != null && !taskInput.isEmpty()) {
            String currentUser = securityContext.getRemoteUser();
            ParserContext context = new ParserContext(this.userService.getUserTimezone(currentUser));
            this.taskService.createTask(this.taskParser.parse(taskInput, context));
        }
        return TaskManagement_.index((String)space_group_id);
    }
}

