/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.management.controller;

import javax.inject.Inject;
import juzu.MimeType;
import juzu.Resource;
import juzu.Response;
import juzu.impl.common.Tools;
import juzu.request.SecurityContext;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.task.exception.NotAllowedOperationOnEntityException;
import org.exoplatform.task.exception.ProjectNotFoundException;
import org.exoplatform.task.service.UserService;
import org.exoplatform.task.utils.UserUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UserController {
    @Inject
    OrganizationService orgService;
    @Inject
    private UserService userService;

    @Resource
    @Ajax
    @MimeType.JSON
    public Response findUser(String query) {
        try {
            UserHandler uHandler = this.orgService.getUserHandler();
            Query uQuery = new Query();
            uQuery.setUserName("*" + query + "*");
            ListAccess users = uHandler.findUsersByQuery(uQuery);
            JSONArray array = new JSONArray();
            for (User u : (User[])users.load(0, users.getSize())) {
                org.exoplatform.task.model.User user = this.userService.loadUser(u.getUserName());
                JSONObject json = new JSONObject();
                json.put("id", (Object)u.getUserName());
                String displayName = UserUtils.getDisplayName((User)u);
                json.put("text", (Object)displayName);
                json.put("avatar", (Object)user.getAvatar());
                array.put((Object)json);
            }
            return Response.ok((CharSequence)array.toString());
        }
        catch (JSONException ex) {
            return Response.error((Throwable)ex);
        }
        catch (Exception ex) {
            return Response.error((Throwable)ex);
        }
    }

    @Resource
    @Ajax
    @MimeType.JSON
    public Response findUsersToMention(String query) {
        try {
            UserHandler uHandler = this.orgService.getUserHandler();
            Query uQuery = new Query();
            uQuery.setUserName("*" + query + "*");
            ListAccess users = uHandler.findUsersByQuery(uQuery);
            JSONArray array = new JSONArray();
            for (User u : (User[])users.load(0, users.getSize())) {
                JSONObject json = new JSONObject();
                org.exoplatform.task.model.User user = this.userService.loadUser(u.getUserName());
                json.put("id", (Object)("@" + u.getUserName()));
                json.put("name", (Object)user.getDisplayName());
                json.put("avatar", (Object)user.getAvatar());
                json.put("type", (Object)"contact");
                array.put((Object)json);
            }
            return Response.ok((CharSequence)array.toString());
        }
        catch (JSONException ex) {
            return Response.error((Throwable)ex);
        }
        catch (Exception ex) {
            return Response.error((Throwable)ex);
        }
    }

    @Resource
    @Ajax
    @MimeType.JSON
    public Response getDisplayNameOfUser(String usernames) {
        if (usernames != null) {
            try {
                JSONArray array = new JSONArray();
                for (String username : usernames.split(",")) {
                    org.exoplatform.task.model.User user = this.userService.loadUser(username);
                    JSONObject json = new JSONObject();
                    json.put("id", (Object)user.getUsername());
                    json.put("text", (Object)user.getDisplayName());
                    json.put("avatar", (Object)user.getAvatar());
                    array.put((Object)json);
                }
                return Response.ok((CharSequence)array.toString()).withCharset(Tools.UTF_8);
            }
            catch (JSONException ex) {
                return Response.status((int)500);
            }
            catch (Exception ex) {
                return Response.status((int)500);
            }
        }
        return Response.ok((CharSequence)"[]");
    }

    @Resource
    @Ajax
    @MimeType(value={"text/plain"})
    public Response showHiddenProject(Boolean show, SecurityContext securityContext) {
        this.userService.showHiddenProject(securityContext.getRemoteUser(), show.booleanValue());
        return Response.ok((CharSequence)"Update successfully");
    }

    @Resource
    @Ajax
    @MimeType(value={"text/plain"})
    public Response hideProject(Long projectId, Boolean hide) {
        try {
            Identity identity = ConversationState.getCurrent().getIdentity();
            this.userService.hideProject(identity, projectId, hide.booleanValue());
            return Response.ok((CharSequence)"Hide project successfully");
        }
        catch (ProjectNotFoundException ex) {
            return Response.notFound((CharSequence)ex.getMessage());
        }
        catch (NotAllowedOperationOnEntityException ex) {
            return Response.status((int)403).body((CharSequence)ex.getMessage());
        }
    }
}

