/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.management.controller;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.inject.Inject;
import juzu.Action;
import juzu.Path;
import juzu.Response;
import juzu.View;
import juzu.impl.common.Tools;
import juzu.request.SecurityContext;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.RequestNavigationData;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.task.dao.TaskQuery;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.domain.UserSetting;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.management.controller.NavigationState;
import org.exoplatform.task.management.controller.ProjectController;
import org.exoplatform.task.management.controller.TaskManagement_;
import org.exoplatform.task.management.model.Paging;
import org.exoplatform.task.management.templates.index;
import org.exoplatform.task.model.GroupKey;
import org.exoplatform.task.model.TaskModel;
import org.exoplatform.task.service.ParserContext;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.TaskParser;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.service.UserService;
import org.exoplatform.task.util.ListUtil;
import org.exoplatform.task.util.ProjectUtil;
import org.exoplatform.task.util.TaskUtil;

public class TaskManagement {
    private static final Log LOG = ExoLogger.getExoLogger(TaskManagement.class);
    @Inject
    TaskService taskService;
    @Inject
    TaskParser taskParser;
    @Inject
    UserService userService;
    @Inject
    OrganizationService orgService;
    @Inject
    ProjectService projectService;
    @Inject
    @Path(value="index.gtmpl")
    index index;
    @Inject
    ResourceBundle bundle;
    @Inject
    ProjectController projectController;
    @Inject
    NavigationState navState;

    @View
    public Response.Content index(String space_group_id, SecurityContext securityContext) throws EntityNotFoundException {
        long taskNum;
        long id;
        long currProject;
        String username = securityContext.getRemoteUser();
        PortalRequestContext prc = Util.getPortalRequestContext();
        String requestPath = prc.getControllerContext().getParameter(RequestNavigationData.REQUEST_PATH);
        String errorMessage = "";
        TaskModel taskModel = null;
        Object tasks = null;
        Project project = null;
        if (space_group_id == null) {
            long id2 = ProjectUtil.getProjectIdFromURI((String)requestPath);
            if (id2 > -100L && prc.getControllerContext().getRequest().getQueryString() == null) {
                currProject = id2;
                if (id2 > 0L) {
                    try {
                        project = this.projectService.getProject(Long.valueOf(currProject));
                    }
                    catch (EntityNotFoundException ex) {
                        errorMessage = this.bundle.getString("popup.msg.projectNotExist");
                    }
                }
            } else {
                currProject = -1L;
            }
        } else {
            currProject = -2L;
        }
        long taskId = this.navState.getTaskId();
        if (taskId <= 0L && (id = TaskUtil.getTaskIdFromURI((String)requestPath)) > 0L) {
            taskId = id;
        }
        Identity identity = ConversationState.getCurrent().getIdentity();
        TaskQuery taskQuery = new TaskQuery();
        if (project != null && !project.canView(identity)) {
            currProject = space_group_id == null ? -1L : -2L;
            errorMessage = this.bundle.getString("popup.msg.noPermissionToViewProject");
        }
        if (taskId != -1L) {
            try {
                taskModel = TaskUtil.getTaskModel((Long)taskId, (boolean)false, (ResourceBundle)this.bundle, (String)username, (TaskService)this.taskService, (OrganizationService)this.orgService, (UserService)this.userService, (ProjectService)this.projectService);
                if (taskModel.getTask().getStatus() != null && (project = taskModel.getTask().getStatus().getProject()).canView(identity)) {
                    currProject = project.getId();
                    taskQuery.setProjectIds(Arrays.asList(currProject));
                }
                if (currProject <= 0L) {
                    if (this.isAssignedTo(taskModel, username)) {
                        currProject = -2L;
                        taskQuery.setIsTodoOf(username);
                    } else {
                        currProject = -1L;
                        taskQuery.setIsIncomingOf(username);
                    }
                }
            }
            catch (EntityNotFoundException e) {
                taskId = -1L;
                errorMessage = this.bundle.getString("popup.msg.taskNotExist");
            }
        }
        LinkedList<Long> spaceProjectIds = null;
        List projects = ProjectUtil.getProjectTree((String)space_group_id, (ProjectService)this.projectService);
        if (space_group_id != null) {
            spaceProjectIds = new LinkedList<Long>();
            for (Project p : projects) {
                spaceProjectIds.add(p.getId());
            }
        }
        if (taskId <= 0L) {
            if (space_group_id != null) {
                taskQuery.setIsTodoOf(username);
                taskQuery.setProjectIds(spaceProjectIds);
            } else if (currProject > 0L) {
                taskQuery.setProjectIds(Arrays.asList(currProject));
            } else if (currProject == -2L) {
                taskQuery.setIsTodoOf(username);
            } else {
                taskQuery.setIsIncomingOf(username);
            }
        }
        ListAccess listTasks = this.taskService.findTasks(taskQuery);
        int page = 1;
        Paging paging2 = new Paging(page);
        if (taskModel != null) {
            page = 0;
            boolean containTask = false;
            Task[] arr = new Task[]{};
            block5: do {
                paging2 = new Paging(++page);
                for (Task t : arr = (Task[])ListUtil.load((ListAccess)listTasks, (int)paging2.getStart(), (int)paging2.getNumberItemPerPage())) {
                    if (t.getId() != taskId) continue;
                    containTask = true;
                    continue block5;
                }
            } while (!containTask && arr.length > 0);
            if (!containTask) {
                paging2 = new Paging(1);
                taskModel = null;
                taskId = -1L;
                errorMessage = this.bundle.getString("popup.msg.noPermissionToViewTask");
            }
        }
        paging2.setTotal((long)ListUtil.getSize((ListAccess)listTasks));
        HashMap<GroupKey, List<Object>> groupTasks = new HashMap<GroupKey, List<Object>>();
        groupTasks.put(new GroupKey("", null, 0), Arrays.asList(ListUtil.load((ListAccess)listTasks, (int)paging2.getStart(), (int)paging2.getNumberItemPerPage())));
        UserSetting setting = this.userService.getUserSetting(username);
        long incomNum = taskNum = paging2.getTotal();
        if (currProject != -1L && space_group_id == null) {
            TaskQuery q = new TaskQuery();
            q.setIsIncomingOf(username);
            incomNum = ListUtil.getSize((ListAccess)this.taskService.findTasks(q));
        }
        Map defOrders = TaskUtil.getDefOrders((ResourceBundle)this.bundle);
        Map defGroupBys = TaskUtil.getDefGroupBys((long)currProject, (ResourceBundle)this.bundle);
        ListAccess tmp = this.taskService.findLabelsByUser(username);
        List labels = TaskUtil.buildRootLabels(Arrays.asList(ListUtil.load((ListAccess)tmp, (int)0, (int)-1)));
        return this.index.with().currentProjectId((Object)currProject).taskId((Object)taskId).taskModel((Object)taskModel).orders((Object)defOrders).groups((Object)defGroupBys).project((Object)project).tasks(tasks).taskNum((Object)taskNum).incomNum((Object)incomNum).groupTasks(groupTasks).keyword((Object)"").advanceSearch((Object)false).groupBy((Object)"none").orderBy((Object)"createdTime").filter((Object)"").projects((Object)projects).labels((Object)labels).userSetting((Object)setting).userTimezone((Object)this.userService.getUserTimezone(username)).bundle((Object)this.bundle).isInSpace((Object)(space_group_id != null ? 1 : 0)).viewType((Object)"").currentLabelId((Object)-1).taskService((Object)this.taskService).currentUser((Object)username).paging((Object)paging2).errorMessage((Object)errorMessage).ok().withCharset(Tools.UTF_8);
    }

    @Action
    public Response permalink(String space_group_id, Long taskId) {
        this.navState.setTaskId(taskId);
        return TaskManagement_.index((String)space_group_id);
    }

    @Action
    public Response changeViewState(String space_group_id, String groupBy, String orderBy) {
        return TaskManagement_.index((String)space_group_id);
    }

    @Action
    public Response createTask(String space_group_id, String taskInput, String groupBy, String orderBy, SecurityContext securityContext) {
        if (taskInput != null && !taskInput.isEmpty()) {
            String currentUser = securityContext.getRemoteUser();
            ParserContext context = new ParserContext(this.userService.getUserTimezone(currentUser));
            this.taskService.createTask(this.taskParser.parse(taskInput, context));
        }
        return TaskManagement_.index((String)space_group_id);
    }

    private boolean isAssignedTo(TaskModel taskModel, String username) {
        if (username == null || username.isEmpty()) {
            return false;
        }
        if (taskModel.getAssignee() != null && username.equals(taskModel.getAssignee().getUsername())) {
            return true;
        }
        if (taskModel.getTask().getCoworker() != null) {
            return taskModel.getTask().getCoworker().contains(username);
        }
        return false;
    }
}

