/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.management.controller;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import juzu.MimeType;
import juzu.Resource;
import juzu.Response;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.commons.utils.HTMLEntityEncoder;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.exception.NotAllowedOperationOnEntityException;
import org.exoplatform.task.exception.UnAuthorizedOperationException;
import org.exoplatform.task.management.controller.AbstractController;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.StatusService;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class StatusController
extends AbstractController {
    private static final Log LOG = ExoLogger.getExoLogger(StatusController.class);
    @Inject
    ProjectService projectService;
    @Inject
    StatusService statusService;

    @Resource
    @Ajax
    @MimeType.JSON
    public Response getAllStatus(Long projectId) throws EntityNotFoundException, JSONException {
        JSONArray array = new JSONArray();
        Project project = this.projectService.getProject(projectId);
        List<Status> statuses = Collections.emptyList();
        if (project.canView(ConversationState.getCurrent().getIdentity())) {
            statuses = new LinkedList<Status>(this.statusService.getStatuses(projectId.longValue()));
        }
        Collections.sort(statuses);
        for (Status status : statuses) {
            JSONObject json = new JSONObject();
            json.put("value", status.getId());
            json.put("text", (Object)status.getName());
            array.put((Object)json);
        }
        return Response.ok((CharSequence)array.toString());
    }

    @Resource
    @Ajax
    @MimeType.JSON
    public Response updateStatus(Long id, String name) throws EntityNotFoundException, NotAllowedOperationOnEntityException, JSONException, UnAuthorizedOperationException {
        Status status = this.statusService.getStatus(id.longValue());
        if (!status.getProject().canEdit(ConversationState.getCurrent().getIdentity())) {
            throw new UnAuthorizedOperationException(id, Status.class, this.getNoPermissionMsg());
        }
        HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
        status = this.statusService.updateStatus(id.longValue(), name);
        JSONObject json = new JSONObject();
        json.put("id", status.getId());
        json.put("name", (Object)encoder.encode(status.getName()));
        json.put("rank", (Object)status.getRank());
        return Response.ok((CharSequence)json.toString());
    }
}

