/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.management.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.inject.Inject;
import juzu.Action;
import juzu.Path;
import juzu.Response;
import juzu.View;
import juzu.impl.common.Tools;
import juzu.request.SecurityContext;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.RequestNavigationData;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.task.dao.OrderBy;
import org.exoplatform.task.dao.TaskQuery;
import org.exoplatform.task.domain.Label;
import org.exoplatform.task.domain.Priority;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.domain.UserSetting;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.management.controller.NavigationState;
import org.exoplatform.task.management.controller.ProjectController;
import org.exoplatform.task.management.controller.TaskManagement_;
import org.exoplatform.task.management.model.Paging;
import org.exoplatform.task.management.model.TaskFilterData;
import org.exoplatform.task.management.model.ViewType;
import org.exoplatform.task.management.service.ViewStateService;
import org.exoplatform.task.management.templates.index;
import org.exoplatform.task.model.GroupKey;
import org.exoplatform.task.model.TaskModel;
import org.exoplatform.task.service.ParserContext;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.StatusService;
import org.exoplatform.task.service.TaskParser;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.service.UserService;
import org.exoplatform.task.util.ListUtil;
import org.exoplatform.task.util.ProjectUtil;
import org.exoplatform.task.util.TaskUtil;

public class TaskManagement {
    private static final Log LOG = ExoLogger.getExoLogger(TaskManagement.class);
    @Inject
    TaskService taskService;
    @Inject
    TaskParser taskParser;
    @Inject
    UserService userService;
    @Inject
    OrganizationService orgService;
    @Inject
    ProjectService projectService;
    @Inject
    StatusService statusService;
    @Inject
    @Path(value="index.gtmpl")
    index index;
    @Inject
    ResourceBundle bundle;
    @Inject
    ProjectController projectController;
    @Inject
    NavigationState navState;
    @Inject
    TaskFilterData filterData;
    @Inject
    ViewStateService viewStateService;

    @View
    public Response.Content index(String space_group_id, SecurityContext securityContext) throws EntityNotFoundException {
        long taskNum;
        long id;
        long currProject;
        String username = securityContext.getRemoteUser();
        PortalRequestContext prc = Util.getPortalRequestContext();
        String requestPath = prc.getControllerContext().getParameter(RequestNavigationData.REQUEST_PATH);
        String errorMessage = "";
        TaskModel taskModel = null;
        Object tasks = null;
        Project project = null;
        if (space_group_id == null) {
            long id2 = ProjectUtil.getProjectIdFromURI((String)requestPath);
            if (id2 > -100L && prc.getControllerContext().getRequest().getQueryString() == null) {
                currProject = id2;
                if (id2 > 0L) {
                    try {
                        project = this.projectService.getProject(Long.valueOf(currProject));
                    }
                    catch (EntityNotFoundException ex) {
                        errorMessage = this.bundle.getString("popup.msg.projectNotExist");
                    }
                }
            } else {
                currProject = -1L;
            }
        } else {
            currProject = 0L;
        }
        long taskId = this.navState.getTaskId();
        if (taskId <= 0L && (id = TaskUtil.getTaskIdFromURI((String)requestPath)) > 0L) {
            taskId = id;
        }
        Identity identity = ConversationState.getCurrent().getIdentity();
        TaskQuery taskQuery = new TaskQuery();
        if (project != null && !project.canView(identity)) {
            currProject = space_group_id == null ? -1L : 0L;
            errorMessage = this.bundle.getString("popup.msg.noPermissionToViewProject");
        }
        if (taskId != -1L) {
            try {
                taskModel = TaskUtil.getTaskModel((Long)taskId, (boolean)false, (ResourceBundle)this.bundle, (String)username, (TaskService)this.taskService, (OrganizationService)this.orgService, (UserService)this.userService, (ProjectService)this.projectService);
                if (taskModel.getTask().getStatus() != null && (project = taskModel.getTask().getStatus().getProject()).canView(identity)) {
                    currProject = project.getId();
                    taskQuery.setProjectIds(Arrays.asList(currProject));
                }
                if (currProject <= 0L) {
                    if (this.isAssignedTo(taskModel, username)) {
                        currProject = -2L;
                        taskQuery.setIsTodoOf(username);
                    } else {
                        currProject = -1L;
                        taskQuery.setIsIncomingOf(username);
                    }
                }
            }
            catch (EntityNotFoundException e) {
                taskId = -1L;
                errorMessage = this.bundle.getString("popup.msg.taskNotExist");
            }
        }
        LinkedList<Long> spaceProjectIds = null;
        List projects = ProjectUtil.getProjectTree((String)space_group_id, (ProjectService)this.projectService);
        if (space_group_id != null) {
            spaceProjectIds = new LinkedList<Long>();
            for (Project p : projects) {
                spaceProjectIds.add(p.getId());
            }
        }
        if (taskId <= 0L) {
            if (space_group_id != null) {
                taskQuery.setProjectIds(spaceProjectIds);
            } else if (currProject > 0L) {
                taskQuery.setProjectIds(Arrays.asList(currProject));
            } else if (currProject == -2L) {
                taskQuery.setIsTodoOf(username);
            } else {
                taskQuery.setIsIncomingOf(username);
            }
        }
        TaskFilterData.FilterKey filterKey = TaskFilterData.FilterKey.withProject((Long)currProject, null);
        TaskFilterData.Filter fd = this.filterData.getFilter(filterKey);
        ViewType viewType = this.viewStateService.getViewType(username, currProject);
        if (taskId > 0L && taskModel.getTask().isCompleted()) {
            fd.setEnabled(true);
            fd.setShowCompleted(true);
        }
        boolean advanceSearch = fd.isEnabled();
        boolean showCompleted = false;
        String keyword = "";
        ListAccess listTasks = null;
        if (spaceProjectIds != null && spaceProjectIds.isEmpty()) {
            listTasks = TaskUtil.EMPTY_TASK_LIST;
        } else {
            if (advanceSearch) {
                keyword = fd.getKeyword();
                showCompleted = fd.isShowCompleted();
                String currentUser = securityContext.getRemoteUser();
                TimeZone timezone = this.userService.getUserTimezone(currentUser);
                Status status = fd.getStatus() != null ? this.statusService.getStatus(fd.getStatus().longValue()) : null;
                TaskUtil.buildTaskQuery((TaskQuery)taskQuery, (String)fd.getKeyword(), (List)fd.getLabel(), (Status)status, (TaskUtil.DUE)fd.getDue(), (Priority)fd.getPriority(), (List)fd.getAssignee(), (Boolean)fd.isShowCompleted(), (TimeZone)timezone);
            } else {
                taskQuery.setCompleted(Boolean.valueOf(false));
            }
            listTasks = this.taskService.findTasks(taskQuery);
        }
        int page = 1;
        Paging paging2 = new Paging(page);
        if (taskModel != null) {
            page = 0;
            boolean containTask = false;
            Task[] arr = new Task[]{};
            block5: do {
                paging2 = new Paging(++page);
                for (Task t : arr = (Task[])ListUtil.load((ListAccess)listTasks, (int)paging2.getStart(), (int)paging2.getNumberItemPerPage())) {
                    if (t.getId() != taskId) continue;
                    containTask = true;
                    continue block5;
                }
            } while (!containTask && arr.length > 0);
            if (!containTask) {
                paging2 = new Paging(1);
                taskModel = null;
                taskId = -1L;
                errorMessage = this.bundle.getString("popup.msg.noPermissionToViewTask");
            }
        }
        paging2.setTotal((long)ListUtil.getSize((ListAccess)listTasks));
        HashMap<GroupKey, List<Object>> groupTasks = new HashMap<GroupKey, List<Object>>();
        groupTasks.put(new GroupKey("", null, 0), Arrays.asList(ListUtil.load((ListAccess)listTasks, (int)paging2.getStart(), (int)paging2.getNumberItemPerPage())));
        UserSetting setting = this.userService.getUserSetting(username);
        long incomNum = taskNum = paging2.getTotal();
        if (advanceSearch || currProject != -1L) {
            TaskQuery q = new TaskQuery();
            q.setIsIncomingOf(username);
            q.setCompleted(Boolean.valueOf(false));
            incomNum = ListUtil.getSize((ListAccess)this.taskService.findTasks(q));
        }
        Map defOrders = TaskUtil.getDefOrders((ResourceBundle)this.bundle);
        Map defGroupBys = TaskUtil.getDefGroupBys((long)currProject, (ResourceBundle)this.bundle);
        ListAccess tmp = this.taskService.findLabelsByUser(username);
        List labels = TaskUtil.buildRootLabels(Arrays.asList(ListUtil.load((ListAccess)tmp, (int)0, (int)-1)));
        List projectStatus = new ArrayList();
        HashMap<Long, Integer> numberTasks = new HashMap<Long, Integer>();
        if (ViewType.BOARD == viewType && currProject > 0L) {
            projectStatus = this.statusService.getStatuses(currProject);
            for (List list : groupTasks.values()) {
                for (Task task : list) {
                    Status st = task.getStatus();
                    int num = 0;
                    if (numberTasks.containsKey(st.getId())) {
                        num = (Integer)numberTasks.get(st.getId());
                    }
                    numberTasks.put(st.getId(), ++num);
                }
            }
        }
        return this.index.with().currentProjectId((Object)currProject).taskId((Object)taskId).taskModel((Object)taskModel).orders((Object)defOrders).groups((Object)defGroupBys).project((Object)project).projectStatuses(projectStatus).tasks(tasks).taskNum((Object)taskNum).incomNum((Object)incomNum).groupTasks(groupTasks).keyword((Object)keyword).showCompleted((Object)(advanceSearch && showCompleted ? 1 : 0)).advanceSearch((Object)advanceSearch).groupBy((Object)"none").orderBy((Object)"createdTime").filter((Object)"").projects((Object)projects).labels((Object)labels).userSetting((Object)setting).userTimezone((Object)this.userService.getUserTimezone(username)).bundle((Object)this.bundle).isInSpace((Object)(space_group_id != null ? 1 : 0)).viewType((Object)viewType).currentLabelId((Object)-1).currentLabelName((Object)"").taskService((Object)this.taskService).currentUser((Object)username).paging((Object)paging2).errorMessage((Object)errorMessage).numberTasksByStatus(numberTasks).ok().withCharset(Tools.UTF_8);
    }

    @View
    public Response projectPermalink(String space_group_id, Long projectId, String filter, Long labelId, SecurityContext securityContext) throws EntityNotFoundException {
        long DEFAULT_PROJECT_ID;
        long l = DEFAULT_PROJECT_ID = space_group_id == null ? -1L : -2L;
        if (projectId == null) {
            projectId = DEFAULT_PROJECT_ID;
        }
        String username = securityContext.getRemoteUser();
        Identity identity = ConversationState.getCurrent().getIdentity();
        String errorMessage = "";
        TimeZone userTimezone = this.userService.getUserTimezone(username);
        LinkedList<Long> spaceProjectIds = null;
        List projects = ProjectUtil.getProjectTree((String)space_group_id, (ProjectService)this.projectService);
        if (space_group_id != null) {
            spaceProjectIds = new LinkedList<Long>();
            for (Project p : projects) {
                spaceProjectIds.add(p.getId());
            }
            if (projectId > 0L && !spaceProjectIds.contains(projectId)) {
                errorMessage = this.bundle.getString("popup.msg.projectNotExist");
                projectId = DEFAULT_PROJECT_ID;
            }
        }
        Project project = null;
        Label label = null;
        if (projectId > 0L) {
            project = this.projectService.getProject(projectId);
            if (project == null) {
                errorMessage = this.bundle.getString("popup.msg.projectNotExist");
                projectId = DEFAULT_PROJECT_ID;
            } else if (!project.canView(identity)) {
                errorMessage = this.bundle.getString("popup.msg.noPermissionToViewProject");
                projectId = DEFAULT_PROJECT_ID;
            }
        }
        Map defOrders = TaskUtil.getDefOrders((ResourceBundle)this.bundle);
        Map defGroupBys = TaskUtil.getDefGroupBys((long)projectId, (ResourceBundle)this.bundle);
        String groupBy = "none";
        String orderBy = "createdBy";
        Object taskModel = null;
        TaskQuery taskQuery = new TaskQuery();
        if (projectId > 0L) {
            taskQuery.setProjectIds(Arrays.asList(projectId));
            orderBy = "dueDate";
        } else if (projectId == -1L) {
            taskQuery.setIsIncomingOf(username);
            orderBy = "createdBy";
        } else if (projectId == -2L) {
            taskQuery.setIsTodoOf(username);
            if (spaceProjectIds != null) {
                taskQuery.setProjectIds(spaceProjectIds);
            }
            orderBy = "dueDate";
            if (filter != null && !filter.isEmpty()) {
                if ("overDue".equalsIgnoreCase(filter)) {
                    defGroupBys = TaskUtil.resolve(Arrays.asList("none", "project", "label"), (ResourceBundle)this.bundle);
                    defOrders = TaskUtil.resolve(Arrays.asList("title", "priority", "dueDate"), (ResourceBundle)this.bundle);
                    groupBy = "project";
                } else if ("today".equalsIgnoreCase(filter)) {
                    defGroupBys = TaskUtil.resolve(Arrays.asList("none", "project", "label"), (ResourceBundle)this.bundle);
                    defOrders = TaskUtil.resolve(Arrays.asList("title", "priority", "rank"), (ResourceBundle)this.bundle);
                    if (orderBy == null || !defOrders.containsKey(orderBy)) {
                        orderBy = "priority";
                    }
                    groupBy = "none";
                } else if ("tomorrow".equalsIgnoreCase(filter)) {
                    defGroupBys = TaskUtil.resolve(Arrays.asList("none", "project", "label"), (ResourceBundle)this.bundle);
                    defOrders = TaskUtil.resolve(Arrays.asList("title", "priority", "rank"), (ResourceBundle)this.bundle);
                    if (orderBy == null || !defOrders.containsKey(orderBy)) {
                        orderBy = "priority";
                    }
                    groupBy = "none";
                } else if ("upcoming".equalsIgnoreCase(filter)) {
                    defGroupBys = TaskUtil.resolve(Arrays.asList("none", "project", "label"), (ResourceBundle)this.bundle);
                    defOrders = TaskUtil.resolve(Arrays.asList("title", "priority", "dueDate", "rank"), (ResourceBundle)this.bundle);
                    groupBy = "none";
                }
                if (orderBy == null || !defOrders.containsKey(orderBy)) {
                    orderBy = "dueDate";
                }
                if (groupBy == null || !defGroupBys.containsKey(groupBy)) {
                    groupBy = "dueDate";
                }
                Date[] filterDate = TaskUtil.convertDueDate((String)filter, (TimeZone)userTimezone);
                taskQuery.setDueDateFrom(filterDate[0]);
                taskQuery.setDueDateTo(filterDate[1]);
            }
        } else if (projectId == -5L && labelId != null) {
            if (labelId > 0L) {
                label = this.taskService.getLabel(labelId.longValue());
                if (label != null && label.getUsername().equals(username)) {
                    taskQuery.setLabelIds(Arrays.asList(labelId));
                } else {
                    taskQuery.setIsIncomingOf(username);
                    orderBy = "createdBy";
                }
            } else {
                taskQuery.setIsLabelOf(username);
                groupBy = "label";
                orderBy = "dueDate";
            }
        }
        OrderBy.ASC order = null;
        if (orderBy != null && !orderBy.trim().isEmpty()) {
            order = "title".equals(orderBy) || "dueDate".equals(orderBy) ? new OrderBy.ASC(orderBy) : new OrderBy.DESC(orderBy);
            taskQuery.setOrderBy(Arrays.asList(order));
        }
        TaskFilterData.FilterKey filterKey = TaskFilterData.FilterKey.withProject((Long)projectId, filter == null || filter.isEmpty() ? null : TaskUtil.DUE.valueOf((String)filter.toUpperCase()));
        if (labelId != null && labelId != -1L) {
            filterKey = TaskFilterData.FilterKey.withLabel((Long)labelId);
        }
        TaskFilterData.Filter fd = this.filterData.getFilter(filterKey);
        boolean advanceSearch = fd.isEnabled();
        boolean showCompleted = false;
        String keyword = "";
        if (advanceSearch) {
            keyword = fd.getKeyword();
            showCompleted = fd.isShowCompleted();
            String currentUser = securityContext.getRemoteUser();
            TimeZone timezone = this.userService.getUserTimezone(currentUser);
            Status status = fd.getStatus() != null ? this.statusService.getStatus(fd.getStatus().longValue()) : null;
            TaskUtil.buildTaskQuery((TaskQuery)taskQuery, (String)fd.getKeyword(), (List)fd.getLabel(), (Status)status, (TaskUtil.DUE)fd.getDue(), (Priority)fd.getPriority(), (List)fd.getAssignee(), (Boolean)fd.isShowCompleted(), (TimeZone)timezone);
        } else {
            taskQuery.setCompleted(Boolean.valueOf(false));
        }
        ListAccess listTasks = this.taskService.findTasks(taskQuery);
        int page = 1;
        Paging paging2 = new Paging(page);
        paging2.setTotal((long)ListUtil.getSize((ListAccess)listTasks));
        long taskNum = paging2.getTotal();
        Map<Object, List<Object>> groupTasks = new HashMap<GroupKey, List<Object>>();
        List<Object> tasks = Arrays.asList(ListUtil.load((ListAccess)listTasks, (int)paging2.getStart(), (int)paging2.getNumberItemPerPage()));
        if (groupBy != null && !groupBy.isEmpty() && !"none".equalsIgnoreCase(groupBy)) {
            groupTasks = TaskUtil.groupTasks(tasks, (String)groupBy, (String)username, (TimeZone)userTimezone, (ResourceBundle)this.bundle, (TaskService)this.taskService, (UserService)this.userService);
        }
        if (groupTasks.isEmpty()) {
            groupTasks.put(new GroupKey("", null, 0), tasks);
        }
        UserSetting setting = this.userService.getUserSetting(username);
        long incomNum = taskNum;
        if (advanceSearch || projectId != -1L) {
            TaskQuery q = new TaskQuery();
            q.setIsIncomingOf(username);
            q.setCompleted(Boolean.valueOf(false));
            incomNum = ListUtil.getSize((ListAccess)this.taskService.findTasks(q));
        }
        ListAccess tmp = this.taskService.findLabelsByUser(username);
        List labels = TaskUtil.buildRootLabels(Arrays.asList(ListUtil.load((ListAccess)tmp, (int)0, (int)-1)));
        return this.index.with().currentProjectId((Object)projectId).taskId((Object)-1).taskModel(taskModel).orders((Object)defOrders).groups((Object)defGroupBys).project((Object)project).tasks(tasks).taskNum((Object)taskNum).incomNum((Object)incomNum).groupTasks(groupTasks).keyword((Object)keyword).showCompleted((Object)(advanceSearch && showCompleted ? 1 : 0)).advanceSearch((Object)advanceSearch).groupBy((Object)groupBy).orderBy((Object)orderBy).filter((Object)(filter == null ? "" : filter)).projects((Object)projects).labels((Object)labels).userSetting((Object)setting).userTimezone((Object)userTimezone).bundle((Object)this.bundle).isInSpace((Object)(space_group_id != null ? 1 : 0)).viewType((Object)ViewType.LIST).currentLabelId((Object)(labelId == null ? -1L : labelId)).currentLabelName((Object)(label != null ? label.getName() : "")).taskService((Object)this.taskService).currentUser((Object)username).paging((Object)paging2).errorMessage((Object)errorMessage).ok().withCharset(Tools.UTF_8);
    }

    @Action
    public Response permalink(String space_group_id, Long taskId) {
        this.navState.setTaskId(taskId);
        return TaskManagement_.index((String)space_group_id);
    }

    @Action
    public Response changeViewState(String space_group_id, String groupBy, String orderBy) {
        return TaskManagement_.index((String)space_group_id);
    }

    @Action
    public Response createTask(String space_group_id, String taskInput, String groupBy, String orderBy, SecurityContext securityContext) {
        if (taskInput != null && !taskInput.isEmpty()) {
            String currentUser = securityContext.getRemoteUser();
            ParserContext context = new ParserContext(this.userService.getUserTimezone(currentUser));
            this.taskService.createTask(this.taskParser.parse(taskInput, context));
        }
        return TaskManagement_.index((String)space_group_id);
    }

    private boolean isAssignedTo(TaskModel taskModel, String username) {
        if (username == null || username.isEmpty()) {
            return false;
        }
        if (taskModel.getAssignee() != null && username.equals(taskModel.getAssignee().getUsername())) {
            return true;
        }
        if (taskModel.getTask().getCoworker() != null) {
            return taskModel.getTask().getCoworker().contains(username);
        }
        return false;
    }
}

