/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.management.controller;

import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.inject.Inject;
import juzu.MimeType;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.impl.common.Tools;
import juzu.request.SecurityContext;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.management.model.ViewState;
import org.exoplatform.task.management.service.ViewStateService;
import org.exoplatform.task.management.templates.taskFilter;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.StatusService;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.service.UserService;
import org.json.JSONException;

public class FilterController {
    private static final Log LOG = ExoLogger.getExoLogger(FilterController.class);
    @Inject
    TaskService taskService;
    @Inject
    UserService userService;
    @Inject
    ProjectService projectService;
    @Inject
    StatusService statusService;
    @Inject
    ResourceBundle bundle;
    @Inject
    ViewStateService viewStateService;
    @Inject
    @Path(value="taskFilter.gtmpl")
    taskFilter taskFilter;

    @Resource
    @Ajax
    @MimeType.HTML
    public Response toggleFilter(Long projectId, Long labelId, String dueCategory, SecurityContext securityContext) throws JSONException, EntityNotFoundException {
        ViewState.Filter fd;
        String listId = ViewState.buildId((Long)projectId, (Long)labelId, (String)dueCategory);
        fd.setEnabled(!(fd = this.viewStateService.getFilter(listId)).isEnabled());
        this.viewStateService.saveFilter(fd);
        if (fd.isEnabled()) {
            Project project;
            boolean filterLabel = labelId == null || labelId <= 0L;
            boolean filterStatus = projectId != null && projectId > 0L;
            Project project2 = project = filterStatus ? this.projectService.getProject(projectId) : null;
            if (project != null && !project.canView(ConversationState.getCurrent().getIdentity())) {
                project = null;
            }
            List status = Collections.emptyList();
            if (filterStatus && project != null) {
                status = this.statusService.getStatuses(project.getId());
            }
            boolean filterAssignee = projectId == null || projectId != -1L;
            boolean filterDueDate = dueCategory == null || dueCategory.isEmpty();
            return this.taskFilter.with().filterData((Object)fd).taskService((Object)this.taskService).userService((Object)this.userService).filterLabel((Object)filterLabel).status((Object)status).bundle((Object)this.bundle).filterStatus((Object)filterStatus).filterAssignee((Object)filterAssignee).filterDueDate((Object)filterDueDate).ok().withCharset(Tools.UTF_8);
        }
        return Response.ok();
    }
}

