/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.management.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.inject.Inject;
import juzu.Action;
import juzu.Path;
import juzu.Response;
import juzu.View;
import juzu.impl.common.Tools;
import juzu.request.SecurityContext;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.RequestNavigationData;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.task.dao.OrderBy;
import org.exoplatform.task.dao.TaskQuery;
import org.exoplatform.task.domain.Label;
import org.exoplatform.task.domain.Priority;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.domain.UserSetting;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.management.controller.NavigationState;
import org.exoplatform.task.management.controller.ProjectController;
import org.exoplatform.task.management.controller.TaskManagement_;
import org.exoplatform.task.management.model.Paging;
import org.exoplatform.task.management.model.ViewState;
import org.exoplatform.task.management.model.ViewType;
import org.exoplatform.task.management.service.ViewStateService;
import org.exoplatform.task.management.templates.index;
import org.exoplatform.task.model.GroupKey;
import org.exoplatform.task.model.TaskModel;
import org.exoplatform.task.service.ParserContext;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.StatusService;
import org.exoplatform.task.service.TaskParser;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.service.UserService;
import org.exoplatform.task.util.ListUtil;
import org.exoplatform.task.util.ProjectUtil;
import org.exoplatform.task.util.TaskUtil;

public class TaskManagement {
    public static final int MIN_NUMBER_TASK_GROUPABLE = 2;
    private static final Log LOG = ExoLogger.getExoLogger(TaskManagement.class);
    @Inject
    TaskService taskService;
    @Inject
    TaskParser taskParser;
    @Inject
    UserService userService;
    @Inject
    OrganizationService orgService;
    @Inject
    ProjectService projectService;
    @Inject
    StatusService statusService;
    @Inject
    @Path(value="index.gtmpl")
    index index;
    @Inject
    ResourceBundle bundle;
    @Inject
    ProjectController projectController;
    @Inject
    NavigationState navState;
    @Inject
    ViewStateService viewStateService;

    @View
    public Response index(String space_group_id, SecurityContext securityContext) throws EntityNotFoundException {
        long taskNum;
        long id;
        long taskId;
        String username = securityContext.getRemoteUser();
        PortalRequestContext prc = Util.getPortalRequestContext();
        String requestPath = prc.getControllerContext().getParameter(RequestNavigationData.REQUEST_PATH);
        Long currProject = -1L;
        String filter = "";
        Long labelId = null;
        Object[] params = ProjectUtil.parsePermalinkURL((String)requestPath);
        if (params != null) {
            currProject = (Long)params[0];
            if (params[1] != null) {
                filter = (String)params[1];
            }
            if ((labelId = (Long)params[2]) != null) {
                currProject = -5L;
            }
        }
        String errorMessage = "";
        TaskModel taskModel = null;
        Project project = null;
        if (space_group_id == null) {
            long projectId = ProjectUtil.getProjectIdFromURI((String)requestPath);
            if (projectId > 0L && prc.getControllerContext().getRequest().getQueryString() == null) {
                currProject = projectId;
            }
        } else {
            currProject = 0L;
        }
        if (currProject > 0L) {
            try {
                project = this.projectService.getProject(currProject);
            }
            catch (EntityNotFoundException ex) {
                errorMessage = this.bundle.getString("popup.msg.projectNotExist");
            }
        }
        if ((taskId = this.navState.getTaskId().longValue()) <= 0L && (id = TaskUtil.getTaskIdFromURI((String)requestPath)) > 0L) {
            taskId = id;
        }
        Identity identity = ConversationState.getCurrent().getIdentity();
        TaskQuery taskQuery = new TaskQuery();
        if (project != null && !project.canView(identity)) {
            currProject = space_group_id == null ? -1L : 0L;
            errorMessage = this.bundle.getString("popup.msg.noPermissionToViewProject");
        }
        if (taskId > 0L) {
            try {
                taskModel = TaskUtil.getTaskModel((Long)taskId, (boolean)false, (ResourceBundle)this.bundle, (String)username, (TaskService)this.taskService, (OrganizationService)this.orgService, (UserService)this.userService, (ProjectService)this.projectService);
                if (!TaskUtil.hasViewPermission((Task)taskModel.getTask())) {
                    taskModel = null;
                    taskId = -1L;
                    errorMessage = this.bundle.getString("popup.msg.noPermissionToViewTask");
                } else {
                    if (taskModel.getTask().getStatus() != null && (project = taskModel.getTask().getStatus().getProject()).canView(identity)) {
                        currProject = project.getId();
                        taskQuery.setProjectIds(Arrays.asList(currProject));
                    }
                    if (currProject <= 0L) {
                        if (this.isAssignedTo(taskModel, username) || project != null && TaskUtil.hasViewOnlyPermission((Task)taskModel.getTask())) {
                            currProject = -2L;
                            taskQuery.setIsTodoOf(username);
                        } else {
                            currProject = -1L;
                            taskQuery.setIsIncomingOf(username);
                        }
                    }
                }
            }
            catch (EntityNotFoundException e) {
                taskId = -1L;
                errorMessage = this.bundle.getString("popup.msg.taskNotExist");
            }
        }
        LinkedList<Long> spaceProjectIds = null;
        List projects = ProjectUtil.getProjectTree((String)space_group_id, (ProjectService)this.projectService);
        if (space_group_id != null) {
            spaceProjectIds = new LinkedList<Long>();
            for (Project p : projects) {
                spaceProjectIds.add(p.getId());
            }
        }
        Map defOrders = TaskUtil.getDefOrders((ResourceBundle)this.bundle);
        Map defGroupBys = TaskUtil.getDefGroupBys((long)currProject, (ResourceBundle)this.bundle);
        String listId = ViewState.buildId((Long)currProject, (Long)-1L, (String)"incoming");
        ViewState viewState = this.viewStateService.getViewState(listId);
        String orderBy = viewState.getOrderBy();
        if (orderBy == null) {
            orderBy = "createdTime";
        }
        taskQuery.setOrderBy(Arrays.asList(new OrderBy.DESC(orderBy)));
        String groupBy = viewState.getGroupBy();
        if (groupBy == null) {
            groupBy = "none";
        }
        String currentUser = securityContext.getRemoteUser();
        TimeZone userTimezone = this.userService.getUserTimezone(currentUser);
        Label label = null;
        if (taskId <= 0L) {
            if (space_group_id != null) {
                taskQuery.setProjectIds(spaceProjectIds);
            } else if (currProject > 0L) {
                taskQuery.setProjectIds(Arrays.asList(currProject));
            } else if (currProject == -2L) {
                taskQuery.setIsTodoOf(username);
                if (spaceProjectIds != null) {
                    taskQuery.setProjectIds(spaceProjectIds);
                }
                if (filter != null && !filter.isEmpty()) {
                    if ("overDue".equalsIgnoreCase(filter)) {
                        defGroupBys = TaskUtil.resolve(Arrays.asList("none", "project", "label"), (ResourceBundle)this.bundle);
                        defOrders = TaskUtil.resolve(Arrays.asList("title", "priority", "dueDate"), (ResourceBundle)this.bundle);
                        groupBy = "project";
                    } else if ("today".equalsIgnoreCase(filter) || "tomorrow".equalsIgnoreCase(filter)) {
                        defGroupBys = TaskUtil.resolve(Arrays.asList("none", "project", "label"), (ResourceBundle)this.bundle);
                        defOrders = TaskUtil.resolve(Arrays.asList("title", "priority", "rank"), (ResourceBundle)this.bundle);
                    } else if ("upcoming".equalsIgnoreCase(filter)) {
                        defGroupBys = TaskUtil.resolve(Arrays.asList("none", "project", "label"), (ResourceBundle)this.bundle);
                        defOrders = TaskUtil.resolve(Arrays.asList("title", "priority", "dueDate", "rank"), (ResourceBundle)this.bundle);
                    }
                    Date[] filterDate = TaskUtil.convertDueDate((String)filter, (TimeZone)userTimezone);
                    taskQuery.setDueDateFrom(filterDate[0]);
                    taskQuery.setDueDateTo(filterDate[1]);
                }
            } else if (currProject == -5L && labelId != null) {
                if (labelId > 0L) {
                    label = this.taskService.getLabel(labelId.longValue());
                    if (label != null && label.getUsername().equals(username)) {
                        taskQuery.setLabelIds(Arrays.asList(labelId));
                    } else {
                        taskQuery.setIsIncomingOf(username);
                        orderBy = "createdBy";
                    }
                } else {
                    taskQuery.setIsLabelOf(username);
                    groupBy = "label";
                }
            } else {
                taskQuery.setIsIncomingOf(username);
            }
        }
        ViewState.Filter fd = this.viewStateService.getFilter(listId);
        if (taskId > 0L && taskModel != null && taskModel.getTask() != null && taskModel.getTask().isCompleted()) {
            fd.setEnabled(true);
            fd.setShowCompleted(true);
        }
        boolean advanceSearch = fd.isEnabled();
        boolean showCompleted = false;
        String keyword = "";
        ListAccess listTasks = null;
        if (spaceProjectIds != null && spaceProjectIds.isEmpty()) {
            listTasks = TaskUtil.EMPTY_TASK_LIST;
        } else {
            if (advanceSearch) {
                keyword = fd.getKeyword();
                showCompleted = fd.isShowCompleted();
                Status status = fd.getStatus() != null ? this.statusService.getStatus(fd.getStatus().longValue()) : null;
                TaskUtil.buildTaskQuery((TaskQuery)taskQuery, (String)fd.getKeyword(), (List)fd.getLabel(), (Status)status, (TaskUtil.DUE)fd.getDue(), (Priority)fd.getPriority(), (List)fd.getAssignees(), (Boolean)fd.isShowCompleted(), (TimeZone)userTimezone);
            } else {
                taskQuery.setCompleted(Boolean.valueOf(false));
            }
            listTasks = this.taskService.findTasks(taskQuery);
        }
        int page = 1;
        Paging paging2 = new Paging(page);
        if (taskModel != null) {
            page = 0;
            boolean containTask = false;
            Task[] arr = null;
            block5: do {
                paging2 = new Paging(++page);
                for (Task t : arr = (Task[])ListUtil.load((ListAccess)listTasks, (int)paging2.getStart(), (int)paging2.getNumberItemPerPage())) {
                    if (t.getId() != taskId) continue;
                    containTask = true;
                    continue block5;
                }
            } while (!containTask && arr.length > 0);
            if (!containTask) {
                paging2 = new Paging(1);
                taskModel = null;
                taskId = -1L;
                errorMessage = this.bundle.getString("popup.msg.noPermissionToViewTask");
            }
        }
        paging2.setTotal((long)ListUtil.getSize((ListAccess)listTasks));
        long countTasks = paging2.getTotal();
        if (countTasks < 2L) {
            groupBy = "none";
        }
        Map groupTasks = new HashMap<GroupKey, List<Object>>();
        if (countTasks >= 2L && groupBy != null && !groupBy.isEmpty() && !"none".equalsIgnoreCase(groupBy)) {
            groupTasks = TaskUtil.groupTasks(Arrays.asList(ListUtil.load((ListAccess)listTasks, (int)paging2.getStart(), (int)paging2.getNumberItemPerPage())), (String)groupBy, (String)currentUser, (TimeZone)userTimezone, (ResourceBundle)this.bundle, (TaskService)this.taskService, (UserService)this.userService);
        }
        if (groupTasks.isEmpty()) {
            groupTasks.put(new GroupKey("", null, 0), Arrays.asList(ListUtil.load((ListAccess)listTasks, (int)paging2.getStart(), (int)paging2.getNumberItemPerPage())));
        }
        UserSetting setting = this.userService.getUserSetting(username);
        long incomNum = taskNum = paging2.getTotal();
        if (advanceSearch || currProject != -1L) {
            TaskQuery q = new TaskQuery();
            q.setIsIncomingOf(username);
            q.setCompleted(Boolean.valueOf(false));
            incomNum = ListUtil.getSize((ListAccess)this.taskService.findTasks(q));
        }
        ListAccess tmp = this.taskService.findLabelsByUser(username);
        List labels = TaskUtil.buildRootLabels(Arrays.asList(ListUtil.load((ListAccess)tmp, (int)0, (int)-1)));
        List projectStatus = new ArrayList();
        HashMap<Long, Integer> numberTasks = new HashMap<Long, Integer>();
        ViewType viewType = viewState.getViewType();
        if (ViewType.BOARD == viewType && currProject > 0L) {
            projectStatus = this.statusService.getStatuses(currProject.longValue());
            for (List list : groupTasks.values()) {
                for (Task task : list) {
                    Status st = task.getStatus();
                    int num = 0;
                    if (numberTasks.containsKey(st.getId())) {
                        num = (Integer)numberTasks.get(st.getId());
                    }
                    numberTasks.put(st.getId(), ++num);
                }
            }
        }
        return this.index.with().currentProjectId((Object)currProject).taskId((Object)taskId).useCalendar((Object)TaskUtil.isCalendarEnabled()).taskModel((Object)taskModel).orders((Object)defOrders).groups((Object)defGroupBys).project((Object)project).projectStatuses(projectStatus).tasks(null).taskNum((Object)taskNum).incomNum((Object)incomNum).groupTasks(groupTasks).keyword((Object)keyword).showCompleted((Object)(advanceSearch && showCompleted ? 1 : 0)).advanceSearch((Object)advanceSearch).groupBy((Object)groupBy).orderBy((Object)orderBy).filter((Object)filter).projects((Object)projects).labels((Object)labels).userSetting((Object)setting).userTimezone((Object)this.userService.getUserTimezone(username)).bundle((Object)this.bundle).isInSpace((Object)(space_group_id != null ? 1 : 0)).viewType((Object)viewType).currentLabelId((Object)(labelId == null ? -1L : labelId)).currentLabelName((Object)(label != null ? label.getName() : "")).taskService((Object)this.taskService).currentUser((Object)username).paging((Object)paging2).errorMessage((Object)errorMessage).numberTasksByStatus(numberTasks).ok().withCharset(Tools.UTF_8);
    }

    private List<Long> recursiveGetId(List<Project> projects) {
        ArrayList<Long> results = new ArrayList<Long>();
        if (projects != null) {
            for (Project p : projects) {
                results.add(p.getId());
                if (p.getChildren() == null) continue;
                results.addAll(this.recursiveGetId(p.getChildren()));
            }
        }
        return results;
    }

    @Action
    public Response permalink(String space_group_id, Long taskId) {
        this.navState.setTaskId(taskId);
        return TaskManagement_.index((String)space_group_id);
    }

    @Action
    public Response changeViewState(String space_group_id, String groupBy, String orderBy) {
        return TaskManagement_.index((String)space_group_id);
    }

    @Action
    public Response createTask(String space_group_id, String taskInput, String groupBy, String orderBy, SecurityContext securityContext) {
        if (taskInput != null && !taskInput.isEmpty()) {
            String currentUser = securityContext.getRemoteUser();
            ParserContext context = new ParserContext(this.userService.getUserTimezone(currentUser));
            this.taskService.createTask(this.taskParser.parse(taskInput, context));
        }
        return TaskManagement_.index((String)space_group_id);
    }

    private boolean isAssignedTo(TaskModel taskModel, String username) {
        if (username == null || username.isEmpty()) {
            return false;
        }
        if (taskModel.getAssignee() != null && username.equals(taskModel.getAssignee().getUsername())) {
            return true;
        }
        if (taskModel.getTask().getCoworker() != null) {
            return taskModel.getTask().getCoworker().contains(username);
        }
        return false;
    }
}

