/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.annotation.security.RolesAllowed;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityNotFoundException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.service.rest.Util;
import org.exoplatform.timetracker.dto.ActivityCode;
import org.exoplatform.timetracker.dto.SubActivityCode;
import org.exoplatform.timetracker.dto.SubType;
import org.exoplatform.timetracker.dto.Type;
import org.exoplatform.timetracker.service.CodesService;

@Path(value="timetracker/codesmgn")
@RolesAllowed(value={"users"})
@Api(value="/timetracker", description="Manage and access Codes")
public class CodesManagementREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(CodesManagementREST.class);
    private final String portalContainerName = "portal";
    private final CodesService codesService;

    public CodesManagementREST(CodesService codesService, PortalContainer container) {
        this.codesService = codesService;
    }

    @GET
    @Path(value="activityCode")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieves all available subresources of current endpoint", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error")})
    public Response getActivityCodes() {
        try {
            Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
            if (sourceIdentity == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            return Response.ok(this.codesService.getActivityCodesList()).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while getting ActivityCodes", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="activityCode")
    @RolesAllowed(value={"administrators"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Creates a new ActivityCode", httpMethod="POST", response=Response.class, notes="empty response")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response createActivityCode(@ApiParam(value="ActivityCode to save", required=true) ActivityCode activityCode) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.codesService.createActivityCode(activityCode);
        }
        catch (EntityExistsException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while creating ActivityCode", (Throwable)e);
            return Response.serverError().build();
        }
        LOG.info("service=time-tracker operation=add-activity-code parameters=\"user_social_id:{}\"", new Object[]{sourceIdentity.getId()});
        return Response.noContent().build();
    }

    @PUT
    @Path(value="activityCode")
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Updates an existing ActivityCode identified by its id", httpMethod="PUT", response=Response.class, notes="empty response")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateActivityCode(@ApiParam(value="ActivityCode to update", required=true) ActivityCode activityCode) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.codesService.updateActivityCode(activityCode, this.getCurrentUserName());
        }
        catch (IllegalAccessException e) {
            LOG.warn((Object)e);
            return Response.status((int)401).build();
        }
        catch (EntityExistsException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while updating ActivityCode", (Throwable)e);
            return Response.serverError().build();
        }
        LOG.info("service=time-tracker operation=update-activity-code parameters=\"user_social_id:{}\"", new Object[]{sourceIdentity.getId()});
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="activityCode/{activityCodeId}")
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Deletes an existing ActivityCode identified by its id", httpMethod="DELETE", response=Response.class, notes="empty response")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteActivityCode(@ApiParam(value="ActivityCode technical id to delete", required=true) @PathParam(value="activityCodeId") Long activityCodeId) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.codesService.deleteActivityCode(activityCodeId, this.getCurrentUserName());
        }
        catch (IllegalAccessException e) {
            LOG.warn((Object)e);
            return Response.status((int)401).build();
        }
        catch (EntityNotFoundException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while deleting ActivityCode", (Throwable)e);
            return Response.serverError().build();
        }
        LOG.info("service=time-tracker operation=delete-activity-code parameters=\"user_social_id:{}\"", new Object[]{sourceIdentity.getId()});
        return Response.noContent().build();
    }

    @GET
    @Path(value="subActivityCode")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieves all available subresources of current endpoint", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error")})
    public Response getSubActivityCodes() {
        try {
            Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
            if (sourceIdentity == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            return Response.ok(this.codesService.getSubActivityCodesList()).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while getting SubActivityCodes", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="subActivityCode")
    @RolesAllowed(value={"administrators"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Creates a new SubActivityCode", httpMethod="POST", response=Response.class, notes="empty response")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response createSubActivityCode(@ApiParam(value="SubActivityCode to save", required=true) SubActivityCode subActivityCode) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.codesService.createSubActivityCode(subActivityCode);
        }
        catch (EntityExistsException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while creating SubActivityCode", (Throwable)e);
            return Response.serverError().build();
        }
        LOG.info("service=time-tracker operation=add-sub-activity-code parameters=\"user_social_id:{}\"", new Object[]{sourceIdentity.getId()});
        return Response.noContent().build();
    }

    @PUT
    @Path(value="subActivityCode")
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Updates an existing SubActivityCode identified by its id", httpMethod="PUT", response=Response.class, notes="empty response")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateSubActivityCode(@ApiParam(value="SubActivityCode to update", required=true) SubActivityCode subActivityCode) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.codesService.updateSubActivityCode(subActivityCode, this.getCurrentUserName());
        }
        catch (IllegalAccessException e) {
            LOG.warn((Object)e);
            return Response.status((int)401).build();
        }
        catch (EntityExistsException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while updating SubActivityCode", (Throwable)e);
            return Response.serverError().build();
        }
        LOG.info("service=time-tracker operation=edit-sub-activity-code parameters=\"user_social_id:{}\"", new Object[]{sourceIdentity.getId()});
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="subActivityCode/{subActivityCodeId}")
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Deletes an existing SubActivityCode identified by its id", httpMethod="DELETE", response=Response.class, notes="empty response")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteSubActivityCode(@ApiParam(value="SubActivityCode technical id to delete", required=true) @PathParam(value="subActivityCodeId") Long subActivityCodeId) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.codesService.deleteSubActivityCode(subActivityCodeId, this.getCurrentUserName());
        }
        catch (IllegalAccessException e) {
            LOG.warn((Object)e);
            return Response.status((int)401).build();
        }
        catch (EntityNotFoundException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while deleting SubActivityCode", (Throwable)e);
            return Response.serverError().build();
        }
        LOG.info("service=time-tracker operation=delete-sub-activity-code parameters=\"user_social_id:{}\"", new Object[]{sourceIdentity.getId()});
        return Response.noContent().build();
    }

    @GET
    @Path(value="type")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieves all available subresources of current endpoint", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error")})
    public Response getTypes() {
        try {
            Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
            if (sourceIdentity == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            return Response.ok(this.codesService.getTypesList()).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while getting Types", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="type")
    @RolesAllowed(value={"administrators"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Creates a new Type", httpMethod="POST", response=Response.class, notes="empty response")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response createType(@ApiParam(value="Type to save", required=true) Type type) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.codesService.createType(type);
        }
        catch (EntityExistsException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while creating Type", (Throwable)e);
            return Response.serverError().build();
        }
        LOG.info("service=time-tracker operation=add-type parameters=\"user_social_id:{}\"", new Object[]{sourceIdentity.getId()});
        return Response.noContent().build();
    }

    @PUT
    @Path(value="type")
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Updates an existing Type identified by its id", httpMethod="PUT", response=Response.class, notes="empty response")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateType(@ApiParam(value="Type to update", required=true) Type type) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.codesService.updateType(type, this.getCurrentUserName());
        }
        catch (IllegalAccessException e) {
            LOG.warn((Object)e);
            return Response.status((int)401).build();
        }
        catch (EntityExistsException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while updating Type", (Throwable)e);
            return Response.serverError().build();
        }
        LOG.info("service=time-tracker operation=edit-type parameters=\"user_social_id:{}\"", new Object[]{sourceIdentity.getId()});
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="type/{typeId}")
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Deletes an existing Type identified by its id", httpMethod="DELETE", response=Response.class, notes="empty response")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteType(@ApiParam(value="Type technical id to delete", required=true) @PathParam(value="typeId") Long typeId) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.codesService.deleteType(typeId, this.getCurrentUserName());
        }
        catch (IllegalAccessException e) {
            LOG.warn((Object)e);
            return Response.status((int)401).build();
        }
        catch (EntityNotFoundException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while deleting Type", (Throwable)e);
            return Response.serverError().build();
        }
        LOG.info("service=time-tracker operation=delete-type parameters=\"user_social_id:{}\"", new Object[]{sourceIdentity.getId()});
        return Response.noContent().build();
    }

    @GET
    @Path(value="subType")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieves all available subresources of current endpoint", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error")})
    public Response getSubTypes() {
        try {
            Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
            if (sourceIdentity == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            return Response.ok(this.codesService.getSubTypesList()).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while getting SubTypes", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="subType")
    @RolesAllowed(value={"administrators"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Creates a new SubType", httpMethod="POST", response=Response.class, notes="empty response")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response createSubType(@ApiParam(value="SubType to save", required=true) SubType subType) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.codesService.createSubType(subType);
        }
        catch (EntityExistsException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while creating SubType", (Throwable)e);
            return Response.serverError().build();
        }
        LOG.info("service=time-tracker operation=add-sub-type parameters=\"user_social_id:{}\"", new Object[]{sourceIdentity.getId()});
        return Response.noContent().build();
    }

    @PUT
    @Path(value="subType")
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Updates an existing SubType identified by its id", httpMethod="PUT", response=Response.class, notes="empty response")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateSubType(@ApiParam(value="SubType to update", required=true) SubType subType) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.codesService.updateSubType(subType, this.getCurrentUserName());
        }
        catch (IllegalAccessException e) {
            LOG.warn((Object)e);
            return Response.status((int)401).build();
        }
        catch (EntityExistsException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while updating SubType", (Throwable)e);
            return Response.serverError().build();
        }
        LOG.info("service=time-tracker operation=update-sub-type parameters=\"user_social_id:{}\"", new Object[]{sourceIdentity.getId()});
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="subType/{subTypeId}")
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Deletes an existing SubType identified by its id", httpMethod="DELETE", response=Response.class, notes="empty response")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteSubType(@ApiParam(value="SubType technical id to delete", required=true) @PathParam(value="subTypeId") Long subTypeId) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.codesService.deleteSubType(subTypeId, this.getCurrentUserName());
        }
        catch (IllegalAccessException e) {
            LOG.warn((Object)e);
            return Response.status((int)401).build();
        }
        catch (EntityNotFoundException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while deleting SubType", (Throwable)e);
            return Response.serverError().build();
        }
        LOG.info("service=time-tracker operation=delete-sub-type parameters=\"user_social_id:{}\"", new Object[]{sourceIdentity.getId()});
        return Response.noContent().build();
    }

    private String getCurrentUserName() {
        ConversationState state = ConversationState.getCurrent();
        return state == null || state.getIdentity() == null ? null : state.getIdentity().getUserId();
    }
}

