/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.service;

import jakarta.persistence.EntityNotFoundException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.timetracker.dto.SalesOrder;
import org.exoplatform.timetracker.storage.SalesOrderStorage;

public class SalesOrderService {
    private final SalesOrderStorage salesOrderStorage;

    public SalesOrderService(SalesOrderStorage salesOrderStorage) {
        this.salesOrderStorage = salesOrderStorage;
    }

    public SalesOrder createSalesOrder(SalesOrder salesOrder) throws Exception {
        if (salesOrder == null) {
            throw new IllegalArgumentException("SalesOrder is mandatory");
        }
        return this.salesOrderStorage.createSalesOrder(salesOrder);
    }

    public SalesOrder updateSalesOrder(SalesOrder SalesOrder2, String username) throws Exception {
        if (SalesOrder2 == null) {
            throw new IllegalArgumentException("SalesOrder is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new IllegalArgumentException("username is mandatory");
        }
        Long SalesOrderId = SalesOrder2.getId();
        if (SalesOrderId == null) {
            throw new EntityNotFoundException("SalesOrder with null id wasn't found");
        }
        SalesOrder storedSalesOrder = this.salesOrderStorage.getSalesOrderById(SalesOrderId);
        if (storedSalesOrder == null) {
            throw new EntityNotFoundException("SalesOrder with id " + SalesOrderId + " wasn't found");
        }
        return this.salesOrderStorage.updateSalesOrder(SalesOrder2);
    }

    public void deleteSalesOrder(Long salesOrderId, String username) throws EntityNotFoundException, IllegalAccessException {
        if (salesOrderId == null || salesOrderId <= 0L) {
            throw new IllegalArgumentException("SalesOrderId must be a positive integer");
        }
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new IllegalArgumentException("username is mandatory");
        }
        SalesOrder storedSalesOrder = this.salesOrderStorage.getSalesOrderById(salesOrderId);
        if (storedSalesOrder == null) {
            throw new EntityNotFoundException("SalesOrder with id " + salesOrderId + " not found");
        }
        this.salesOrderStorage.deleteSalesOrder(salesOrderId);
    }

    public List<SalesOrder> getSalesOrdersList() {
        return this.salesOrderStorage.getSalesOrders();
    }

    public List<SalesOrder> getSalesOrderByClienId(Long clientId) {
        return this.salesOrderStorage.getSalesOrderByClienId(clientId);
    }
}

