/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityNotFoundException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.service.rest.Util;
import org.exoplatform.timetracker.dto.Team;
import org.exoplatform.timetracker.dto.TeamMember;
import org.exoplatform.timetracker.service.TeamService;

@Path(value="timetracker/teamsmgn")
@RolesAllowed(value={"users"})
@Api(value="/timetracker", description="Manage and access Teams")
public class TeamManagementREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(TeamManagementREST.class);
    private final String portalContainerName = "portal";
    private final TeamService teamService;

    public TeamManagementREST(TeamService teamService, PortalContainer container) {
        this.teamService = teamService;
    }

    @GET
    @Path(value="team")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieves all available subresources of current endpoint", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error")})
    public Response getTeams() {
        try {
            Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
            if (sourceIdentity == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            return Response.ok(this.teamService.getTeamsList(this.getCurrentUserName())).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while getting Teams", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="team/all")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieves all available subresources of current endpoint", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error")})
    public Response getAll() {
        try {
            Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
            if (sourceIdentity == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            return Response.ok(this.teamService.getTeams()).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while getting Teams", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="team")
    @RolesAllowed(value={"administrators"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Creates a new Team", httpMethod="POST", response=Response.class, notes="empty response")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response createTeam(@ApiParam(value="Team to save", required=true) Team team) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.teamService.createTeam(team);
        }
        catch (EntityExistsException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while creating Team", (Throwable)e);
            return Response.serverError().build();
        }
        LOG.info("service=time-tracker operation=add-team parameters=\"user_social_id:{}\"", new Object[]{sourceIdentity.getId()});
        return Response.noContent().build();
    }

    @PUT
    @Path(value="team")
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Updates an existing Team identified by its id", httpMethod="PUT", response=Response.class, notes="empty response")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateTeam(@ApiParam(value="Team to update", required=true) Team team) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.teamService.updateTeam(team);
        }
        catch (IllegalAccessException e) {
            LOG.warn((Object)e);
            return Response.status((int)401).build();
        }
        catch (EntityExistsException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while updating Team", (Throwable)e);
            return Response.serverError().build();
        }
        LOG.info("service=time-tracker operation=update-team parameters=\"user_social_id:{}\"", new Object[]{sourceIdentity.getId()});
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="team")
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Deletes an existing Team identified by its id", httpMethod="DELETE", response=Response.class, notes="empty response")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteTeam(@ApiParam(value="Team technical id to delete", required=true) @QueryParam(value="teamId") String teamId) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.teamService.deleteTeam(teamId);
        }
        catch (IllegalAccessException e) {
            LOG.warn((Object)e);
            return Response.status((int)401).build();
        }
        catch (EntityNotFoundException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while deleting Team", (Throwable)e);
            return Response.serverError().build();
        }
        LOG.info("service=time-tracker operation=delete-team parameters=\"user_social_id:{}\"", new Object[]{sourceIdentity.getId()});
        return Response.noContent().build();
    }

    @GET
    @Path(value="teamMember")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieves all available subresources of current endpoint", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error")})
    public Response getTeamMembers(@ApiParam(value="Team technical id", required=true) @QueryParam(value="teamId") String teamId) {
        try {
            Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
            if (sourceIdentity == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            return Response.ok(this.teamService.getMembersList(teamId)).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while getting TeamMembers", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="teamMember")
    @RolesAllowed(value={"administrators"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Creates a new TeamMember", httpMethod="POST", response=Response.class, notes="empty response")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response createTeamMember(@ApiParam(value="TeamMember to save", required=true) TeamMember teamMember) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.teamService.createTeamMember(teamMember);
        }
        catch (EntityExistsException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while creating TeamMember", (Throwable)e);
            return Response.serverError().build();
        }
        LOG.info("service=time-tracker operation=add-team-member parameters=\"user_social_id:{}\"", new Object[]{sourceIdentity.getId()});
        return Response.noContent().build();
    }

    @POST
    @Path(value="teamMember/all")
    @RolesAllowed(value={"administrators"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Creates a new TeamMember", httpMethod="POST", response=Response.class, notes="empty response")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response createAllTeamMember(@ApiParam(value="TeamMember to save", required=true) List<TeamMember> teamMembers) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            for (TeamMember teamMember : teamMembers) {
                this.teamService.createTeamMember(teamMember);
                LOG.info("service=time-tracker operation=add-team-member parameters=\"user_social_id:{}\"", new Object[]{sourceIdentity.getId()});
            }
        }
        catch (EntityExistsException e) {
            LOG.warn((Object)e);
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while creating TeamMember", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="teamMember")
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Deletes an existing TeamMember identified by its id", httpMethod="DELETE", response=Response.class, notes="empty response")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteTeamMember(@ApiParam(value="TeamMember technical id to delete", required=true) @QueryParam(value="teamMemberId") String teamMemberId) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.teamService.deleteTeamMember(teamMemberId);
        }
        catch (IllegalAccessException e) {
            LOG.warn((Object)e);
            return Response.status((int)401).build();
        }
        catch (EntityNotFoundException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while deleting TeamMember", (Throwable)e);
            return Response.serverError().build();
        }
        LOG.info("service=time-tracker operation=delete-team-member parameters=\"user_social_id:{}\"", new Object[]{sourceIdentity.getId()});
        return Response.noContent().build();
    }

    private String getCurrentUserName() {
        ConversationState state = ConversationState.getCurrent();
        return state == null || state.getIdentity() == null ? null : state.getIdentity().getUserId();
    }
}

