/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.annotation.security.RolesAllowed;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityNotFoundException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.service.rest.Util;
import org.exoplatform.timetracker.dto.FilterModel;
import org.exoplatform.timetracker.service.FilterService;

@Path(value="timetracker/filtersmgn")
@RolesAllowed(value={"users"})
@Tag(name="/timetracker", description="Manage and access Filters")
public class FiltersManagementREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(FiltersManagementREST.class);
    private final String portalContainerName = "portal";
    private final FilterService filterService;

    public FiltersManagementREST(FilterService filterService, PortalContainer container) {
        this.filterService = filterService;
    }

    @GET
    @Path(value="filter")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieves all available subresources of current endpoint", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getFilters() {
        try {
            Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
            if (sourceIdentity == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            return Response.ok((Object)this.filterService.getFiltersList(this.getCurrentUserName()).toString()).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while getting Filters", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="filter")
    @RolesAllowed(value={"users"})
    @Consumes(value={"application/json"})
    @Operation(summary="Creates a new Filter", method="POST", description="empty response")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response createFilter(@Parameter(description="Filter to save", required=true) FilterModel filter) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.filterService.createFilter(filter, this.getCurrentUserName());
        }
        catch (EntityExistsException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while creating Filter", (Throwable)e);
            return Response.serverError().build();
        }
        LOG.info("service=time-tracker operation=add-personal-filter parameters=\"user_social_id:{}\"", new Object[]{sourceIdentity.getId()});
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="filter/{filterId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Deletes an existing Filter identified by its id", method="DELETE", description="empty response")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response deleteFilter(@Parameter(description="Filter technical id to delete", required=true) @PathParam(value="filterId") Long filterId) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.filterService.deleteFilter(filterId);
        }
        catch (IllegalAccessException e) {
            LOG.warn((Object)e);
            return Response.status((int)401).build();
        }
        catch (EntityNotFoundException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while deleting Filter", (Throwable)e);
            return Response.serverError().build();
        }
        LOG.info("service=time-tracker operation=delete-personal-filter parameters=\"user_social_id:{}\"", new Object[]{sourceIdentity.getId()});
        return Response.noContent().build();
    }

    private String getCurrentUserName() {
        ConversationState state = ConversationState.getCurrent();
        return state == null || state.getIdentity() == null ? null : state.getIdentity().getUserId();
    }
}

