/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.service;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.exoplatform.timetracker.dto.Feature;
import org.exoplatform.timetracker.service.FeatureService;
import org.exoplatform.timetracker.storage.FeatureStorage;
import org.junit.Before;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class FeatureServiceTest
extends TestCase {
    private FeatureService featureService;
    private FeatureStorage featureStorage;

    @Before
    public void setUp() throws Exception {
        this.featureStorage = (FeatureStorage)Mockito.mock(FeatureStorage.class);
        this.featureService = new FeatureService(this.featureStorage);
    }

    public void testCreateFeature() throws Exception {
        Feature feature = null;
        Feature newFeature = new Feature(Long.valueOf(1L), "testCode", "testLabel", "testSpec", "testExo", null);
        Mockito.when((Object)this.featureStorage.createFeature((Feature)Mockito.any())).thenReturn((Object)newFeature);
        feature = this.featureService.createFeature(newFeature);
        FeatureServiceTest.assertNotNull((Object)feature);
        ((FeatureStorage)Mockito.verify((Object)this.featureStorage, (VerificationMode)Mockito.times((int)1))).createFeature((Feature)Mockito.any());
    }

    public void testUpdateFeature() throws Exception {
        Feature newfeatureUpdated = null;
        Feature feature = new Feature(Long.valueOf(1L), "testCode", "testLabel", "testSpec", "testExo", null);
        Feature featureUpdated = new Feature(Long.valueOf(1L), "testCodeUpdated", "testLabelUpdated", "testSpecUpdated", "testExoUpdated", null);
        Mockito.when((Object)this.featureStorage.getFeatureById(Mockito.anyLong())).thenReturn((Object)feature);
        Mockito.when((Object)this.featureStorage.updateFeature(feature)).thenReturn((Object)featureUpdated);
        newfeatureUpdated = this.featureService.updateFeature(feature, "root");
        FeatureServiceTest.assertEquals((String)newfeatureUpdated.getCode(), (String)"testCodeUpdated");
        FeatureServiceTest.assertEquals((String)newfeatureUpdated.getLabel(), (String)"testLabelUpdated");
        FeatureServiceTest.assertEquals((String)newfeatureUpdated.getSpec(), (String)"testSpecUpdated");
        FeatureServiceTest.assertEquals((String)newfeatureUpdated.getExo(), (String)"testExoUpdated");
        FeatureServiceTest.assertEquals((long)newfeatureUpdated.getId(), (long)1L);
        ((FeatureStorage)Mockito.verify((Object)this.featureStorage, (VerificationMode)Mockito.times((int)1))).updateFeature((Feature)Mockito.any());
        ((FeatureStorage)Mockito.verify((Object)this.featureStorage, (VerificationMode)Mockito.times((int)1))).getFeatureById(Mockito.anyLong());
    }

    public void testDeleteFeature() throws Exception {
        Feature feature = new Feature(Long.valueOf(1L), "testCode", "testLabel", "testSpec", "testExo", null);
        ((FeatureStorage)Mockito.doNothing().when((Object)this.featureStorage)).deleteFeature(feature.getId().longValue());
        Mockito.when((Object)this.featureStorage.getFeatureById(feature.getId().longValue())).thenReturn((Object)feature);
        this.featureService.deleteFeature(feature.getId(), "root");
        ((FeatureStorage)Mockito.verify((Object)this.featureStorage, (VerificationMode)Mockito.times((int)1))).deleteFeature(Mockito.anyLong());
        ((FeatureStorage)Mockito.verify((Object)this.featureStorage, (VerificationMode)Mockito.times((int)1))).getFeatureById(Mockito.anyLong());
    }

    public void testGetFeaturesList() {
        Feature feature = new Feature(Long.valueOf(1L), "testCode", "testLabel", "testSpec", "testExo", null);
        Feature feature1 = new Feature(Long.valueOf(2L), "testCode1", "testLabel1", "testSpec1", "testExo1", null);
        Feature feature2 = new Feature(Long.valueOf(3L), "testCode2", "testLabel2", "testSpec2", "testExo2", null);
        Feature feature3 = new Feature(Long.valueOf(4L), "testCode3", "testLabel3", "testSpec3", "testExo3", null);
        ArrayList<Feature> features = new ArrayList<Feature>();
        features.add(feature);
        features.add(feature1);
        features.add(feature2);
        features.add(feature3);
        Mockito.when((Object)this.featureStorage.getFeatures()).thenReturn(features);
        List featuresList = this.featureStorage.getFeatures();
        FeatureServiceTest.assertEquals((int)4, (int)featuresList.size());
        ((FeatureStorage)Mockito.verify((Object)this.featureStorage, (VerificationMode)Mockito.times((int)1))).getFeatures();
    }
}

