/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.service;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.exoplatform.timetracker.dto.Filter;
import org.exoplatform.timetracker.dto.FilterField;
import org.exoplatform.timetracker.dto.FilterModel;
import org.exoplatform.timetracker.service.FilterService;
import org.exoplatform.timetracker.storage.FilterStorage;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Before;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class FilterServiceTest
extends TestCase {
    private FilterService filterService;
    private FilterStorage filterStorage;

    @Before
    public void setUp() throws Exception {
        this.filterStorage = (FilterStorage)Mockito.mock(FilterStorage.class);
        this.filterService = new FilterService(this.filterStorage);
    }

    public void testCreateFilter() throws Exception {
        Filter filter = new Filter(Long.valueOf(1L), "testName", "root");
        FilterField filterField = new FilterField(Long.valueOf(1L), "test", new String[]{"test"}, filter);
        ArrayList<FilterField> filterFields = new ArrayList<FilterField>();
        filterFields.add(filterField);
        FilterModel filterModel = new FilterModel(filter, filterFields);
        Mockito.when((Object)this.filterStorage.createFilter(filter)).thenReturn((Object)filter);
        Mockito.when((Object)this.filterStorage.createFilterField(filterField)).thenReturn((Object)filterField);
        FilterModel newFilterModel = null;
        newFilterModel = this.filterService.createFilter(filterModel, "root");
        FilterServiceTest.assertNotNull((Object)newFilterModel);
        ((FilterStorage)Mockito.verify((Object)this.filterStorage, (VerificationMode)Mockito.times((int)1))).createFilter((Filter)Matchers.any());
        ((FilterStorage)Mockito.verify((Object)this.filterStorage, (VerificationMode)Mockito.times((int)1))).createFilterField((FilterField)Matchers.any());
    }

    public void testDeleteFilter() throws IllegalAccessException {
        Filter storedFilter = new Filter(Long.valueOf(1L), "testName", "root");
        Mockito.when((Object)this.filterStorage.getFilterById(1L)).thenReturn((Object)storedFilter);
        ((FilterStorage)Mockito.doNothing().when((Object)this.filterStorage)).deleteAllFilterFieldsByFilter(Mockito.anyLong());
        ((FilterStorage)Mockito.doNothing().when((Object)this.filterStorage)).deleteFilter(Mockito.anyLong());
        this.filterService.deleteFilter(Long.valueOf(1L));
        ((FilterStorage)Mockito.verify((Object)this.filterStorage, (VerificationMode)Mockito.times((int)1))).getFilterById(Mockito.anyLong());
        ((FilterStorage)Mockito.verify((Object)this.filterStorage, (VerificationMode)Mockito.times((int)1))).deleteFilter(Mockito.anyLong());
        ((FilterStorage)Mockito.verify((Object)this.filterStorage, (VerificationMode)Mockito.times((int)1))).deleteAllFilterFieldsByFilter(Mockito.anyLong());
    }

    public void testGetFiltersList() {
        JSONArray filterModels = new JSONArray();
        Filter filter = new Filter(Long.valueOf(1L), "testName", "root");
        Filter filter1 = new Filter(Long.valueOf(2L), "testName1", "root");
        Filter filter2 = new Filter(Long.valueOf(3L), "testName2", "root");
        Filter filter3 = new Filter(Long.valueOf(4L), "testName3", "root");
        ArrayList<Filter> filters = new ArrayList<Filter>();
        filters.add(filter);
        filters.add(filter1);
        filters.add(filter2);
        filters.add(filter3);
        Mockito.when((Object)this.filterStorage.getFiltersByUserName("root")).thenReturn(filters);
        filterModels = this.filterService.getFiltersList("root");
        FilterServiceTest.assertEquals((int)filterModels.length(), (int)4);
        ((FilterStorage)Mockito.verify((Object)this.filterStorage, (VerificationMode)Mockito.times((int)1))).getFiltersByUserName((String)Matchers.any());
    }

    public void testGetFields() {
        JSONObject fieldsJson = new JSONObject();
        Filter filter = new Filter(Long.valueOf(1L), "testName", "root");
        Filter filter1 = new Filter(Long.valueOf(2L), "testName1", "root");
        Filter filter2 = new Filter(Long.valueOf(3L), "testName2", "root");
        FilterField filterField = new FilterField(Long.valueOf(1L), "test", new String[]{"test"}, filter);
        FilterField filterField1 = new FilterField(Long.valueOf(2L), "test1", new String[]{"test1"}, filter1);
        FilterField filterField2 = new FilterField(Long.valueOf(3L), "test2", new String[]{"test2"}, filter2);
        ArrayList<FilterField> fieldsList = new ArrayList<FilterField>();
        fieldsList.add(filterField);
        fieldsList.add(filterField1);
        fieldsList.add(filterField2);
        Mockito.when((Object)this.filterStorage.getFilterFieldsByFilter(1L)).thenReturn(fieldsList);
        fieldsJson = this.filterService.getFields(1L);
        FilterServiceTest.assertNotNull((Object)fieldsJson);
        ((FilterStorage)Mockito.verify((Object)this.filterStorage, (VerificationMode)Mockito.times((int)1))).getFilterFieldsByFilter(Mockito.anyLong());
    }
}

