/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.migration.dlp;

import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class AdminDlpQuarantinePageMigration
extends UpgradeProductPlugin {
    private static final String ADMINISTRATOR_GROUP = "/platform/administrators";
    private static final String DLP_QUARANTINE = "dlp-quarantine";
    private static final Log LOG = ExoLogger.getExoLogger(AdminDlpQuarantinePageMigration.class);
    private NavigationService navigationService;
    private PageService pageService;

    public AdminDlpQuarantinePageMigration(InitParams initParams, NavigationService navigationService, PageService pageService) {
        super(initParams);
        this.navigationService = navigationService;
        this.pageService = pageService;
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        NavigationContext administratorsNavigation = this.navigationService.loadNavigation(SiteKey.group((String)ADMINISTRATOR_GROUP));
        if (administratorsNavigation != null) {
            long startupTime = System.currentTimeMillis();
            LOG.info((Object)"Start upgrade of admin dlp quarantine page");
            NodeContext administratorsNodeContext = this.navigationService.loadNode(NodeModel.SELF_MODEL, administratorsNavigation, Scope.ALL, null);
            if (administratorsNodeContext.get(DLP_QUARANTINE) != null) {
                administratorsNodeContext.removeNode(DLP_QUARANTINE);
                this.navigationService.saveNavigation(administratorsNavigation);
                this.navigationService.saveNode(administratorsNodeContext, null);
                String dlpQuarantinePageKey = PortalConfig.GROUP_TYPE + "::/platform/administrators::dlp-quarantine";
                this.pageService.destroyPage(PageKey.parse((String)dlpQuarantinePageKey));
            }
            LOG.info("End upgrade of admin dlp quarantine page. It took {} ms", new Object[]{System.currentTimeMillis() - startupTime});
        }
    }
}

