/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.upgrade.templates;

import java.util.HashSet;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Workspace;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.commons.info.ProductInformations;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.ecms.upgrade.templates.WCMTemplateUpgradePlugin;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.views.ApplicationTemplateManagerService;
import org.exoplatform.services.cms.views.impl.ApplicationTemplateManagerServiceImpl;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.junit.AfterClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class WCMTemplateUpgradePluginTest {
    private static final MockedStatic<Utils> UTILS = Mockito.mockStatic(Utils.class);
    @Mock
    ApplicationTemplateManagerServiceImpl applicationTemplateManagerService;
    @Mock
    ProductInformations productInformations;
    @Mock
    ExtendedSession session;
    @Mock
    NodeIterator nodeIterator;
    @Mock
    QueryManager queryManager;

    @AfterClass
    public static void afterRunBare() throws Exception {
        UTILS.close();
    }

    @Test
    public void testWCMTemplateMigration() throws Exception {
        InitParams initParams = new InitParams();
        ValueParam valueParam = new ValueParam();
        valueParam.setName("product.group.id");
        valueParam.setValue("org.exoplatform.ecms");
        initParams.addParameter((Parameter)valueParam);
        Node templateHomeNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)this.applicationTemplateManagerService.getApplicationTemplateHome((String)ArgumentMatchers.any(), (SessionProvider)ArgumentMatchers.any())).thenReturn((Object)templateHomeNode);
        Mockito.when((Object)templateHomeNode.getPath()).thenReturn((Object)"/templateHomeNodePath");
        HashSet<String> configuredTemplates = new HashSet<String>();
        configuredTemplates.add("template1");
        configuredTemplates.add("template2");
        configuredTemplates.add("template3");
        Mockito.when((Object)this.applicationTemplateManagerService.getConfiguredAppTemplateMap((String)ArgumentMatchers.any())).thenReturn(configuredTemplates);
        Mockito.when((Object)templateHomeNode.getSession()).thenReturn((Object)this.session);
        Workspace workspace = (Workspace)Mockito.mock(Workspace.class);
        Mockito.when((Object)this.session.getWorkspace()).thenReturn((Object)workspace);
        Mockito.when((Object)workspace.getQueryManager()).thenReturn((Object)this.queryManager);
        Query query = (Query)Mockito.mock(Query.class);
        Mockito.when((Object)this.queryManager.createQuery(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)query);
        QueryResult queryResult = (QueryResult)Mockito.mock(QueryResult.class);
        Mockito.when((Object)query.execute()).thenReturn((Object)queryResult);
        Mockito.when((Object)queryResult.getNodes()).thenReturn((Object)this.nodeIterator);
        Mockito.when((Object)this.nodeIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, false});
        Node templateNode1 = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)templateNode1.getName()).thenReturn((Object)"template1");
        Mockito.when((Object)templateNode1.getPath()).thenReturn((Object)"/templateHomeNodePath/template1");
        Node templateNode2 = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)templateNode2.getName()).thenReturn((Object)"template2");
        Mockito.when((Object)templateNode2.getPath()).thenReturn((Object)"/templateHomeNodePath/template2");
        Node templateNode3 = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)templateNode3.getName()).thenReturn((Object)"template3");
        Mockito.when((Object)templateNode3.getPath()).thenReturn((Object)"/templateHomeNodePath/template3");
        Mockito.when((Object)this.nodeIterator.nextNode()).thenReturn((Object)templateNode1).thenReturn((Object)templateNode2).thenReturn((Object)templateNode3);
        WCMTemplateUpgradePlugin wcmTemplateUpgradePlugin = new WCMTemplateUpgradePlugin((ApplicationTemplateManagerService)this.applicationTemplateManagerService, initParams);
        wcmTemplateUpgradePlugin.processUpgrade(null, null);
        ((Node)Mockito.verify((Object)templateHomeNode, (VerificationMode)Mockito.times((int)3))).save();
        ((ApplicationTemplateManagerServiceImpl)Mockito.verify((Object)this.applicationTemplateManagerService, (VerificationMode)Mockito.times((int)1))).start();
    }
}

