/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.upgrade;

import javax.jcr.Item;
import javax.jcr.Session;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.jcr.upgrade.MoveNodesUpgradePlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.social.core.space.SpaceListAccess;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class MoveNodesUpgradePluginTest {
    @Mock
    private RepositoryService repositoryService;
    @Mock
    private SessionProviderService sessionProviderService;
    @Mock
    private ManageableRepository repository;
    @Mock
    private RepositoryEntry repositoryEntry;
    @Mock
    private SessionProvider sessionProvider;
    @Mock
    private Session session;
    @Mock
    private SpaceService spaceService;

    @Before
    public void setUp() throws Exception {
        Mockito.lenient().when((Object)this.sessionProviderService.getSystemSessionProvider(ArgumentMatchers.any())).thenReturn((Object)this.sessionProvider);
        Mockito.lenient().when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)this.repository);
        Mockito.lenient().when((Object)this.repository.getConfiguration()).thenReturn((Object)this.repositoryEntry);
        Mockito.lenient().when((Object)this.repositoryEntry.getDefaultWorkspaceName()).thenReturn((Object)"collaboration");
        Item node = (Item)Mockito.mock(Item.class);
        Mockito.when((Object)this.session.getItem(ArgumentMatchers.anyString())).thenReturn((Object)node);
        Mockito.lenient().when((Object)this.sessionProvider.getSession((String)ArgumentMatchers.any(), (ManageableRepository)ArgumentMatchers.any(ManageableRepository.class))).thenReturn((Object)this.session);
    }

    @Test
    public void testMoveFoldersUpgrade() throws Exception {
        InitParams initParams = new InitParams();
        ValueParam valueParam = new ValueParam();
        valueParam.setName("product.group.id");
        valueParam.setValue("org.exoplatform.platform");
        initParams.addParameter((Parameter)valueParam);
        MoveNodesUpgradePlugin plugin = new MoveNodesUpgradePlugin(initParams, this.spaceService, this.repositoryService, this.sessionProviderService);
        plugin.processUpgrade(null, null);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.never())).move(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
        ValueParam valueParam1 = new ValueParam();
        valueParam1.setName("origin-folder-path");
        valueParam1.setValue("/Documents/News");
        initParams.addParameter((Parameter)valueParam1);
        ValueParam valueParam2 = new ValueParam();
        valueParam2.setName("destination-folder-path");
        valueParam2.setValue("/");
        initParams.addParameter((Parameter)valueParam2);
        Space space1 = new Space();
        space1.setGroupId("/spaces/spaceOne");
        Space space2 = new Space();
        space2.setGroupId("/spaces/spaceTw");
        ListAccess spaces = (ListAccess)Mockito.mock(SpaceListAccess.class);
        Mockito.when((Object)((Space[])spaces.load(Mockito.anyInt(), Mockito.anyInt()))).thenReturn((Object)new Space[]{space1, space2});
        Mockito.when((Object)this.spaceService.getAllSpacesWithListAccess()).thenReturn((Object)spaces);
        plugin = new MoveNodesUpgradePlugin(initParams, this.spaceService, this.repositoryService, this.sessionProviderService);
        plugin.processUpgrade(null, null);
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)2))).move(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
    }
}

