/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.migration;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class PortalNavigationIconMigration
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getExoLogger(PortalNavigationIconMigration.class);
    private static final String ICON_UPDATE_SQL = "  UPDATE PORTAL_NAVIGATION_NODES\n  SET ICON =\n    CASE\n      %s\n    END\n  WHERE ICON IS NULL\n  AND EXISTS (SELECT * FROM PORTAL_PAGES p INNER JOIN PORTAL_SITES s ON s.ID = p.SITE_ID WHERE PAGE_ID = p.ID AND s.TYPE = 0 AND s.NAME LIKE 'dw')\n";
    private static final String ICON_UPDATE_CASE_SQL = "   WHEN NAME in (%s) THEN TRIM('%s')\n";
    private static final String PORTAL_NODE_NAMES = "portal.node.names";
    private static final String PORTAL_NODE_ICONS = "portal.node.icons";
    private final EntityManagerService entityManagerService;
    private final Map<String, String> portalNodes = new HashMap<String, String>();
    private int migratedPortalNodeIcons;

    public PortalNavigationIconMigration(EntityManagerService entityManagerService, InitParams initParams) {
        super(initParams);
        this.entityManagerService = entityManagerService;
        if (initParams.containsKey((Object)PORTAL_NODE_ICONS) && initParams.containsKey((Object)PORTAL_NODE_NAMES)) {
            String[] portalNodeNames = initParams.getValueParam(PORTAL_NODE_NAMES).getValue().split(";");
            String[] portalNodeIcons = initParams.getValueParam(PORTAL_NODE_ICONS).getValue().split(";");
            if (portalNodeIcons.length == portalNodeNames.length) {
                for (int i = 0; i < portalNodeNames.length; ++i) {
                    this.portalNodes.put(portalNodeNames[i], portalNodeIcons[i]);
                }
            }
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return !this.portalNodes.isEmpty();
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        long startupTime = System.currentTimeMillis();
        LOG.info((Object)"Start:: Upgrade of portal navigation node icons");
        Set<Map.Entry<String, String>> portalNodesEntrySet = this.portalNodes.entrySet();
        this.migratedPortalNodeIcons = this.upgradePortalNodeIcons(portalNodesEntrySet);
        LOG.info("End:: Upgrade of '{}' node icons. It tooks {} ms", new Object[]{this.migratedPortalNodeIcons, System.currentTimeMillis() - startupTime});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int upgradePortalNodeIcons(Set<Map.Entry<String, String>> portalNodesEntrySet) {
        PortalContainer container = PortalContainer.getInstance();
        RequestLifeCycle.begin((ExoContainer)container);
        EntityManager entityManager = this.entityManagerService.getEntityManager();
        boolean transactionStarted = false;
        try {
            if (!entityManager.getTransaction().isActive()) {
                entityManager.getTransaction().begin();
                transactionStarted = true;
            }
            String sqlStatement = String.format(ICON_UPDATE_SQL, this.portalNodes.entrySet().stream().map(e -> {
                String keys = Arrays.stream(((String)e.getKey()).split(",")).map(key -> String.format("'%s'", key)).collect(Collectors.joining(","));
                return String.format(ICON_UPDATE_CASE_SQL, keys, e.getValue());
            }).collect(Collectors.joining()));
            Query query = entityManager.createNativeQuery(sqlStatement);
            int updatedIcons = query.executeUpdate();
            if (transactionStarted && entityManager.getTransaction().isActive()) {
                entityManager.getTransaction().commit();
            }
            int n = updatedIcons;
            return n;
        }
        catch (Exception exception) {
            if (transactionStarted && entityManager.getTransaction().isActive() && entityManager.getTransaction().getRollbackOnly()) {
                entityManager.getTransaction().rollback();
            }
            int n = 0;
            return n;
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public int getMigratedPortalNodeIconsNodeIcons() {
        return this.migratedPortalNodeIcons;
    }
}

