/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.upgrade.activities;

import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;

public class SharedNewsActivitiesUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log log = ExoLogger.getLogger((String)SharedNewsActivitiesUpgradePlugin.class.getName());
    private final RepositoryService repositoryService;
    private static final String COLLABORATION_WS = "collaboration";
    private final ActivityManager activityManager;
    private int sharedNewsActivitiesCount;

    public SharedNewsActivitiesUpgradePlugin(InitParams initParams, RepositoryService repositoryService, ActivityManager activityManager) {
        super(initParams);
        this.repositoryService = repositoryService;
        this.activityManager = activityManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        long startupTime = System.currentTimeMillis();
        log.info((Object)"Start upgrading old shared news activities");
        try (SessionProvider sessionProvider = null;){
            sessionProvider = SessionProvider.createSystemProvider();
            Session session = sessionProvider.getSession(COLLABORATION_WS, this.repositoryService.getCurrentRepository());
            QueryManager qm = session.getWorkspace().getQueryManager();
            Query q = qm.createQuery("select * from exo:news WHERE publication:currentState = 'published' AND jcr:path LIKE '/Groups/spaces/%'", "sql");
            NodeIterator nodeIterator = q.execute().getNodes();
            if (nodeIterator != null) {
                while (nodeIterator.hasNext()) {
                    Node newsNode = nodeIterator.nextNode();
                    String[] newsActivities = newsNode.getProperty("exo:activities").getString().split(";");
                    String newsActivityId = newsActivities[0].split(":")[1];
                    for (int i = 1; i < newsActivities.length; ++i) {
                        String sharedNewsActivityId = newsActivities[i].split(":")[1];
                        ExoSocialActivity sharedNewsActivity = this.activityManager.getActivity(sharedNewsActivityId);
                        Map sharedNewsActivityTemplateParams = sharedNewsActivity.getTemplateParams();
                        if (sharedNewsActivityTemplateParams.get("originalActivityId") != null) continue;
                        sharedNewsActivityTemplateParams.put("originalActivityId", newsActivityId);
                        sharedNewsActivity.setTemplateParams(sharedNewsActivityTemplateParams);
                        this.activityManager.updateActivity(sharedNewsActivity);
                        ++this.sharedNewsActivitiesCount;
                    }
                }
            }
            log.info("End upgrading of '{}' old shared news activities. It took {} ms", new Object[]{this.sharedNewsActivitiesCount, System.currentTimeMillis() - startupTime});
        }
    }

    public int getSharedNewsActivitiesCount() {
        return this.sharedNewsActivitiesCount;
    }
}

