/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.upgrade.targets;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.HashMap;
import java.util.LinkedList;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.news.model.News;
import org.exoplatform.news.service.NewsService;
import org.exoplatform.news.upgrade.targets.PublishedNewsDisplayedPropUpgrade;
import org.exoplatform.social.core.jpa.storage.entity.MetadataEntity;
import org.exoplatform.social.core.jpa.storage.entity.MetadataItemEntity;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.Metadata;
import org.exoplatform.social.metadata.model.MetadataType;
import org.hibernate.Transaction;
import org.jgroups.util.Util;
import org.junit.AfterClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class PublishedNewsDisplayedPropUpgradeTest {
    private static final MockedStatic<ExoContainerContext> EXO_CONTAINER_CONTEXT = Mockito.mockStatic(ExoContainerContext.class);
    private static final MockedStatic<PortalContainer> PORTAL_CONTAINER = Mockito.mockStatic(PortalContainer.class);
    private static final MockedStatic<RequestLifeCycle> REQUEST_LIFECYCLE = Mockito.mockStatic(RequestLifeCycle.class);
    @Mock
    private EntityManagerService entityManagerService;
    @Mock
    private NewsService newsService;
    @Mock
    private MetadataService metadataService;
    @Mock
    private EntityManager entityManager;

    @AfterClass
    public static void afterRunBare() throws Exception {
        EXO_CONTAINER_CONTEXT.close();
        PORTAL_CONTAINER.close();
        REQUEST_LIFECYCLE.close();
    }

    @Test
    public void processUpgrade() throws Exception {
        InitParams initParams = new InitParams();
        ValueParam valueParam = new ValueParam();
        valueParam.setName("product.group.id");
        valueParam.setValue("org.exoplatform.platform");
        initParams.addParameter((Parameter)valueParam);
        MetadataType metadataType = new MetadataType(4L, "newsTarget");
        LinkedList<Metadata> newsTargets = new LinkedList<Metadata>();
        Metadata sliderNews = new Metadata();
        sliderNews.setName("sliderNews");
        sliderNews.setCreatedDate(100L);
        HashMap<String, String> sliderNewsProperties = new HashMap<String, String>();
        sliderNewsProperties.put("label", "slider news");
        sliderNews.setProperties(sliderNewsProperties);
        sliderNews.setId(1L);
        newsTargets.add(sliderNews);
        MetadataEntity metadataEntity = new MetadataEntity();
        metadataEntity.setCreatorId(1L);
        metadataEntity.setId(Long.valueOf(1L));
        metadataEntity.setProperties(sliderNewsProperties);
        metadataEntity.setAudienceId(0L);
        MetadataItemEntity metadataItemEntity = new MetadataItemEntity();
        metadataItemEntity.setCreatorId(1L);
        metadataItemEntity.setId(Long.valueOf(1L));
        metadataItemEntity.setObjectId("1");
        metadataItemEntity.setMetadata(metadataEntity);
        LinkedList<MetadataItemEntity> metadataItemEntities = new LinkedList<MetadataItemEntity>();
        metadataItemEntities.add(metadataItemEntity);
        News news = new News();
        news.setId("1");
        news.setArchived(false);
        news.setPublicationState("published");
        Transaction transaction = (Transaction)Mockito.mock(Transaction.class);
        PortalContainer container = (PortalContainer)Mockito.mock(PortalContainer.class);
        Query deleteQuery = (Query)Mockito.mock(Query.class);
        Query insertQuery = (Query)Mockito.mock(Query.class);
        Query getQuery = (Query)Mockito.mock(Query.class);
        EXO_CONTAINER_CONTEXT.when(() -> ExoContainerContext.getCurrentContainer()).thenReturn((Object)container);
        EXO_CONTAINER_CONTEXT.when(() -> ExoContainerContext.getService(EntityManagerService.class)).thenReturn((Object)this.entityManagerService);
        Mockito.when((Object)((EntityManagerService)container.getComponentInstanceOfType(EntityManagerService.class))).thenReturn((Object)this.entityManagerService);
        Mockito.when((Object)this.entityManagerService.getEntityManager()).thenReturn((Object)this.entityManager);
        Mockito.when((Object)this.entityManager.getTransaction()).thenReturn((Object)transaction);
        Mockito.when((Object)transaction.isActive()).thenReturn((Object)true);
        ((Transaction)Mockito.doNothing().when((Object)transaction)).begin();
        Mockito.when((Object)this.metadataService.getMetadatas(metadataType.getName(), 0L)).thenReturn(newsTargets);
        Mockito.when((Object)this.newsService.getNewsById("1", false)).thenReturn((Object)news);
        Mockito.when((Object)this.entityManager.createNativeQuery("DELETE FROM SOC_METADATA_ITEMS_PROPERTIES WHERE METADATA_ITEM_ID = :newsTargetsMetadataItemId AND (NAME = :stagedStatus OR NAME = :displayedStatus)", MetadataItemEntity.class)).thenReturn((Object)deleteQuery);
        Mockito.when((Object)deleteQuery.executeUpdate()).thenReturn((Object)1);
        Mockito.when((Object)this.entityManager.createNativeQuery("INSERT INTO SOC_METADATA_ITEMS_PROPERTIES(METADATA_ITEM_ID, NAME, VALUE) VALUES(:newsTargetsMetadataItemId, :displayedStatus, :displayed)", MetadataItemEntity.class)).thenReturn((Object)insertQuery);
        Mockito.when((Object)insertQuery.executeUpdate()).thenReturn((Object)1);
        Mockito.when((Object)this.entityManager.createNativeQuery("SELECT * FROM SOC_METADATA_ITEMS WHERE METADATA_ID IN :newsTargetMetadatas", MetadataItemEntity.class)).thenReturn((Object)getQuery);
        Mockito.when((Object)getQuery.getResultList()).thenReturn(metadataItemEntities);
        PublishedNewsDisplayedPropUpgrade publishedNewsDisplayedPropUpgradePlugin = new PublishedNewsDisplayedPropUpgrade(initParams, this.entityManagerService, this.newsService, this.metadataService);
        publishedNewsDisplayedPropUpgradePlugin.processUpgrade(null, null);
        Util.assertEquals((Object)1, (Object)publishedNewsDisplayedPropUpgradePlugin.getMigratedPublishedNewsCount());
    }
}

