/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.upgrade;

import io.meeds.content.news.model.News;
import io.meeds.content.news.service.NewsService;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.Arrays;
import java.util.List;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.upgrade.UpgradePluginExecutionContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.news.upgrade.ContentDraftArticlesUpgrade;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataKey;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.wiki.model.DraftPage;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.service.NoteService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ContentDraftArticlesUpgradeTest {
    @Mock
    private ActivityManager activityManager;
    @Mock
    private IdentityManager identityManager;
    @Mock
    private NoteService noteService;
    @Mock
    private NewsService newsService;
    @Mock
    private SpaceService spaceService;
    @Mock
    private SettingService settingService;
    @Mock
    private MetadataService metadataService;
    @Mock
    private EntityManagerService entityManagerService;
    private ContentDraftArticlesUpgrade contentDraftArticlesUpgrade;

    @Before
    public void setUp() {
        InitParams initParams = new InitParams();
        ValueParam valueParam1 = new ValueParam();
        valueParam1.setName("product.group.id");
        valueParam1.setValue("org.exoplatform.platform");
        ValueParam valueParam2 = new ValueParam();
        valueParam2.setName("content.inconsistent.draft.articles.upgrade");
        valueParam2.setValue("1,1;2,2");
        initParams.addParameter((Parameter)valueParam1);
        initParams.addParameter((Parameter)valueParam2);
        this.contentDraftArticlesUpgrade = new ContentDraftArticlesUpgrade(initParams, this.activityManager, this.identityManager, this.noteService, this.newsService, this.spaceService, this.settingService, this.metadataService, this.entityManagerService);
    }

    @Test
    public void testProcessUpgrade() throws Exception {
        ExoSocialActivity articleActivity = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        Mockito.when((Object)articleActivity.getPosterId()).thenReturn((Object)"1");
        Mockito.when((Object)this.activityManager.getActivity(ArgumentMatchers.anyString())).thenReturn((Object)articleActivity);
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)identity.getRemoteId()).thenReturn((Object)"root");
        Mockito.when((Object)this.identityManager.getIdentity(ArgumentMatchers.anyLong())).thenReturn((Object)identity);
        DraftPage draftPage = (DraftPage)Mockito.mock(DraftPage.class);
        Mockito.when((Object)draftPage.getWikiOwner()).thenReturn((Object)"/spaces/test");
        Mockito.when((Object)this.noteService.getDraftNoteById(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)draftPage);
        Space space = (Space)Mockito.mock(Space.class);
        Mockito.when((Object)this.spaceService.getSpaceByGroupId(ArgumentMatchers.anyString())).thenReturn((Object)space);
        Mockito.when((Object)space.getId()).thenReturn((Object)"1");
        News article = (News)Mockito.mock(News.class);
        Mockito.when((Object)this.newsService.createNewsArticlePage((News)ArgumentMatchers.any(News.class), (String)ArgumentMatchers.nullable(String.class))).thenReturn((Object)article);
        List<MetadataItem> articleMetadataItems = Arrays.asList((MetadataItem)Mockito.mock(MetadataItem.class));
        Mockito.when((Object)this.metadataService.getMetadataItemsByMetadataAndObject((MetadataKey)ArgumentMatchers.any(MetadataKey.class), (MetadataObject)ArgumentMatchers.any(MetadataObject.class))).thenReturn(articleMetadataItems);
        EntityManager entityManager = (EntityManager)Mockito.mock(EntityManager.class);
        Mockito.when((Object)this.entityManagerService.getEntityManager()).thenReturn((Object)entityManager);
        Query query = (Query)Mockito.mock(Query.class);
        Mockito.when((Object)entityManager.createNativeQuery(ArgumentMatchers.anyString())).thenReturn((Object)query);
        Page articlePage = (Page)Mockito.mock(Page.class);
        Mockito.when((Object)this.noteService.getNoteById((String)ArgumentMatchers.nullable(String.class))).thenReturn((Object)articlePage);
        this.contentDraftArticlesUpgrade.processUpgrade("1.0", "2.0");
        ((NewsService)Mockito.verify((Object)this.newsService, (VerificationMode)Mockito.times((int)2))).createNewsArticlePage((News)ArgumentMatchers.any(News.class), (String)ArgumentMatchers.nullable(String.class));
        ((MetadataService)Mockito.verify((Object)this.metadataService, (VerificationMode)Mockito.times((int)4))).updateMetadataItem((MetadataItem)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyBoolean());
        ((ActivityManager)Mockito.verify((Object)this.activityManager, (VerificationMode)Mockito.times((int)2))).updateActivity((ExoSocialActivity)ArgumentMatchers.any(ExoSocialActivity.class), ArgumentMatchers.eq((boolean)false));
        ((Query)Mockito.verify((Object)query, (VerificationMode)Mockito.times((int)2))).executeUpdate();
        ((NoteService)Mockito.verify((Object)this.noteService, (VerificationMode)Mockito.times((int)2))).updateNote((Page)ArgumentMatchers.any(Page.class));
    }

    @Test
    public void shouldProceedToUpgrade() {
        SettingValue settingValue = (SettingValue)Mockito.mock(SettingValue.class);
        UpgradePluginExecutionContext context = new UpgradePluginExecutionContext("0.9", 1);
        Mockito.when((Object)this.settingService.get((Context)ArgumentMatchers.any(), (Scope)ArgumentMatchers.any(), ArgumentMatchers.anyString())).thenReturn(null);
        this.contentDraftArticlesUpgrade.shouldProceedToUpgrade("0.9", "1.0", context);
        ((SettingService)Mockito.verify((Object)this.settingService, (VerificationMode)Mockito.times((int)1))).set((Context)ArgumentMatchers.any(), (Scope)ArgumentMatchers.any(), ArgumentMatchers.anyString(), (SettingValue)ArgumentMatchers.any());
        Mockito.reset((Object[])new SettingService[]{this.settingService});
        Mockito.when((Object)this.settingService.get((Context)ArgumentMatchers.any(), (Scope)ArgumentMatchers.any(), ArgumentMatchers.anyString())).thenReturn((Object)settingValue);
        context.setVersion("1.2");
        this.contentDraftArticlesUpgrade.shouldProceedToUpgrade("1.2", "1.0", context);
        ((SettingService)Mockito.verify((Object)this.settingService, (VerificationMode)Mockito.times((int)0))).set((Context)ArgumentMatchers.any(), (Scope)ArgumentMatchers.any(), ArgumentMatchers.anyString(), (SettingValue)ArgumentMatchers.any());
    }
}

