/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.upgrade;

import io.meeds.notes.model.NoteMetadataObject;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.metadata.MetadataFilter;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataKey;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.wiki.model.DraftPage;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.PageVersion;
import org.exoplatform.wiki.service.NoteService;

public class ContentArticlePropertiesUpgrade
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger(ContentArticlePropertiesUpgrade.class);
    private final NoteService noteService;
    private final MetadataService metadataService;
    private final IdentityManager identityManager;
    private final SpaceService spaceService;
    private final UserACL userACL;
    private final SettingService settingService;
    private static final MetadataKey NOTES_METADATA_KEY = new MetadataKey("notes", "notes", 0L);
    public static final String NEWS_METADATA_NAME = "news";
    public static final String NEWS_METADATA_DRAFT_OBJECT_TYPE = "newsDraftPage";
    public static final String NOTE_METADATA_PAGE_OBJECT_TYPE = "notePage";
    public static final String NOTE_METADATA_DRAFT_PAGE_OBJECT_TYPE = "noteDraftPage";
    public static final String NEWS_METADATA_PAGE_VERSION_OBJECT_TYPE = "newsPageVersion";
    public static final String NEWS_METADATA_LATEST_DRAFT_OBJECT_TYPE = "newsLatestDraftPage";
    public static final String CONTENT_ILLUSTRATION_ID = "illustrationId";
    public static final String SUMMARY = "summary";
    public static final String FEATURED_IMAGE_ID = "featuredImageId";
    private static final String FEATURED_IMAGE_UPDATED_DATE = "featuredImageUpdatedDate";
    private static final String ARTICLES_UPGRADE_PLUGIN_NAME = "NewsArticlesUpgradePlugin";
    private static final String ARTICLES_UPGRADE_EXECUTED_KEY = "articlesUpgradeExecuted";

    public ContentArticlePropertiesUpgrade(InitParams initParams, NoteService noteService, MetadataService metadataService, IdentityManager identityManager, SpaceService spaceService, UserACL userACL, SettingService settingService) {
        super(initParams);
        this.noteService = noteService;
        this.metadataService = metadataService;
        this.identityManager = identityManager;
        this.spaceService = spaceService;
        this.userACL = userACL;
        this.settingService = settingService;
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        long startupTime = System.currentTimeMillis();
        LOG.info((Object)"Start upgrade of content page properties");
        int processedContentPagesPropertiesCount = 0;
        int totalContentPagesPropertiesCount = 0;
        int ignoredContentPagesPropertiesCount = 0;
        try {
            MetadataFilter metadataFilter = this.getMetadataFilter();
            metadataFilter.setMetadataObjectTypes(List.of(NEWS_METADATA_PAGE_VERSION_OBJECT_TYPE, NEWS_METADATA_DRAFT_OBJECT_TYPE, NEWS_METADATA_LATEST_DRAFT_OBJECT_TYPE));
            List metadataItems = this.metadataService.getMetadataItemsByFilter(metadataFilter, 0L, 0L);
            totalContentPagesPropertiesCount = metadataItems.size();
            for (MetadataItem metadataItem : metadataItems) {
                if (metadataItem != null && !MapUtils.isEmpty((Map)metadataItem.getProperties())) {
                    Map contentProperties = metadataItem.getProperties();
                    DraftPage page = null;
                    String objectType = NOTE_METADATA_PAGE_OBJECT_TYPE;
                    if (metadataItem.getObjectType().equals(NEWS_METADATA_PAGE_VERSION_OBJECT_TYPE)) {
                        PageVersion pageVersion = this.noteService.getPageVersionById(Long.valueOf(metadataItem.getObjectId()));
                        if (pageVersion != null && pageVersion.getParent() != null) {
                            page = pageVersion.getParent();
                        }
                    } else {
                        page = this.noteService.getDraftNoteById(metadataItem.getObjectId(), this.userACL.getSuperUser());
                        objectType = NOTE_METADATA_DRAFT_PAGE_OBJECT_TYPE;
                    }
                    if (page != null && page.getAuthor() != null) {
                        NoteMetadataObject noteMetadataObject = this.buildNoteMetadataObject((Page)page, null, objectType);
                        MetadataItem noteMetadataItem = this.getNoteMetadataItem((Page)page, null, objectType);
                        if (noteMetadataItem != null) {
                            LOG.info((Object)"ContentArticlePropertiesUpgrade: Ignore : Content page properties already migrated");
                            ++ignoredContentPagesPropertiesCount;
                            continue;
                        }
                        HashMap<String, String> noteProperties = new HashMap<String, String>();
                        long creatorId = Long.parseLong(this.identityManager.getOrCreateUserIdentity(page.getAuthor()).getId());
                        if (contentProperties.getOrDefault(CONTENT_ILLUSTRATION_ID, null) != null) {
                            noteProperties.put(FEATURED_IMAGE_ID, (String)contentProperties.get(CONTENT_ILLUSTRATION_ID));
                            noteProperties.put(FEATURED_IMAGE_UPDATED_DATE, String.valueOf(new Date().getTime()));
                        }
                        noteProperties.put(SUMMARY, (String)contentProperties.get(SUMMARY));
                        this.metadataService.createMetadataItem((MetadataObject)noteMetadataObject, NOTES_METADATA_KEY, noteProperties, creatorId);
                        LOG.info("ContentArticlePropertiesUpgrade: Processed content page properties: {}/{}", new Object[]{++processedContentPagesPropertiesCount, totalContentPagesPropertiesCount});
                        continue;
                    }
                    ++ignoredContentPagesPropertiesCount;
                    LOG.warn("ContentArticlePropertiesUpgrade: Content page properties ignored due to data inconsistency: page exists: {}, page name: {}", new Object[]{"ObjectType: {}", "Page Id: {}", "Page author: {}", page != null, page != null ? page.getName() : null, objectType, page != null ? page.getId() : null, null});
                    continue;
                }
                LOG.info((Object)"ContentArticlePropertiesUpgrade: Ignore : Content page properties are empty");
                ++ignoredContentPagesPropertiesCount;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"An error occurred while Migrating content pages properties:", (Throwable)e);
        }
        int notMigratedContentPagesPropertiesCount = totalContentPagesPropertiesCount - (processedContentPagesPropertiesCount + ignoredContentPagesPropertiesCount);
        if (notMigratedContentPagesPropertiesCount != 0) {
            LOG.warn("End ContentArticlePropertiesUpgrade with some errors: total={} processed={} ignored={} error={}. It took {} ms. The not migrated news articles will be processed again next startup.", new Object[]{totalContentPagesPropertiesCount, processedContentPagesPropertiesCount, ignoredContentPagesPropertiesCount, notMigratedContentPagesPropertiesCount, System.currentTimeMillis() - startupTime});
            throw new IllegalStateException("Some content page properties weren't migrated successfully. It will be re-attempted next startup");
        }
        LOG.info("End ContentArticlePropertiesUpgrade successful migration: total={} processed={} ignored={} error={}. It took {} ms.", new Object[]{totalContentPagesPropertiesCount, processedContentPagesPropertiesCount, ignoredContentPagesPropertiesCount, notMigratedContentPagesPropertiesCount, System.currentTimeMillis() - startupTime});
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousGroupVersion) {
        SettingValue settingValue = this.settingService.get(Context.GLOBAL.id(ARTICLES_UPGRADE_PLUGIN_NAME), Scope.APPLICATION.id(ARTICLES_UPGRADE_PLUGIN_NAME), ARTICLES_UPGRADE_EXECUTED_KEY);
        if (settingValue == null || settingValue.getValue().equals("false")) {
            return false;
        }
        return super.shouldProceedToUpgrade(newVersion, previousGroupVersion);
    }

    private MetadataFilter getMetadataFilter() {
        MetadataFilter metadataFilter = new MetadataFilter();
        metadataFilter.setMetadataName(NEWS_METADATA_NAME);
        metadataFilter.setMetadataTypeName(NEWS_METADATA_NAME);
        return metadataFilter;
    }

    private NoteMetadataObject buildNoteMetadataObject(Page note, String lang, String objectType) {
        Space space = this.spaceService.getSpaceByGroupId(note.getWikiOwner());
        long spaceId = space != null ? Long.parseLong(space.getId()) : 0L;
        String noteId = String.valueOf(note.getId());
        noteId = lang != null ? noteId + "-" + lang : noteId;
        return new NoteMetadataObject(objectType, noteId, note.getParentPageId(), spaceId);
    }

    private MetadataItem getNoteMetadataItem(Page note, String lang, String objectType) {
        NoteMetadataObject noteMetadataObject = this.buildNoteMetadataObject(note, lang, objectType);
        return this.metadataService.getMetadataItemsByMetadataAndObject(NOTES_METADATA_KEY, (MetadataObject)noteMetadataObject).stream().findFirst().orElse(null);
    }
}

