/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authorization.internal;

import javax.inject.Inject;
import javax.inject.Provider;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.security.authorization.AuthorizationManagerConfiguration;
import org.xwiki.security.authorization.AuthorizationSettler;

@Component
public class AuthorizationSettlerProvider
implements Provider<AuthorizationSettler>,
Initializable {
    @Inject
    private AuthorizationManagerConfiguration authorizationManagerConfiguration;
    @Inject
    private ComponentManager componentManager;
    private AuthorizationSettler authorizationSettler;

    public void initialize() throws InitializationException {
        String settlerHint = this.authorizationManagerConfiguration.getAuthorizationSettler();
        try {
            this.authorizationSettler = (AuthorizationSettler)this.componentManager.getInstance(AuthorizationSettler.class, settlerHint);
        }
        catch (ComponentLookupException e) {
            throw new InitializationException(String.format("Unable to lookup the authorization settler hinted [%s].", settlerHint), (Throwable)e);
        }
    }

    public AuthorizationSettler get() {
        return this.authorizationSettler;
    }
}

