/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.management.operations.navigation;

import java.text.ParseException;
import java.util.List;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.description.DescriptionService;
import org.exoplatform.portal.mop.management.exportimport.NavigationExportTask;
import org.exoplatform.portal.mop.management.operations.navigation.AbstractNavigationOperationHandler;
import org.exoplatform.portal.mop.management.operations.navigation.FilteredNavigationExportResource;
import org.exoplatform.portal.mop.management.operations.navigation.NavigationKey;
import org.exoplatform.portal.mop.management.operations.navigation.NavigationUtils;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.gatein.management.api.ContentType;
import org.gatein.management.api.PathTemplateFilter;
import org.gatein.management.api.binding.BindingProvider;
import org.gatein.management.api.binding.Marshaller;
import org.gatein.management.api.exceptions.OperationException;
import org.gatein.management.api.exceptions.ResourceNotFoundException;
import org.gatein.management.api.operation.OperationContext;
import org.gatein.management.api.operation.ResultHandler;
import org.gatein.management.api.operation.model.ExportResourceModel;
import org.gatein.management.api.operation.model.ExportTask;
import org.gatein.mop.api.workspace.Navigation;
import org.gatein.mop.api.workspace.Site;

public class NavigationExportResource
extends AbstractNavigationOperationHandler {
    private static final FilteredNavigationExportResource filtered = new FilteredNavigationExportResource();

    @Override
    protected void execute(OperationContext operationContext, ResultHandler resultHandler, Navigation navigation) throws ResourceNotFoundException, OperationException {
        PathTemplateFilter filter;
        List filterAttributes = operationContext.getAttributes().getValues("filter");
        try {
            filter = PathTemplateFilter.parse((List)filterAttributes);
        }
        catch (ParseException e) {
            throw new OperationException(operationContext.getOperationName(), "Could not parse filter attributes.", (Throwable)e);
        }
        if (filter.hasPathTemplate("nav-uri")) {
            filtered.execute(operationContext, resultHandler, filter);
        } else {
            Site site = navigation.getSite();
            String navUri = operationContext.getAddress().resolvePathTemplate("nav-uri");
            SiteKey siteKey = this.getSiteKey(site);
            DescriptionService descriptionService = (DescriptionService)operationContext.getRuntimeContext().getRuntimeComponent(DescriptionService.class);
            NavigationService navigationService = (NavigationService)operationContext.getRuntimeContext().getRuntimeComponent(NavigationService.class);
            NavigationKey navigationKey = new NavigationKey(siteKey, navUri);
            NodeContext<NodeContext<?>> context = NavigationUtils.loadNode(navigationService, navigationService.loadNavigation(siteKey), navigationKey.getNavUri());
            if (context == null) {
                throw new ResourceNotFoundException("Navigation node not found for navigation uri '" + navUri + "'");
            }
            BindingProvider bindingProvider = operationContext.getBindingProvider();
            Marshaller marshaller = bindingProvider.getMarshaller(PageNavigation.class, ContentType.XML);
            NavigationExportTask exportTask = new NavigationExportTask(navigationKey, navigationService, descriptionService, (Marshaller<PageNavigation>)marshaller);
            resultHandler.completed((Object)new ExportResourceModel(new ExportTask[]{exportTask}));
        }
    }
}

