/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.management.operations.navigation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.exoplatform.portal.config.model.I18NString;
import org.exoplatform.portal.config.model.LocalizedString;
import org.exoplatform.portal.config.model.NavigationFragment;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.mop.Described;
import org.exoplatform.portal.mop.State;
import org.exoplatform.portal.mop.Utils;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.Visible;
import org.exoplatform.portal.mop.description.DescriptionService;
import org.exoplatform.portal.mop.management.operations.navigation.NavigationKey;
import org.exoplatform.portal.mop.navigation.GenericScope;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeData;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.pom.data.MappedAttributes;
import org.gatein.mop.api.Attributes;
import org.gatein.mop.api.workspace.Navigation;
import org.gatein.mop.api.workspace.ObjectType;
import org.gatein.mop.api.workspace.Page;
import org.gatein.mop.api.workspace.Site;
import org.gatein.mop.api.workspace.link.Link;
import org.gatein.mop.api.workspace.link.PageLink;

public class NavigationUtils {
    private NavigationUtils() {
    }

    public static NodeData getNodeData(Navigation navigation) {
        PageLink pageLink;
        Page target;
        List<String> children = null;
        List _children = navigation.getChildren();
        if (_children == null) {
            children = Collections.emptyList();
        } else {
            children = new ArrayList();
            for (Navigation child : _children) {
                children.add(child.getObjectId());
            }
        }
        String label = null;
        if (navigation.isAdapted(Described.class)) {
            Described described = (Described)navigation.adapt(Described.class);
            label = described.getName();
        }
        Visibility visibility = Visibility.DISPLAYED;
        Date startPublicationDate = null;
        Date endPublicationDate = null;
        if (navigation.isAdapted(Visible.class)) {
            Visible visible = (Visible)navigation.adapt(Visible.class);
            visibility = visible.getVisibility();
            startPublicationDate = visible.getStartPublicationDate();
            endPublicationDate = visible.getEndPublicationDate();
        }
        PageKey pageRef = null;
        Link link = navigation.getLink();
        if (link instanceof PageLink && (target = (pageLink = (PageLink)link).getPage()) != null) {
            Site site = target.getSite();
            pageRef = Utils.siteType((ObjectType)site.getObjectType()).key(site.getName()).page(target.getName());
        }
        Attributes attrs = navigation.getAttributes();
        NodeState state = new NodeState(label, (String)attrs.getValue(MappedAttributes.ICON), startPublicationDate != null ? startPublicationDate.getTime() : -1L, endPublicationDate != null ? endPublicationDate.getTime() : -1L, visibility, pageRef);
        Navigation parent = navigation.getParent();
        String parentId = parent != null ? parent.getObjectId() : null;
        return new NodeData(parentId, navigation.getObjectId(), navigation.getName(), state, children.toArray(new String[0]));
    }

    public static PageNavigation loadPageNavigation(NavigationKey key, NavigationService navigationService, DescriptionService descriptionService) {
        NavigationContext navigation = navigationService.loadNavigation(key.getSiteKey());
        if (navigation == null) {
            return null;
        }
        NodeContext<NodeContext<?>> node = NavigationUtils.loadNode(navigationService, navigation, key.getNavUri());
        if (node == null) {
            return null;
        }
        if (key.getNavUri() != null) {
            return NavigationUtils.createFragmentedPageNavigation(descriptionService, navigation, node);
        }
        return NavigationUtils.createPageNavigation(descriptionService, navigation, node);
    }

    public static NodeContext<NodeContext<?>> loadNode(NavigationService navigationService, NavigationContext navigation, String navUri) {
        if (navigation == null) {
            return null;
        }
        if (navUri != null) {
            String name;
            String[] path = NavigationUtils.trim(navUri.split("/"));
            NodeContext node = navigationService.loadNode(NodeModel.SELF_MODEL, navigation, GenericScope.branchShape((String[])path, (Scope)Scope.ALL), null);
            String[] stringArray = path;
            int n = stringArray.length;
            for (int i = 0; i < n && (node = node.get(name = stringArray[i])) != null; ++i) {
            }
            return node;
        }
        return navigationService.loadNode(NodeModel.SELF_MODEL, navigation, Scope.ALL, null);
    }

    public static PageNavigation createPageNavigation(DescriptionService service, NavigationContext navigation, NodeContext<NodeContext<?>> node) {
        PageNavigation pageNavigation = new PageNavigation();
        pageNavigation.setPriority(navigation.getState().getPriority().intValue());
        pageNavigation.setOwnerType(navigation.getKey().getTypeName());
        pageNavigation.setOwnerId(navigation.getKey().getName());
        ArrayList<PageNode> children = new ArrayList<PageNode>(node.getNodeCount());
        Iterator iterator = node.getNodes().iterator();
        while (iterator.hasNext()) {
            NodeContext child;
            NodeContext childNode = child = (NodeContext)iterator.next();
            children.add(NavigationUtils.createPageNode(service, childNode));
        }
        NavigationFragment fragment = new NavigationFragment();
        fragment.setNodes(children);
        pageNavigation.addFragment(fragment);
        return pageNavigation;
    }

    private static PageNavigation createFragmentedPageNavigation(DescriptionService service, NavigationContext navigation, NodeContext<NodeContext<?>> node) {
        PageNavigation pageNavigation = new PageNavigation();
        pageNavigation.setPriority(navigation.getState().getPriority().intValue());
        pageNavigation.setOwnerType(navigation.getKey().getTypeName());
        pageNavigation.setOwnerId(navigation.getKey().getName());
        ArrayList<PageNode> children = new ArrayList<PageNode>(1);
        children.add(NavigationUtils.createPageNode(service, node));
        NavigationFragment fragment = new NavigationFragment();
        StringBuilder parentUri = new StringBuilder("");
        NavigationUtils.getPath((NodeContext)node.getParent(), parentUri);
        fragment.setParentURI(parentUri.toString());
        fragment.setNodes(children);
        pageNavigation.addFragment(fragment);
        return pageNavigation;
    }

    private static void getPath(NodeContext<NodeContext<?>> node, StringBuilder parentUri) {
        if (node == null) {
            return;
        }
        if (node.getParent() == null) {
            return;
        }
        parentUri.insert(0, node.getName()).insert(0, "/");
        NavigationUtils.getPath((NodeContext)node.getParent(), parentUri);
    }

    private static PageNode createPageNode(DescriptionService service, NodeContext<NodeContext<?>> node) {
        long endPublicationTime;
        PageNode pageNode = new PageNode();
        pageNode.setName(node.getName());
        if (node.getState().getLabel() == null) {
            Map descriptions = service.getDescriptions(node.getId());
            if (descriptions != null && !descriptions.isEmpty()) {
                I18NString labels = new I18NString();
                for (Map.Entry entry : descriptions.entrySet()) {
                    labels.add((Object)new LocalizedString(((State)entry.getValue()).getName(), (Locale)entry.getKey()));
                }
                pageNode.setLabels(labels);
            }
        } else {
            pageNode.setLabel(node.getState().getLabel());
        }
        pageNode.setIcon(node.getState().getIcon());
        long startPublicationTime = node.getState().getStartPublicationTime();
        if (startPublicationTime != -1L) {
            pageNode.setStartPublicationDate(new Date(startPublicationTime));
        }
        if ((endPublicationTime = node.getState().getEndPublicationTime()) != -1L) {
            pageNode.setEndPublicationDate(new Date(endPublicationTime));
        }
        pageNode.setVisibility(node.getState().getVisibility());
        pageNode.setPageReference(node.getState().getPageRef() != null ? node.getState().getPageRef().format() : null);
        if (node.getNodes() != null) {
            ArrayList<PageNode> children = new ArrayList<PageNode>(node.getNodeCount());
            Iterator iterator = node.getNodes().iterator();
            while (iterator.hasNext()) {
                NodeContext child;
                NodeContext childNode = child = (NodeContext)iterator.next();
                children.add(NavigationUtils.createPageNode(service, childNode));
            }
            pageNode.setChildren(children);
        } else {
            pageNode.setChildren(new ArrayList(0));
        }
        return pageNode;
    }

    private static String[] trim(String[] array) {
        ArrayList<String> trimmed = new ArrayList<String>(array.length);
        for (String s : array) {
            if (s == null || "".equals(s)) continue;
            trimmed.add(s);
        }
        return trimmed.toArray(new String[trimmed.size()]);
    }
}

