/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.mop.core.api.workspace.content;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.chromattic.api.ChromatticSession;
import org.chromattic.api.annotations.Create;
import org.chromattic.api.annotations.FormattedBy;
import org.chromattic.api.annotations.Id;
import org.chromattic.api.annotations.MappedBy;
import org.chromattic.api.annotations.NamingPrefix;
import org.chromattic.api.annotations.OneToOne;
import org.chromattic.api.annotations.Owner;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.ext.format.BaseEncodingObjectFormatter;
import org.gatein.mop.api.content.ContentType;
import org.gatein.mop.api.content.Customization;
import org.gatein.mop.api.content.CustomizationContext;
import org.gatein.mop.core.api.content.ContentManagerRegistry;
import org.gatein.mop.core.api.content.CustomizationContextComparator;
import org.gatein.mop.core.api.workspace.content.AbstractCustomizationState;
import org.gatein.mop.core.api.workspace.content.ContextSpecialization;
import org.gatein.mop.core.api.workspace.content.ContextType;
import org.gatein.mop.core.api.workspace.content.ContextTypeContainer;
import org.gatein.mop.core.api.workspace.content.StateContainerImpl;
import org.gatein.mop.spi.content.ContentProvider;

@NamingPrefix(value="mop")
@FormattedBy(value=BaseEncodingObjectFormatter.class)
@PrimaryType(name="mop:customization")
public abstract class AbstractCustomization
implements Customization<Object> {
    protected static final CustomizationContextComparator comparator;
    public ContentManagerRegistry registry;
    public ChromatticSession session;

    @Id
    public abstract String getId();

    @OneToOne
    @MappedBy(value="mop:contexttypes")
    @Owner
    abstract ContextTypeContainer getContextTypes();

    @Create
    abstract ContextType create();

    @Create
    abstract ContextSpecialization createContextSpecialization();

    @OneToOne
    @MappedBy(value="mop:state")
    @Owner
    public abstract AbstractCustomizationState getCustomizationState();

    public abstract void setCustomizationState(AbstractCustomizationState var1);

    public abstract CustomizationContext getContext();

    public abstract AbstractCustomization getParent();

    private <E, I> E getVirtualState(ContentProvider<E, I> provider) {
        StateContainerImpl<E, I> container = new StateContainerImpl<E, I>(provider, this);
        Object childPayload = provider.getState(container);
        E parentPayload = null;
        AbstractCustomization parent = this.getParent();
        if (parent != null) {
            parentPayload = parent.getVirtualState(provider);
        }
        if (parentPayload != null) {
            if (childPayload != null) {
                return (E)provider.combine(Arrays.asList(parentPayload, childPayload));
            }
            return parentPayload;
        }
        return (E)childPayload;
    }

    private <E, I> E getState(ContentProvider<E, I> provider) {
        StateContainerImpl<E, I> container = new StateContainerImpl<E, I>(provider, this);
        return (E)provider.getState(container);
    }

    private <E, I> void setState(ContentProvider<E, I> provider, E state) {
        StateContainerImpl<E, I> container = new StateContainerImpl<E, I>(provider, this);
        provider.setState(container, state);
    }

    public Object getVirtualState() {
        ContentType contentType = this.getType();
        String mimeType = contentType.getMimeType();
        ContentProvider provider = this.registry.providers.get(mimeType).getProvider();
        return this.getVirtualState(provider);
    }

    public Object getState() {
        ContentType contentType = this.getType();
        String mimeType = contentType.getMimeType();
        ContentProvider provider = this.registry.providers.get(mimeType).getProvider();
        return this.getState(provider);
    }

    public void setState(Object state) {
        ContentType contentType = this.getType();
        String mimeType = contentType.getMimeType();
        ContentProvider contentProvider = this.registry.providers.get(mimeType).getProvider();
        this.setState(contentProvider, state);
    }

    public Customization<Object> getCustomization(Set<CustomizationContext> contexts) {
        return this.get(contexts, false);
    }

    public Customization<Object> customize(Collection<CustomizationContext> contexts) {
        if (contexts == null) {
            throw new NullPointerException();
        }
        return this.get(contexts, true);
    }

    public Set<CustomizationContext> getContexts() {
        AbstractCustomization current = this;
        LinkedHashSet<CustomizationContext> contexts = new LinkedHashSet<CustomizationContext>();
        while (true) {
            CustomizationContext currentContext;
            if ((currentContext = current.getContext()) == null) {
                throw new IllegalStateException("Could not resolve customization context for customization " + this);
            }
            contexts.add(currentContext);
            AbstractCustomization parent = current.getParent();
            if (parent == null) break;
            current = parent;
        }
        return contexts;
    }

    protected final Customization<Object> get(Collection<CustomizationContext> contexts, boolean create) {
        TreeSet<CustomizationContext> sortedContexts = new TreeSet<CustomizationContext>(comparator);
        Set<CustomizationContext> existingContexts = this.getContexts();
        sortedContexts.addAll(existingContexts);
        sortedContexts.addAll(contexts);
        sortedContexts.removeAll(existingContexts);
        return this.get(sortedContexts.iterator(), create);
    }

    protected final Customization<Object> get(Iterator<CustomizationContext> contexts, boolean create) {
        if (contexts.hasNext()) {
            String id;
            Map<String, ContextSpecialization> c;
            ContextSpecialization blah;
            CustomizationContext context = contexts.next();
            String type = context.getContextType();
            ContextTypeContainer typeContainer = this.getContextTypes();
            Map<String, ContextType> contextTypes = typeContainer.getContextTypes();
            ContextType tmp = contextTypes.get(type);
            if (tmp == null) {
                if (create) {
                    tmp = this.create();
                    contextTypes.put(type, tmp);
                } else {
                    return null;
                }
            }
            if ((blah = (c = tmp.getSpecializations()).get(id = context.getContextId())) != null || !create) {
                return blah;
            }
            blah = this.createContextSpecialization();
            c.put(id, blah);
            return blah.get(contexts, create);
        }
        return this;
    }

    static {
        CustomizationContextComparator _comparator;
        comparator = _comparator = new CustomizationContextComparator("workspace");
    }
}

