/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.api.relationship;

import org.reflext.api.ArrayTypeInfo;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.ParameterizedTypeInfo;
import org.reflext.api.TypeInfo;
import org.reflext.api.TypeVariableInfo;
import org.reflext.api.VoidTypeInfo;
import org.reflext.api.WildcardTypeInfo;
import org.reflext.api.relationship.TypeRelationship;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubType
implements TypeRelationship<TypeInfo, TypeInfo> {
    @Override
    public boolean isSatisfied(TypeInfo t1, TypeInfo t2) {
        return this.isSubType(t1, t2);
    }

    public boolean isSubType(TypeInfo subTI, TypeInfo superTI) {
        if (superTI instanceof ArrayTypeInfo) {
            return this.isSubType(subTI, (ArrayTypeInfo)superTI);
        }
        if (superTI instanceof ClassTypeInfo) {
            return this.isSubType(subTI, (ClassTypeInfo)superTI);
        }
        if (superTI instanceof ParameterizedTypeInfo) {
            return this.isSubType(subTI, (ParameterizedTypeInfo)superTI);
        }
        if (superTI instanceof VoidTypeInfo) {
            return this.isSubType(subTI, (VoidTypeInfo)superTI);
        }
        if (superTI instanceof TypeVariableInfo) {
            return this.isSubType(subTI, (TypeVariableInfo)superTI);
        }
        throw new AssertionError();
    }

    public boolean isSubType(TypeInfo subTI, ClassTypeInfo superCTI) {
        if (subTI instanceof ClassTypeInfo) {
            ClassTypeInfo cti = (ClassTypeInfo)subTI;
            return superCTI.isAssignableFrom(cti);
        }
        if (subTI instanceof TypeVariableInfo) {
            TypeVariableInfo tvi = (TypeVariableInfo)subTI;
            return this.isSubType(tvi.getBounds().get(0), superCTI);
        }
        if (subTI instanceof ParameterizedTypeInfo) {
            ParameterizedTypeInfo pti = (ParameterizedTypeInfo)subTI;
            return this.isSubType(pti.getRawType(), superCTI);
        }
        if (subTI instanceof WildcardTypeInfo) {
            throw new AssertionError();
        }
        return false;
    }

    public boolean isSubType(TypeInfo subTI, VoidTypeInfo superVTI) {
        return subTI instanceof VoidTypeInfo;
    }

    public boolean checkVariableExtension(TypeVariableInfo superTVI, TypeVariableInfo subTVI, TypeInfo ti) {
        if (ti instanceof ParameterizedTypeInfo) {
            ParameterizedTypeInfo pti = (ParameterizedTypeInfo)ti;
            for (int i = 0; i < pti.getTypeArguments().size(); ++i) {
                ClassTypeInfo ptiRawTypeCTI;
                TypeInfo ptiRawType;
                TypeInfo ptiTypeArg = pti.getTypeArguments().get(i);
                if (!ptiTypeArg.equals(subTVI) || !((ptiRawType = pti.getRawType()) instanceof ClassTypeInfo) || !this.isSubType((TypeInfo)(ptiRawTypeCTI = (ClassTypeInfo)ptiRawType).getTypeParameters().get(i), superTVI)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSubType(TypeInfo subTI, TypeVariableInfo superTVI) {
        if (subTI instanceof TypeVariableInfo) {
            TypeVariableInfo extendsTVI = (TypeVariableInfo)subTI;
            if (superTVI.equals(subTI)) {
                return true;
            }
            ClassTypeInfo decl = (ClassTypeInfo)extendsTVI.getGenericDeclaration();
            TypeInfo declSuperTI = decl.getSuperType();
            if (this.checkVariableExtension(superTVI, extendsTVI, declSuperTI)) {
                return true;
            }
            for (TypeInfo declInterfaceTI : decl.getInterfaces()) {
                if (!this.checkVariableExtension(superTVI, extendsTVI, declInterfaceTI)) continue;
                return true;
            }
            return false;
        }
        if (subTI instanceof ClassTypeInfo) {
            TypeInfo bound = superTVI.getBounds().get(0);
            return this.isSubType(subTI, bound);
        }
        throw new UnsupportedOperationException();
    }

    public boolean isSubType(TypeInfo subTI, ParameterizedTypeInfo superPTI) {
        return this.isSubType(subTI, superPTI.getRawType());
    }

    public boolean isSubType(TypeInfo subTI, ArrayTypeInfo superATI) {
        if (subTI instanceof ArrayTypeInfo) {
            ArrayTypeInfo extendsATI = (ArrayTypeInfo)subTI;
            return this.isSubType(extendsATI.getComponentType(), superATI.getComponentType());
        }
        return false;
    }
}

